/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "restorewizard_1.h"
#include <qdir.h>
#include <qstringlist.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <info.h>

RestoreWizard_1::RestoreWizard_1(QWidget *parent, const char *name) : QWidget(parent,name){
	// read archive folders
  config = KGlobal::config();
  config -> setGroup("Archives");
 	config -> readListEntry("Folders",archiveDirs);

	initDialog();
	QListView_1 -> setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	QListView_1 -> addColumn(i18n("Item"),220);
	QListView_1 -> addColumn(i18n(""),50);
	QListView_1 -> addColumn(i18n("Type"),80);
	QListView_1 -> addColumn(i18n("Date created"),200);
	QLabel_2 -> setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	QLabel_2 -> setAlignment(WordBreak);

	archiveDirs.setAutoDelete(true);

	if (archiveDirs.count() == 0){
		archiveDirs.insert(0,defaultArchiveDir());
		addArchives(defaultArchiveDir());
	}
	QComboBox_1 -> insertStrList(&archiveDirs);
  QComboBox_1 -> setCurrentItem(0);
	QString s(config -> readEntry("Current Folder"));
	if (s != QString(""))
		addArchives(s);
	//
	connect(QPushButton_1, SIGNAL(clicked()), SLOT(slotDeleteArchive()));
	connect(QPushButton_2, SIGNAL(clicked()), SLOT(slotBrowse()));
	connect(QComboBox_1,SIGNAL(activated(int)),SLOT(slotChangeArchiveFolder(int)));
	connect(QListView_1,SIGNAL(selectionChanged(QListViewItem*)),SLOT(slotSelectionChanged(QListViewItem *)));
}

RestoreWizard_1::~RestoreWizard_1(){
}

void RestoreWizard_1::init(){

}

void RestoreWizard_1::addArchives(const QString s){
	QComboBox_1 -> setCurrentItem(archiveDirs.find(s));
  config -> setGroup("Archives");
	config -> writeEntry("Current Folder",s);
	QListView_1 -> clear();
	QString s_1,s_2, s_3, s_4;
	QString fn,tp;
	QDir d(s);
	QStringList * l = new QStringList(d.entryList());
	KIconLoader icnl;
	for (unsigned int i = 0; i < l -> count(); i++){
		QFileInfo fi(s + *l -> at(i));
		if (fi.fileName().right(5) == ".info"){
			KSimpleConfig cfg(fi.absFilePath());
			if (cfg.readBoolEntry("Archive"))
				tp = i18n("Archive");
			else
				tp = i18n("Backup");
			fn = s + fi.fileName().left(fi.fileName().length() - 5);
			QFileInfo fi_2(fn);
			QString n;
			n.setNum(cfg.readNumEntry("Number of Files"));
			QListViewItem *item = new QListViewItem(
				QListView_1," " + cfg.readEntry("Name"),
					n,
					tp,
					fi_2.lastModified().toString(),
					fn,
					cfg.readEntry("Archive Root"));
			QPixmap p(icnl.loadIcon(QString(cfg.readEntry("Icon")), KIcon::Small));
			item -> setPixmap(0,p);
		}
	}
	delete l;
}

void RestoreWizard_1::slotBrowse(){
	QString s(KFileDialog::getExistingDirectory());
	if ( s != NULL){
		if (archiveDirs.find(s) == -1){
			archiveDirs.insert(0,s);
			QComboBox_1 -> insertItem(s,0);
			while (archiveDirs.count() > 10)
				archiveDirs.removeLast();
		  KConfig * cfg = KGlobal::config();
		  cfg -> setGroup("Archives");
			cfg -> writeEntry("Folders",archiveDirs);
			cfg -> sync();
		}
		while (QComboBox_1 -> count() > 10)
			QComboBox_1 -> removeItem(QComboBox_1 -> count()-1);
		addArchives(s);
	}
}

void RestoreWizard_1::slotChangeArchiveFolder(int i){
	QString s(QComboBox_1 -> text(i));
	addArchives(s);
}

void RestoreWizard_1::slotSelectionChanged(QListViewItem * i){
	KSimpleConfig cfg(QString(i -> text(4)) + ".info");
	QStrList sl;
	cfg.readListEntry("Files",sl);
	QString t;
	for (uint i=0; i < sl.count(); i++){
			t += sl.at(i);
		if (i < sl.count() - 1)
			t += ", ";
	}
	if (sl.count() == 10)
		t += ",...";
	else
		t += ".";
	QLabel_2 -> setText(t);
}

void RestoreWizard_1::slotDeleteArchive(){
	if (QListView_1 -> currentItem() != 0){
		if (KMessageBox::questionYesNo(0,i18n("Are you sure you want to delete this Archive?")) == KMessageBox::Yes){
			QString c("rm '");
			c += QListView_1 -> currentItem() -> text(4) + QString("'");
			c += " '" + QString(QListView_1 -> currentItem() -> text(4)) + ".info'";
			system(c);
			delete QListView_1 -> currentItem();
		}
	}
	else
		KMessageBox::information(0,i18n("Select an archive first"));
}

void RestoreWizard_1::enableItems(bool b){
	QListView_1 -> setEnabled(b);
	QListViewItem *item = QListView_1 -> firstChild();
	while (item != 0L){
		item -> setSelectable(b);
		item = item -> nextSibling();
	}
}