/***************************************************************************
                          ins.cpp  -  description
                             -------------------
    begin                : Sun Nov 12 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ins.h"

#include <qtextstream.h>

#include "info.h"

INS::INS(QString s){
	bfn = s;
	setName(s);
	setType(TYPE_INS);
}

INS::~INS(){
}

void INS::loadFiles(){
	unloadFiles();
	QFile f(insDir() + baseFileName() + ".files");
	if (f.open(IO_ReadOnly)){
		QTextStream t(&f);
		while (!t.eof())
			addFileFast (t.readLine());
		f.close();
	}
}

QString INS::partOfName(unsigned int i){
	unsigned int index = 0;
	unsigned int index_1, index_2;
	
	QString s(name());
	for (unsigned int t = 0; t <= i; t++){
		while (s.mid(index,1) != "%" && index < s.length() - 1 )
			index++;
		index++;
		index_1 = index;
		while (s.mid(index,1) != "%" && index < s.length())
			index++;
		index_2 = index;
	}
	return s.mid(index_1,index_2 - index_1);
}

ABProcess * INS::unInstall(){
	ABProcess * p = new ABProcess("rm");
	*p << "rm";
	*p << "-vf";
	for (unsigned int i = 0; i< numFiles(); i++)
		*p << file(i);
	return p;
}
