/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "buttonandtext.h"

#include <qfont.h>

ButtonAndText::ButtonAndText(QWidget * parent, const char * t1, const char * t2 ) : QWidget (parent)
{
	unsigned int label_width = 180;
	unsigned int title_height = 20;
	unsigned int text_height = 60;


	QFont bold = QFont();
	bold.setWeight(QFont::Bold);
	title = new QLabel(this);
	title -> setFont(bold);
	title -> setText(t1);
	title -> setGeometry(120, 0, label_width, title_height);

	text = new QLabel(this);
	text -> setText(t2);
	text -> setGeometry(120, title_height, label_width, text_height);
	text -> setAlignment(WordBreak);

	button = new QPushButton(this);
	button -> setGeometry(0,0,100,30);
}

ButtonAndText::~ButtonAndText(){
}









