/***************************************************************************
                          kbconfig.cpp  -  description
                             -------------------
    begin                : Sun Jul 8 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <kglobal.h>
#include <kstddirs.h>
#include <kdebug.h>
#include <qpainter.h>

#include "kbconfig.h"
#include "xkeyboard.h"

KBConfig::KBConfig() : m_groups(XKeyboard::self()->getNumKbdGroups()),
  m_toggle_mode(false)
{
  m_groups.setAutoDelete(true);
}

KBConfig::~KBConfig(){
}

/** load the KBSwitch configration from the application KConfig object */
void KBConfig::load(KConfig *config){
  XKeyboard *xkb = XKeyboard::self();
  QStringList list;
  xkb->getGroupNames(list);
  int i = 0;
  QString name;
  for (QStringList::Iterator iter = list.begin(); iter != list.end(); iter++, i++) {
    name = *iter;
    if (name == QString::null) name = i18n("<Unnamed>");
    m_groups.insert(i, new KBGroup(name));
  }
  loadConfiguredPixmaps(config);
  guessGroupPixmaps();
  drawDefaultPixmaps();
  config->setGroup(OPTIONS_SECTION);
  m_toggle_mode = config->readBoolEntry(TOGGLE_MODE_ENTRY);
}

/** No descriptions */
void KBConfig::guessGroupPixmaps(){
  KGlobal::dirs()->addResourceDir("appdata", ".");
  KConfig map("group_names", true, true, "appdata");
  map.setGroup("Mapping");
  QString path, code;
  QPixmap pix;

  for (unsigned int i = 0; i < m_groups.count(); i++) {
    if (m_groups[i]->getPixmap().isNull()) {
      code = map.readEntry(m_groups[i]->getName());
      if (!code.isEmpty()) {
        path = locate("locale", QString("l10n/%1/flag.png").arg(code));
        if (!path.isEmpty() && pix.load(path)) m_groups[i]->setPixmap(pix);
      }
    }
  }
}

/** No descriptions */
void KBConfig::drawDefaultPixmaps(){
  QPixmap pix(16, 16);
  QPainter painter(&pix);

  for (unsigned int i = 0; i < m_groups.count(); i++) {
    if (m_groups[i]->getPixmap().isNull()) {
      pix.fill();
      painter.drawText(0, 0, pix.width(), pix.height(),
        Qt::AlignHCenter | Qt::AlignVCenter, QString::number(i+1));
      m_groups[i]->setPixmap(pix);
    }
  }
}

/** No descriptions */
void KBConfig::loadConfiguredPixmaps(KConfig *config){
  QString path;
  QPixmap pix;
  config->setGroup(ICONS_SECTION);
  for (unsigned int i = 0; i < m_groups.count(); i++) {
    path = config->readEntry(entryForGroup(i));
    if (!path.isEmpty() && pix.load(path))
      m_groups[i]->setPixmap(pix);
  }
}

/** No descriptions */
void KBConfig::notifyChanged(){
  emit changed();
}
