/***************************************************************************
                          kimedialogs.cpp  -  description
                             -------------------
    begin                : Tue Apr 17 2001
    copyright            : (C) 2001 by Jan Schfer
    email                : j_schaef@informatik.uni-kl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// QT
//#include <qstring.h>
#include <qmultilineedit.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qtable.h>
#include <qgroupbox.h>
#include <qspinbox.h>
//#include <qwidget.h>
// KDE
#include <kiconloader.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kdebug.h>
#include <kapp.h>

// LOCAL
#include "kimedialogs.h"

AreaDialog::AreaDialog(QWidget* parent,Area * a)
	: KDialogBase(parent,"",true,"Area Tag Editor",Ok|Apply|Cancel,Ok,true)
{
	if (!a) slotCancel();
	
	QWidget *page=new QWidget(this);
	setMainWidget(page);
	QGridLayout *layout = new QGridLayout(page,4,2,5,5);
	area=a;
	QString shape=i18n("Default");
	QString coords="";
	QString href="";
	QString alt="";
	areaCopy= new Area(*a);
	
	coords=a->coordsToString();
	href=a->href();
	alt=a->alt();
	
	coordsEdit = new QMultiLineEdit(page);
	coordsEdit->setWordWrap(QMultiLineEdit::WidgetWidth);
	layout->addWidget(coordsEdit,2,2);
	
	QLabel *lbl=new QLabel(i18n("C&oordinates"),page);
	lbl->setBuddy(coordsEdit);
	layout->addWidget(lbl,2,1,Qt::AlignTop | Qt::AlignLeft);
	
	
	switch (a->type()) {
		case Area::Rectangle : shape=i18n("Rectangle");break;
		case Area::Circle : shape=i18n("Circle");break;
		case Area::Polygon : shape=i18n("Polygon");break;
		case Area::Default :
			shape=i18n("Default");
			coordsEdit->hide();
			lbl->hide();
			
		break;
		default : break;
	}
	
	layout->addWidget(new QLabel(i18n("Shape"),page),1,1);
	layout->addWidget(new QLabel(shape,page),1,2);
	
	coordsEdit->insertLine(coords);
	

	QHBox *hbox= new QHBox(page);
	hrefEdit = new QLineEdit(href,hbox);
	QPushButton *btn = new QPushButton("",hbox);
	btn->setPixmap(SmallIcon("fileopen"));
	connect( btn, SIGNAL(pressed()), this, SLOT(slotChooseHref()));
	
	layout->addWidget(hbox,3,2);
	lbl=new QLabel("&HREF",page);
	lbl->setBuddy(hrefEdit);
	layout->addWidget(lbl,3,1);
	
	altEdit = new QLineEdit(alt,page);
	layout->addWidget(altEdit,4,2);
	
	lbl=new QLabel(i18n("Alt. &Text"),page);
	lbl->setBuddy(altEdit);
	layout->addWidget(lbl,4,1);
	
}

AreaDialog::~AreaDialog() {
}

void AreaDialog::slotChooseHref() {
	KURL url=KFileDialog::getOpenURL(QString::null,"*|All files",this,i18n("Choose a file"));
	if (!url.isEmpty()) {
		hrefEdit->setText(url.url());
	}
}

void AreaDialog::slotOk() {
	if (area) {
		area->setHREF(hrefEdit->text());
		area->setCoords(coordsEdit->text());
		area->setAlt(altEdit->text());
		emit areaChanged(area);
	}	
	KDialogBase::slotOk();
}

void AreaDialog::slotApply() {
	if (area) {
		area->setHREF(hrefEdit->text());
		area->setCoords(coordsEdit->text());
		area->setAlt(altEdit->text());
		emit areaChanged(area);
	}	
	KDialogBase::slotApply();
}

void AreaDialog::slotCancel() {
	if (area) {
		area->setArea(*areaCopy);
		emit areaChanged(area);
	}
	KDialogBase::slotCancel();
}

ImageMapChooseDialog::ImageMapChooseDialog(QWidget* parent,QList<MapTag> *_maps,QList<ImageTag> *_images,const KURL & _baseUrl)
	: KDialogBase(parent,"",true,"Choose the map and image to edit",Ok,Ok,true)
{
	baseUrl=_baseUrl;
	maps=_maps;
	images=_images;
	currentMap=0L;
	QWidget *page=new QWidget(this);
	setMainWidget(page);
	setCaption(baseUrl.fileName());
	QVBoxLayout *layout = new QVBoxLayout(page,5,5);
	
	QLabel *lbl= new QLabel(i18n("Select an image and/or a map that you want to edit"),page);
  lbl->setFont(QFont("Helvetica",14,QFont::Bold));
  layout->addWidget(lbl);
	QFrame *line= new QFrame(page);
	line->setFrameStyle(QFrame::HLine  | QFrame::Sunken);
	line->setFixedHeight(10);
	layout->addWidget(line,0);	
	
	QGridLayout *gridLayout= new QGridLayout(layout,2,3,5);
	gridLayout->setRowStretch(0,0);
	gridLayout->setRowStretch(1,100);
	lbl=new QLabel(i18n("&Maps"),page);
	mapListBox= new QListBox(page);
	lbl->setBuddy(mapListBox);
	gridLayout->addWidget(lbl,0,0);
	gridLayout->addWidget(mapListBox,1,0);
	
	line= new QFrame(page);
	line->setFrameStyle(QFrame::VLine | QFrame::Sunken);
	line->setFixedWidth(10);
//	line->setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Expanding));
	gridLayout->addWidget(line,1,1);
	
	lbl=new QLabel(i18n("Image Preview"),page);
	gridLayout->addWidget(lbl,0,2);
	
	imagePreview= new QLabel(page);
	imagePreview->setFixedSize(310,210);
	imagePreview->setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Expanding));
	imagePreview->setFrameStyle(QLabel::Panel | QLabel::Sunken);
	imagePreview->setIndent(5);
	imagePreview->setBackgroundColor(QColor("white"));
//	imagePreview->setLineWidth(2);
//	imagePreview->setScaledContents(true);
//	lbl= new QLabel(i18n("&Maps"),page);
//	lbl->setBuddy(mapListBox);
	gridLayout->addWidget(imagePreview,1,2);
//	layout->addLayout(gridLayout,1);

	line= new QFrame(page);
	line->setFrameStyle(QFrame::HLine  | QFrame::Sunken);
	line->setFixedHeight(10);
	layout->addWidget(line,0);			
	
	imageListTable= new QTable(images->count(),2,page);
	imageListTable->horizontalHeader()->setLabel(0,"src");
	imageListTable->horizontalHeader()->setLabel(1,"usemap");
	imageListTable->verticalHeader()->hide();
	imageListTable->setLeftMargin(0);
	imageListTable->setSelectionMode(QTable::NoSelection);
//	imageListTable->clearSelectioN(true);
	
	lbl= new QLabel(i18n("&Images"),page);
	lbl->setBuddy(imageListTable);
	layout->addWidget(lbl);
	layout->addWidget(imageListTable);
/*	
	hbox= new QHBox(page);
	hbox->setSpacing(5);
	lbl = new QLabel(i18n("Map &name"),hbox);
	mapNameEdit= new QLineEdit(hbox);
	lbl->setBuddy(mapNameEdit);
	layout->addWidget(hbox);
*/	
	for (MapTag *tag = maps->first(); tag!=0L; tag=maps->next()) {
		mapListBox->insertItem(tag->name);
	}
	
	int row=0;
	for (ImageTag *tag = images->first(); tag!=0L; tag=images->next()) {
		QString src="";
		QString usemap="";
		if (tag->find("src"))
			src=*tag->find("src");
		if (tag->find("usemap"))
			usemap=*tag->find("usemap");
		
		imageListTable->setText(row,0,src);
		imageListTable->setText(row,1,usemap);
		row++;
	}

	connect (imageListTable, SIGNAL(selectionChanged()), this, SLOT(slotImageChanged()));
	connect (mapListBox, SIGNAL(highlighted(int)), this, SLOT(slotMapChanged(int)));
	
	resize(510,400);
}

ImageMapChooseDialog::~ImageMapChooseDialog() {
}

void ImageMapChooseDialog::slotImageChanged() {
	int i=imageListTable->currentRow();
	QImage pix;
	if (images->at(i)->find("src")) {
		QString str=*images->at(i)->find("src");
		// relative url
		pixUrl=KURL(baseUrl,str);
		pix=QImage(pixUrl.path());	
		double zoom1=1;
		double zoom2=1;
		if (pix.width()>300)
			zoom1=(double) 300/pix.width();
		if (pix.height()>200)
			zoom2=(double) 200/pix.height();
			
						
		zoom1= zoom1 < zoom2 ? zoom1 : zoom2;
		pix=pix.smoothScale(pix.width()*zoom1,pix.height()*zoom1);
	}
	QPixmap pix2;
	pix2.convertFromImage(pix);
	imagePreview->setPixmap(pix2);
	
//	imagePreview->repaint();
}

void ImageMapChooseDialog::slotMapChanged(int i) {
	currentMap=maps->at(i);
}

PreferencesDialog::PreferencesDialog(QWidget *parent)
	: KDialogBase(parent,"",true,i18n("Preferences"),Ok|Apply|Cancel,Ok,true)
{
	QVBox *page=new QVBox(this);
	setMainWidget(page);
	
	QHBox *hbox= new QHBox(page);
 	
	(void)new QLabel(i18n("Maximum image preview  height")+" ",hbox);
	rowHeightSpinBox = new QSpinBox(hbox);
	
	kapp->config()->setGroup("Appearance");
	rowHeightSpinBox->setMaxValue(1000);
	rowHeightSpinBox->setMinValue(15);
	rowHeightSpinBox->setValue(kapp->config()->readNumEntry("maximum-preview-height",50));
}

PreferencesDialog::~PreferencesDialog() {
}

void PreferencesDialog::slotDefault( void ) {
//	rowHeightSpinBox->setValue(50);	
}

void PreferencesDialog::slotOk( void ) {
	slotApply();
  accept();
}

void PreferencesDialog::slotApply( void ) {
	kdDebug() << rowHeightSpinBox->value() << endl;
	kapp->config()->setGroup("Appearance");
	kapp->config()->writeEntry("maximum-preview-height",rowHeightSpinBox->value());
	kapp->config()->sync();
	emit applyClicked();
}
