/***************************************************************************
                          imagemapdialog.h  -  description
                             -------------------
    begin                : Wed Apr 4 2001
    copyright            : (C) 2001 by Jan Schfer
    email                : j_schaef@informatik.uni-kl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KIMAGEMAPDIALOG_H
#define KIMAGEMAPDIALOG_H

#include <kmainwindow.h>
#include <qlist.h>
#include <qrect.h>
#include <qpoint.h>
#include <qdict.h>
#include <kurl.h>

/**
  *@author Jan Schfer
  */

#define VERSION "0.9"

class QListView;
class QPushButton;
class DrawZone;
class QPainter;
class QPointArray;
class QComboBox;
class QListViewItem;

typedef QList<QRect> SelectionPointList;

class Area
{
public:
	enum ShapeType { None, Rectangle, Circle, Polygon, Default };
private:
	QRect _rect;
	ShapeType _type;
	QString _name;
	QString _href;
	QString _alt;
	bool _isSelected;
	bool _finished;
	QListViewItem* _listViewItem;
	// Only used for Polygons
	QPointArray *_coords;
	SelectionPointList *_selectionPoints;
	void updateSelectionPoints();
	
public:
	Area(ShapeType=None);
	Area(const Area & copy);
	~Area();
	void setArea(const Area & copy);
	void setListViewItem(QListViewItem* item);
	QListViewItem* listViewItem() const;
	void setRect(const QRect & r);
	void addCoord(const QPoint & p);
	bool setCoords(const QString & s);
	void moveBy(int dx, int dy);
	void moveTo(int x, int y);
	QPointArray* coords() const;
	QRect rect() const;
	QRect selectionRect() const;
	ShapeType type() const;
	void setName(const QString & name);
	QString name() const;
	void setHREF(const QString & href);
	QString href() const;
	void setAlt(const QString & alt);
	QString alt() const;
	void setSelected(bool b);
	bool isSelected() const;
	/** finished drawing only important for polygon */
	void setFinished(bool b);
	bool finished() const;
	void draw(QPainter & p);
	QRect* onSelectionPoint(const QPoint & p) const;
	SelectionPointList* selectionPoints() const;
	uint countSelectionPoints() const;
	void moveSelectionPoint(QRect* selectionPoint, const QPoint & p);
	bool contains(const QPoint & p) const;
	QString coordsToString() const;
	QPixmap cutOut(const QImage & p) const;
	QString getHTMLCode() const;
};

inline SelectionPointList* Area::selectionPoints() const {
	return _selectionPoints;
}

inline QPointArray* Area::coords() const {
	return _coords;
}


inline QListViewItem* Area::listViewItem() const {
	return _listViewItem;
}


inline QRect Area::rect() const {
	return _rect;
}

inline Area::ShapeType Area::type() const {
	return _type;
}

inline void Area::setName(const QString & name) {
	_name=name;
}

inline QString Area::name() const {
	return _name;
}


inline void Area::setHREF(const QString & href) {
	_href=href;
}

inline QString Area::href() const {
	return _href;
}

inline void Area::setAlt(const QString & alt) {
	_alt=alt;
}

inline QString Area::alt() const {
	return _alt;
}


inline bool Area::isSelected() const {
	return _isSelected;
}


inline bool Area::finished() const {
	return _finished;
}


typedef QList<Area> AreaList;
/**
 * Stores an area tag and all its attributes
 */
typedef QDict<QString> AreaTag;
/**
 * Stores an image tag and all its attributes
 */
typedef QDict<QString> ImageTag;

/**
 * Only a small class to give a list of AreaTags a name
 */
class MapTag : public QList<AreaTag> {
	public:
		QString name;
};

class KSelectAction;
class KRadioAction;
class KRecentFilesAction;
class KAction;
class QListViewItem;
class QPopupMenu;

#define STATUS_CURSOR 1000
#define STATUS_SELECTION 1001

class KImageMapEditor : public KMainWindow {
Q_OBJECT
private:
	// the url where the map is stored e.g. a HTML or TXT file
	KURL _mapUrl;	
	// the url of the working image;
	KURL _imageUrl;
	QString _mapName;
	Area::ShapeType _currentShapeType;
	AreaList *areas;
	Area *currentSelected;
	Area *copyArea;
	Area *defaultArea;
	DrawZone* drawZone;
	QListView* listView;
	KAction* saveAction;
	KRecentFilesAction* recentFilesAction;
	KSelectAction* zoomAction;
	KRadioAction *arrowAction;
	KRadioAction *circleAction;
	KRadioAction *rectangleAction;
	KRadioAction *polygonAction;
	KAction *cutAction;
	KAction *copyAction;
	KAction *pasteAction;
	KAction *zoomInAction;
	KAction *zoomOutAction;
	KAction *areaPropertiesAction;
	QPopupMenu *popupMenu;
	bool _stdout; // write HTML-Code to stdout on exit ?
	int maxAreaPreviewHeight;
	void setupActions();
	void setupStatusBar();
	void saveImageMap(const KURL & url);
	/* refreshes all Areas, only used by preferences dialog
	 * updates only the preview pictures*/
	void updateAllAreas();	
	void deleteAllAreas();
	QDict<QString> getTagAttributes(QTextStream & s);
	
protected:
  virtual void saveProperties(KConfig *);
  virtual void readProperties(KConfig *);
  virtual bool queryClose();
//  virtual bool queryExit();
public:
	KImageMapEditor(QWidget* parent=0);
	~KImageMapEditor();
	void setPicture(const KURL & url);
	void setPicture(const QImage & pix);
	QPixmap makeListViewPix(const Area & a) const;
	void addAreaAndEdit(Area*);
	void addArea(Area*);
	void deleteArea(Area*);
	AreaList* areaList() const;
	Area::ShapeType currentShapeType() const;
	Area* selected() const;
	void select(Area* s);
	void deselectAll();
	Area* onArea(const QPoint & p) const;
	void showTagEditor(Area *a);
	QString getHTMLImageMap() const;
	QString mapName() const;
	void setMapName(const QString & s);
	KURL url() const;
	void setUrl(const KURL & s);
	void setStdout(bool b);
	void openHTMLFile(const KURL & url);
public slots:
	void slotChangeStatusCoords(int x,int y);
	void slotAreaChanged(Area *);
	void slotOpenFile(const KURL & url);
	void slotShowPopupMenu(const QPoint & pos);
protected slots:
	void slotShowPopupMenu(QListViewItem*,const QPoint &);
	void slotShowPreferences();
	void select(QListViewItem*);
	void showTagEditor(QListViewItem *item);
	void showTagEditor();
	void slotConfigChanged();
	void slotOpenFile();
	void slotSaveFile();
	void slotSaveFileAs();
  void slotZoom();
  void slotZoomIn();
  void slotZoomOut();
  void slotDrawArrow();
  void slotDrawCircle();
  void slotDrawRectangle();
  void slotDrawPolygon();
  void slotEditDefaultArea();
  void slotEditMapName();
  void slotShowHTML();
	void slotCut();
	void slotCopy();
	void slotPaste();
  void slotEditKeys();
	void slotEditToolbars();
	void slotToggleToolbar();
	void slotToggleStatusbar();

//	void slotPreferences();


};

inline AreaList* KImageMapEditor::areaList() const {
	return areas;
}

inline Area::ShapeType KImageMapEditor::currentShapeType() const {
	return _currentShapeType;
}

inline QString KImageMapEditor::mapName() const {
	return _mapName;
}

inline void KImageMapEditor::setMapName(const QString & s) {
	_mapName=s;
}

inline KURL KImageMapEditor::url() const {
	return _mapUrl;
}

inline void KImageMapEditor::setUrl(const KURL & url) {
	_mapUrl=url;
}

inline void KImageMapEditor::setStdout(bool b) {
	_stdout=b;
}

#endif
