/***************************************************************************
                          filegest.cpp  -  description            
                                      -------------------                     
    begin                : lun mai  3 20:19:52 CEST 1999
                                           
    copyright            : (C) 1999 by Franois Dupoux                         
    email                : fdupoux@lemel.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kfilecoder.h"
#include "filegest.h"
#include <qdir.h>

 
// ========================================================================================
// Return the name of the file, not the path, then only file name + extension
// Paramtres:...........* szName: pointer (char *) to the destiation filename
//                       * szFullPath: pointer (char *) to the full path of the file
// Valeurs retournes:...*  0 if success
//                       * -1 if error
// ========================================================================================
int GetFileName(char *szName, char *szFullPath)
{	int i, j;

	szName[0] = NULL; // End of the string
	
	if ( strstr(szFullPath, "/") == NULL) // If the is no '/' in the path: only copy the string
	{	strcpy(szName, szFullPath);
   	return 0;
	}

	int len = strlen(szFullPath);

	for(i=len; szFullPath[i] != '/' && i != 0; i--); // Begin of name = char[i]
	i++; // Go after the '/'	

	for(j=i; szFullPath[j] ; j++) // Copy the file name to szName
		szName[j-i] = szFullPath[j];

	szName[j-i] = NULL;

	return 0;
}


// ========================================================================================
// Return the path of the file, not the name, then for example: "/root/file.txt" --> "/root"
// Paramtres:...........* szPath: pointer (char *) to the destiation filepath
//                       * szFullPath: pointer (char *) to the full path of the file
// Valeurs retournes:...*  0 if success
//                       * -1 if error
// ========================================================================================
int GetFilePath(char *szPath, char *szFullPath)
{	int i, j;

	szPath[0] = NULL; // End of the string
	
	if ( strstr(szFullPath, "/") == NULL) // If the is no '/' in the path: only copy the string
	{	return -1;
	}

	int len = strlen(szFullPath);

	for(i=len; szFullPath[i] != '/' && i != 0; i--); // Begin of name = char[i]

	for(j=0; j < i ; j++) // Copy the file name to szName
		szPath[j] = szFullPath[j];

	szPath[j] = NULL; // End of the string

	return 0;
}

// ========================================================================================
// Return the CRC of a file
// Paramtres:...........* szFilename: Path of the file we need the CRC
//                       * nFileCrc: Adresse of the Int where the CRC must be written
// Valeurs retournes:...*  0 if success
//                       * -1 if error
// ========================================================================================
int CalculateCRCOfFile(char *szFilename, uint *nFileCRC)
{
	QFile f;
	bool bRes;

	f.setName(szFilename);

	bRes = f.open(IO_ReadOnly);
	if (bRes == false)
		return -1; // Error

	int nCRC = 0;
	uint i;
	int car;
	
	for (i = 0; i < f.size(); i++)
	{	car = f.getch();
		nCRC += car;
	
	}

	*nFileCRC = nCRC;
	return 0; // Success
}

// ========================================================================================
// Create all directories of the path szfullPath
// Paramtres:...........* szDirectory: pointer to the filepath of the directory to create
// Valeurs retournes:...*  0 if success
//                       * -1 if error
// ========================================================================================
int CreateAllDirsOfPath(char *szDirectory)
{
	char *ptr;
	char szPath[MAXPATHLEN];
	QDir qDir;

	strcpy(szPath, szDirectory);
	ptr = szPath; // points to start of szDirectory
	
	while (*ptr)
	{	if (*ptr == '/')
		{	*ptr = 0;
			
			// CreateDirectory if it doesn't exists
			if (!qDir.exists(szPath, TRUE))
			{	qDir.mkdir (szPath, TRUE);
			}

			*ptr = '/';  // Restore the string
		}

		ptr++; // Caractre suivant
	}
	
	// CreateDirectory if it doesn't exists
	if (!qDir.exists(szDirectory, TRUE))
	{	qDir.mkdir (szDirectory, TRUE);
	}

	return 0;
}

















