//
//  Copyright (C) 1998 Matthias Hoelzer
//  email:  hoelzer@physik.uni-wuerzburg.de
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the7 implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


#include <kapp.h>

#include "kinputline.h"
#include "kinputline.moc"
#include "klocale.h"


KInputLine::KInputLine(QWidget *parent, const char *name, bool modal, int w, QString text, QString init) 
  : QDialog(parent,name,modal)
{
  int width = w * fontMetrics().width("x");

  label = new QLabel(text, this);
  label->adjustSize();
  
  if (label->width() > width)
    width = label->width();

  ok = new QPushButton(i18n("&Ok"), this);
  cancel = new QPushButton(i18n("&Cancel"), this);
  ok->adjustSize();
  cancel->adjustSize();
  
  int btn_width = ok->width();
  if (cancel->width() > btn_width)
    btn_width = cancel->width();

  if (8+2*btn_width > width)
    width = 8+2*btn_width;

  lineedit = new QLineEdit(this);
  lineedit->setGeometry(8,label->height()+16, width, lineedit->height());
  lineedit->setText(init);

  label->move((width - label->width())/2, 8);    

  int btn_height = 24+label->height()+lineedit->height();
  ok->setGeometry(width/2 - btn_width - 8, btn_height+8, btn_width, ok->height());
  cancel->setGeometry(width/2 + 8, btn_height+8, btn_width, ok->height());

  ok->setDefault(TRUE);

  connect(ok, SIGNAL(pressed()), this, SLOT(accept()));
  connect(cancel, SIGNAL(pressed()), this, SLOT(reject()));

  adjustSize();
  setFixedSize(this->width(), this->height());
}
