//
//  Copyright (C) 1998 Matthias Hoelzer
//  email:  hoelzer@physik.uni-wuerzburg.de
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the7 implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


#ifndef _FRAME_H_
#define _FRAME_H_


#include <qstrlist.h>
#include <qdstream.h>


//#include <ktopwidget.h>
#include <kmainwindow.h>


class KDialogFrame : public KMainWindow {

public: 

  KDialogFrame(QDataStream *ret);
  
  void resizeEvent(QResizeEvent *);
  
  void processArgs(QStrList args);
  void processGauge(QStrList args);
  
private:

  QLabel *backtitle;
  QString title;
  QWidget *persistantWidget;
  QDataStream *retStream;
  bool separateOutput;
  QString gaugeText;
  bool xxx;
      
  void sendReturn(int type, int code, QString string);
    
  void yesno(QString text, QString width, QString height);
  void msgbox(QString text, QString width, QString height);
  void infobox(QString text, QString width, QString height);
  void inputbox(QString text, QString width, QString height, QString init);
  void textbox(QString file, QString width, QString height);
  void menu(QString text, QString width, QString height, QString menuheight, QStrList args, int index);
  void checklist(QString text, QString width, QString height, QString menuheight, QStrList args, int index);
  void radiobox(QString text, QString width, QString height, QString menuheight, QStrList args, int index);
  void gauge(QString text, QString width, QString height, QString percent);
 
};


#endif
