//
//  Copyright (C) 1998 Matthias Hoelzer
//  email:  hoelzer@physik.uni-wuerzburg.de
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the7 implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


#include <fcntl.h>
#include <unistd.h>
#include <stream.h>

#include <qlist.h>
#include <qfile.h>
#include <qdstream.h>
#include <qregexp.h>
#include <kmessagebox.h>
#include <kapp.h>
//#include <ktopwidget.h>
#include <kmainwindow.h>

#include "widgets.h"

#include <klocale.h>
#include <qdialog.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>

QString title;
bool separateOutput = FALSE;

static KCmdLineOptions options[] =
{
    { "kexit", I18N_NOOP("Exit server"), 0 },
    { "title <text>", I18N_NOOP("Dialog title"), 0 },
    { "separate-output", I18N_NOOP(""), 0 },
    { "yesno <text>", I18N_NOOP("Yes or No dialog"), 0 },
    { "msgbox <text>", I18N_NOOP("Message Box dialog"), 0 },
    { "inputbox <text> <width> <height> <init>", I18N_NOOP("Input Box dialog"), 0 },
    { "textbox <file> <width> <height>", I18N_NOOP("Text Box dialog"), 0 },
    { "menu <text> <width> <height> <menuheight> [tag item]", I18N_NOOP("Menu dialog"), 0 },
    { "checklist <text> <width> <height> <menuheight> [tag item status]", I18N_NOOP("Check List dialog"), 0 },
    { "radiolist <text> <width> <height> <menuheight> [tag item status]", I18N_NOOP("Radio List dialog"), 0 },
    { "kid", I18N_NOOP("Dialog title"), 0 },
    { "+[arg]", 0, 0 },
    KCmdLineLastOption
};

int callServer(KCmdLineArgs *args) 
{
  int result;
  QString msg;
  QStrList arglist;
  char buffer[255];

  // check if called with the right parameters
  if (args->count() < 2)
  {
    cerr << i18n("kdialog: wrong parameters") << endl;
    return -1;
  }

  // open the argument pipe
  QFile ap(args->arg(0));
  if (!ap.open(IO_WriteOnly))
  {
    cerr << i18n("kdialog: could not open argument pipe ") << args->arg(0) << endl;
    return -1;
  }
  QDataStream as(&ap);

  // open the return pipe
  QFile rp(args->arg(1));
  if (!rp.open(IO_ReadWrite))
  {
    cerr << i18n("kdialog: could not open return pipe ") << args->arg(1) << endl;
    return -1;
  }
  QDataStream rs(&rp);

  // do not wait for termination of server
  if (args->isSet("kexit")) {
      arglist.append("--kexit");
      as << arglist;
      ap.flush();
      exit(0);
  } else {
      // pipe the arguments to the server
      for (int i = 2; i < args->count(); i++) {
          QString text = args->arg(i);
          int pos;
          while ((pos = text.find("\\n")) >= 0) 
          {
              text.replace(pos, 2, "\n");
          }
          arglist.append(text);
      }
      as << arglist;
      ap.flush();
  }   

  // process the return values
  while (1) {

    // wait for the return arguments
    rs >> result;

    // process the return code
    switch (result) {

      // return code
      case 0: rs >> result;
              rp.close();
              ap.close();
              exit(result);
              break;

      // print value on stderr
      case 1: rs >> msg;
	      cout << msg << endl;
              break;

      // feed gauge with stdin
      case 2:
          while (cin.getline(buffer, 255)) {
              QStrList gauge;

              gauge.append("--gaugearg");
              gauge.append(buffer);
              as << gauge; 
              ap.flush();
          }
          ap.close();
          exit(0);
          break;
    }  
  }
}

void menu(QString text, QString width, QString /*height*/, QString menuheight, QStrList args, int index)
{
  QString result;
  int w = convert(width, 40);
  int mh = convert(menuheight, 10);

  int retcode = menuBox(0, w, mh, title, text, args, index, result);
  cout << result << endl;
  exit((retcode == QDialog::Accepted) ? 0 : -1);
}


void checklist(QString text, QString width, QString /* height */, QString menuheight, QStrList args, int index)
{
  QStrList result;
  unsigned int i;
  int w = convert(width, 40);
  int mh = convert(menuheight, 10);

  int retcode = checkList(0, w, mh, title, text, args, index, separateOutput, result);

  for (i=0; i<result.count(); i++)
    cerr << result.at(i) << endl;;	    
  exit((retcode == QDialog::Accepted) ? 0 : -1);
}


void radiobox(QString text, QString width, QString /* height */, QString menuheight, QStrList args, int index)
{
  QString result;
  int w = convert(width, 40);
  int mh = convert(menuheight, 10);

  int retcode = radioBox(0, w, mh, title, text, args, index, result);
  cerr << result << endl; 
  exit((retcode == QDialog::Accepted) ? 0 : -1);
}


int directCommand(KCmdLineArgs *args)
{
    // --title text
    if (args->isSet("title")) 
    {
      title = args->getOption("title");
      cout << title << endl;
    }

    // --separate-output
    if (args->isSet("separate-output")) 
    {
      separateOutput = TRUE;
    }

    // --yesno
    if (args->isSet("yesno")) 
    {
        QString text = args->getOption("yesno");
        int pos;
        while ((pos = text.find("\\n")) >= 0) 
        {
            text.replace(pos, 2, "\n");
        }
        if (KMessageBox::questionYesNo(0, text, title) == KMessageBox::Yes)
            return 0;
        else
            return -1;
    }

    // --msgbox
    if (args->isSet("msgbox")) {
        QString text = args->getOption("msgbox");
        int pos;
        while ((pos = text.find("\\n")) >= 0) 
        {
            text.replace(pos, 2, "\n");
        }
        KMessageBox::information(0, text, title);
        return 0;
    }

    // --inputbox text width height init
    if (args->isSet("inputbox"))
    {
      QString result;
      QString init = "";
      int w = 40;
      
      if (args->count() > 0) {
          w = convert(args->arg(0), 40);
          if (args->count() > 2) {
              init = args->arg(2);
          }
      }

      int retcode = inputBox(0, w, title, args->getOption("inputbox"), init, result);
      cout << result << endl;
      return (retcode == QDialog::Accepted) ? 0 : -1;
    }

    // --textbox file width height
    if (args->isSet("textbox")) 
    {
        int w = 40;
        int h = 15;

        if (args->count() == 2) {
            w = convert(args->arg(0), 40);
            h = convert(args->arg(1), 15);
        }          

        textBox(0, w, h, title, args->getOption("textbox"));
        return 0;
    }

    // --menu text width height menuheight [tag item]
    if (args->isSet("menu")) {
        QStrList list;
        if (args->count() >= 5) {
            for (int i = 3; i < args->count(); i++) {
                list.append(args->arg(i));
            }

            menu(args->getOption("menu"), args->arg(0), args->arg(1),
                 args->arg(2), list, 0);
        }
        return 0;
    }

    // --checklist text width height menuheight [tag item status]
    if (args->isSet("checklist")) {
        QStrList list;
        if (args->count() >= 6) {
            for (int i = 3; i < args->count(); i++) {
                list.append(args->arg(i));
            }

            checklist(args->getOption("checklist"), args->arg(0), args->arg(1),
                      args->arg(2), list, 0);
        }
        return 0;
    }

    // --radiolist text width height menuheight [tag item status]
    if (args->isSet("radiolist")) {
        QStrList list;
        if (args->count() >= 6) {
            for (int i = 3; i < args->count(); i++) {
                list.append(args->arg(i));
            }

            radiobox(args->getOption("radiolist"), args->arg(0), args->arg(1),
                      args->arg(2), list, 0);
        }
        return 0;
    }

    return 0;
}


int main(int argc, char *argv[]) 
{
  KAboutData aboutData( "kdialog", I18N_NOOP("kdialog"),
                        "0.2", I18N_NOOP( "The KDE dialog replacement" ), KAboutData::License_BSD,
                        "(C) 2000, Nick Thompson");
  aboutData.addAuthor("Nick Thompson",0, "nickthompson@lucent.com");

  KCmdLineArgs::init(argc, argv, &aboutData);
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication app;

  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

  // option "--kid" -> call the server
  if (args->isSet("kid"))
  {
    return callServer(args);
  }

  // execute direct kdialog command
  return directCommand(args);
}
