//
//  Copyright (C) 1998 Matthias Hoelzer
//  email:  hoelzer@physik.uni-wuerzburg.de
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the7 implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


#include <fcntl.h>
#include <qstrlist.h>

#include "application.h"
#include "application.moc"

#include <kcmdlineargs.h>

#include <stream.h>

Application::Application(int argc, char *argv[])
  : KApplication(argc, argv)
{
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

  // open argument stream
  ap.setName(args->arg(0));
  ap.open(IO_ReadWrite);
  fcntl(ap.handle(), O_NONBLOCK);
  as.setDevice(&ap);

  // open the return stream
  rp.setName(args->arg(1));
  rp.open(IO_ReadWrite);
  rs.setDevice(&rp);

  // create the toplevel widget
  frame = new KDialogFrame(&rs);
  setMainWidget(frame);
  frame->show();  

  // connect to the socket notifier
  socket = new QSocketNotifier(ap.handle(), QSocketNotifier::Read, this);
  connect(socket, SIGNAL(activated(int)), this, SLOT(pipeNotify()));
}


Application::~Application()
{
  ap.close();
  rp.close();
}


void Application::pipeNotify() 
{
  QStrList args;

  as >> args;

  if (strcmp(args.at(0),"--gaugearg") != 0)
    frame->processArgs(args);
  else
    frame->processGauge(args);
}
