/***************************************************************************
                          klock.h  -  description
                             -------------------
    begin                : Wed Oct 11 2000
    copyright            : (C) 2000 by Norbert Andres
    email                : NAndres@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KLOCK_H
#define KLOCK_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kaudioplayer.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kimageeffect.h>
#include <klocale.h>
#include <kmainwindow.h>
#include <kpopupmenu.h>
#include <krootpixmap.h>
#include <kstdaccel.h>

#include <qaccel.h>
#include <qfile.h>
#include <qwidget.h>
#include <qwmatrix.h>
#include <qpoint.h>
#include <qpointarray.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qcolor.h>
#include <qdatetime.h>
#include <qmessagebox.h>
#include <qtimer.h>
#include <qregion.h>

#include "global.h"
#include "optiondialog.h"
#include "optionstate.h"


class Klock : public KMainWindow
{
  Q_OBJECT
  public:
    /** construtor */
    Klock(QWidget* parent=0, const char *name=0);
    /** destructor */
    ~Klock();
    /** Overriding Paint Event */
    void paintEvent(QPaintEvent *);
  private:
    bool m_dragging;
    bool m_startup;
    bool m_dots;
    bool m_analog;
    bool m_top;
    bool m_borderless;
    bool m_transparentOn;
    QFont m_dShadowFont;
    SOptionState    options;
    COptionDialog * optionDialog;
    QPixmap *       m_background;
    QPixmap *       m_backgroundPic;
	KRootPixmap*    rootxpm;
    QPoint          m_offset;
    QAccel *        accel;
    QFont           font;
    QTime  time;
    QTime startTime;
    QTime stopTime;
    QDateTime countdownDateTime;
    QTimer *timer;
    KPopupMenu *contextMenu;
    KPopupMenu *typeMenu;
    int alwaysOnTopID;
    int borderlessID;
    int analogItem;
    int digitalItem;
    int sepItem;
    int sepIndex;
    int watchItem;
    int watchIndex;
    int stopItem;
    int startItem;
    int resetItem;
    KPopupMenu *stopWatchMenu;
    void createPopupMenu();
    void changeState();
    void changeBorder();
    void changeAlwaysOnTop();
    void readConfig();
    void writeConfig();
    void updateContextMenu();
    void startCountdown();
    void stopCountdown();
    void createBackgroundPixmap();
    void setDShadowFont();
    void setTransparentMode(bool state);
	void tile(QImage *dest, QRect rect, QImage *src);
    QString getHour(QString s);
    QString getMin(QString s);
    QString getSec(QString s);

  protected:
    void mousePressEvent(QMouseEvent *ev);
    void mouseMoveEvent(QMouseEvent *ev);
    void mouseReleaseEvent(QMouseEvent *ev);
    void resizeEvent(QResizeEvent *ev);
    bool queryClose();


  protected slots:
    void slotTimer();
    void slotContextMenu();

  private slots:
    void analogClicked();
    void digitalClicked();
    void quitClicked();
    void alwaysOnTopClicked();
    void noBorderClicked();
    void optionsClicked();
    void setMiscOption(const SMiscState &misc);
    void setBackgroundOption(const SBackgroundState &back);
    void setColorOption(const SColorState &color);
    void setFontOption(const SFontState &font);
    void setModeOption(const SModeState &mode);
    void startStopWatch();
    void stopStopWatch();
    void resetStopWatch();

};

#endif



