/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#include <qmultilineedit.h>
#include <klocale.h>
#include <kmessagebox.h>


#include "catalog.h"
#include "headereditor.h"

HeaderEditor::HeaderEditor(Catalog* cat,const char* name)
             : KDialogBase((QWidget*)0,name,false,QString::null, Ok|Cancel|Default|User1)
{
   _catalog=cat;
   connect(_catalog,SIGNAL(signalFileOpened(bool)),this,SLOT(readHeader()));

   setButtonText(User1,i18n("&Update"));
   setButtonText(Default,i18n("&Reset"));

   _editor=new QMultiLineEdit(this,"internal headereditor");
   _editor->setMinimumSize(350,250);

   readHeader();

   setMainWidget(_editor);
}

HeaderEditor::~HeaderEditor()
{
}

bool HeaderEditor::isModified()
{
   return _editor->edited();
}

void HeaderEditor::readHeader()
{
   setCaption(i18n("Headereditor for %1").arg(_catalog->currentURL()));

   _editor->setText(_catalog->header().asString());

   _editor->setEdited(false);
}


// update button
void HeaderEditor::slotUser1()
{
   CatalogItem header(_editor->text());

   if(!header.isValid())
   {
      QString msg=i18n("<qt><p>This is not a valid header!</p>\n\
<p>A valid header has the format:\n\
<blockquote><i>optional comment</i><br/>msgid \"\"<br/>msgstr \"\"<br/>\
<i>optional lines surrounded by \"\"</i></blockquote></p>\n");
      msg+=i18n("<p>Please edit the header before updating!</p></qt>");

      KMessageBox::sorry(this,msg);

      return;
   }

   header=_catalog->updatedHeader(header,false);

   QString temp=header.asString();
   _editor->setText(temp);
}


void HeaderEditor::slotDefault()
{
   readHeader();
}

void HeaderEditor::slotCancel()
{
   readHeader();

   QDialog::reject();
}

void HeaderEditor::slotOk()
{
   if(isModified())
   {
      CatalogItem header(_editor->text());

      if(!header.isValid())
      {
         QString msg=i18n("<qt><p>This is not a valid header!</p>\n\
<p>A valid header has the format:\n\
<blockquote><i>optional comment</i><br/>msgid \"\"<br/>msgstr \"\"<br/>\
<i>optional lines surrounded by \"\"</i></blockquote></p>\n");
         msg+=i18n("<p>Do you want to discard your changes or edit the header again?</p></qt>");

         switch(KMessageBox::warningYesNo(this,msg,i18n("Warning"),i18n("Discard"),i18n("Edit")))
         {
            case KMessageBox::Yes:
            {
               slotCancel();
               return;
            }
            default:
               return;
         }
      }

      _catalog->setHeader(header);
   }

   QDialog::accept();
}


