/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#include <qlayout.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include <kapp.h>
#include <kbuttonbox.h>
#include <klocale.h>
#include "misc.h"

#include "tagdlg.h"
#include "tagdlg.moc"


TagDialog::TagDialog(ActionType action, QWidget *parent, const char *name)
    : QDialog(parent, name, true)
{
    setCaption( (action==Delete)? i18n("CVS Delete Tag") : i18n("CVS Tag") );

    QBoxLayout *layout = new QVBoxLayout(this, 10);

    QBoxLayout *tagedit_layout = new QHBoxLayout();
    layout->addLayout(tagedit_layout);

    QLabel *tag_label = new QLabel(i18n("&Name of tag:"), this);
    tag_label->setMinimumSize(tag_label->sizeHint());
    tagedit_layout->addWidget(tag_label);

    tag_edit = new QLineEdit(this);
    tag_edit->setFocus();
    tag_label->setBuddy(tag_edit);
    QFontMetrics fm(fontMetrics());
    tag_edit->setMinimumSize(fm.width("0")*30, tag_edit->sizeHint().height());
    tagedit_layout->addWidget(tag_edit);
    
    if (action == Create)
        {
            branchtag_button = new QCheckBox(i18n("Create &branch with this tag"), this);
            branchtag_button->setMinimumSize(branchtag_button->sizeHint());
            layout->addWidget(branchtag_button);
	}
    
    QFrame *frame = new QFrame(this);
    frame->setFrameStyle(QFrame::HLine | QFrame::Sunken);
    frame->setMinimumHeight(frame->sizeHint().height());
    layout->addWidget(frame, 0);

    KButtonBox *buttonbox = new KButtonBox(this);
    buttonbox->addStretch();
    QPushButton *ok = buttonbox->addButton(i18n("OK"));
    QPushButton *cancel = buttonbox->addButton(i18n("Cancel"));
    ok->setDefault(true);
    connect( ok, SIGNAL(clicked()), this, SLOT(accept()) );
    connect( cancel, SIGNAL(clicked()), this, SLOT(reject()) );
    buttonbox->layout();
    layout->addWidget(buttonbox, 0);

    layout->activate();
    resize(sizeHint());
}


void TagDialog::done(int r)
{
    if (r == Accepted)
        {
            QString str = tag();
            
            if (str.length() == 0)
                {
                    QMessageBox::information(this, "Cervisia",
                                             i18n("You must define a tag name."));
                    return;
                }

            if (!isValidTag(str))
                {
                    QMessageBox::information(this, "Cervisia",
                                             i18n("Tag must start with a letter and may contain"
                                                  "letters, digits and the characters '-' and '_'."));
                    return;
                }
        }
    
    QDialog::done(r);
}


// Local Variables:
// c-basic-offset: 4
// End:

    
