/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#include <pwd.h>
#include <sys/types.h>
#include <unistd.h>
#include <qregexp.h>
#include <ctype.h>
#include <kconfig.h>
#include "cervisiaapp.h"
#include "misc.h"


#if QT_VERSION >= 200
void chomp(QCString *line)
#else
void chomp(QString *line)
#endif
{
    int pos;
    if ( (pos = line->find('\n')) != -1 )
	line->truncate(pos);  
}


QString quote(QString str)
{
    QString res = "'";
    if (!str.isEmpty())
        res += str.replace(QRegExp("'"), "'\"'\"'");
    res += "'";
    return res;
}


QString joinLine(QStrList list)
{
    QString line;
    QStrListIterator it(list);
    for (; it.current(); ++it)
	{
            line += quote(it.current());
            line += " ";
	}
    if (line.length() > 0)
	line.truncate(line.length()-1);

    return line;
}


// QStrList sucks!!! 
QStrList splitLine(QString line, char delim)
{
    int pos;
    QStrList list(true);

    line = line.simplifyWhiteSpace();
    while ((pos = line.find(delim)) != -1)
	{
	    list.append(line.left(pos));
	    line = line.mid(pos+1, line.length()-pos-1);
	}
    if (!line.isEmpty())
	list.append(line);
    return list;
}


bool isValidTag(QString str)
{
#if QT_VERSION >= 200
    if (!isalpha(str[0].latin1()))
        return false;
#else
    if (!isalpha(str[0]))
        return false;
#endif

    for (int i = 1; i < (int)str.length(); ++i)
        {
#if QT_VERSION >= 200
            if (!isgraph(str[i].latin1()) || QString("$,.:;@").contains(str[i]))
                return false;
#else
            if (!isgraph(str[i]) || QString("$,.:;@").contains(str[i]))
                return false;
#endif
        }

    return true;
}


// Gives the name (including path) of the cvs command line client
QString cvsClient()
{
    KConfig *config = capp->config();
    config->setGroup("General");
    return config->readEntry("CVSPath", "cvs");
}


// Gives the user name (real name + mail address) for the changelog entry
QString userName()
{
    char hostname[512];
    
    struct passwd *pw = ::getpwuid(getuid());
    // pw==0 => the system must be really fucked up
    if (!pw)
        return QString();

    // I guess we don't have to support users with longer host names ;-)
    (void) ::gethostname(hostname, sizeof hostname);

    QString res = pw->pw_gecos;
    res += "  <";
    res += pw->pw_name;
    res += "@";
    res += hostname;
    res += ">";

    return res;
}

// Local Variables:
// c-basic-offset: 4
// End:
