/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#ifndef _LOGTREE_H_
#define _LOGTREE_H_

#include <qtableview.h>
#include <qlist.h>


class LogTreeItem;
class LogTreeConnection;

class LogTreeView : public QTableView
{
    Q_OBJECT

public:
    LogTreeView( QWidget *parent=0, const char *name=0 );

    void addRevision(QString rev, QString author, QString comment, QString taglist, QString tagcomment);
    void collectConnections();
    void setSelectedPair(QString selectionA, QString selectionB);
    void lookupTip(const QPoint &p, QRect *r, QString *s);
    void recomputeCellSizes ();

    virtual QSize sizeHint() const;
    //    virtual QSizePolicy sizePolicy() const;
    //    virtual QSize minimumSizeHint() const;

signals:
    void revisionClicked(QString rev, bool rmb);

protected:
    virtual void mousePressEvent(QMouseEvent *e);
    virtual void setupPainter(QPainter *p);
    virtual void paintCell(QPainter *p, int row, int col);
    virtual int cellWidth (int col);
    virtual int cellHeight (int row);

private:
    void paintRevisionCell(QPainter *p, int row, int col, QString line1, QString line2, QString line3,
			   bool followed, bool branched, bool selected);
    void paintConnector(QPainter *p, int row, int col, bool followed, bool branched);
    void computeBoxSize(QFontMetrics &fm, QString line1, QString line2, QString line3,
                        int *outWidth, int *outHeight);

    QList<LogTreeItem> items;
    QList<LogTreeConnection> connections;
    QArray<int> colWidths;
    QArray<int> rowHeights;
};

#endif


// Local Variables:
// c-basic-offset: 4
// End:
