/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#include <qpainter.h>
#include <qlayout.h>
#include <qkeycode.h>
#include <kbuttonbox.h>
#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>
#include "misc.h"
#include <stdio.h>
#include "cervisiaapp.h"
#include "cvsprogressdlg.h"
#include "diffdlg.h"
#include "diffdlg.moc"


#if QT_VERSION < 200
#define QCString QString
#endif


DiffDialog::Options *DiffDialog::options = 0;


DiffDialog::DiffDialog(QWidget *parent, const char *name, bool modal)
#if QT_VERSION < 200
    : QDialog(parent, name)
#else
    : QDialog(parent, name, WStyle_MinMax)
#endif
{
    QBoxLayout *layout = new QVBoxLayout(this, 10);

    QGridLayout *pairlayout = new QGridLayout(2, 3, 10);
    layout->addLayout(pairlayout, 10);
    pairlayout->setColStretch(1, 0);
    pairlayout->addColSpacing(1, 16);
    pairlayout->setColStretch(0, 10);
    pairlayout->setColStretch(2, 10);

    revlabel1 = new QLabel("Rev A", this);
    revlabel1->setFixedHeight(revlabel1->sizeHint().height());
    pairlayout->addWidget(revlabel1, 0, 0);
			      
    revlabel2 = new QLabel("Rev A", this);
    revlabel2->setFixedHeight(revlabel2->sizeHint().height());
    pairlayout->addWidget(revlabel2, 0, 2);

    diff1 = new DiffView(true, false, this);
    diff2 = new DiffView(true, true, this);
    DiffZoomWidget *zoom = new DiffZoomWidget(this);
    zoom->setDiffView(diff2);

    pairlayout->addWidget(diff1, 1, 0);
    pairlayout->addWidget(zoom,  1, 1);
    pairlayout->addWidget(diff2, 1, 2);

    diff1->setPartner(diff2);
    diff2->setPartner(diff1);
    
    syncbox = new QCheckBox(i18n("Synchronize scroll bars"), this);
    syncbox->setChecked(true);
    connect( syncbox, SIGNAL(toggled(bool)),
	     SLOT(toggleSynchronize(bool)) );
    syncbox->setMinimumSize(syncbox->sizeHint());
    layout->addWidget(syncbox, 0);
    
    QFrame *frame = new QFrame(this);
    frame->setFrameStyle(QFrame::HLine | QFrame::Sunken);
    frame->setMinimumHeight(frame->sizeHint().height());
    layout->addWidget(frame, 0);

    KButtonBox *buttonbox = new KButtonBox(this);
    buttonbox->addStretch();
    connect( buttonbox->addButton(i18n("&Close")), SIGNAL(clicked()),
	     SLOT(reject()) );
    buttonbox->layout();
    layout->addWidget(buttonbox, 0);

    QFontMetrics fm(fontMetrics());
    setMinimumSize(fm.width("0123456789")*12,
		   fm.lineSpacing()*30);
    layout->activate();

    if (options)
        {
            resize(options->size);
            syncbox->setChecked(options->sync);
        }
}


void DiffDialog::done(int res)
{
    if (!options)
        options = new Options;
    options->size = size();
    options->sync = syncbox->isChecked();
    
    QDialog::done(res);
    delete this;
}


void DiffDialog::loadOptions(KConfig *config)
{
    if (!config->readEntry("Customized"))
        return;

    options = new Options;
    options->size = config->readSizeEntry("Size");
    options->sync = config->readBoolEntry("Sync");
}


void DiffDialog::saveOptions(KConfig *config)
{
    if (!options)
        return;

    config->writeEntry("Customized", true);
    config->writeEntry("Size", options->size);
    config->writeEntry("Sync", options->sync);
}


#if 0
class DiffItem
{
public:
    DiffView::DiffType type;
    int ver1begin, ver1end;
    int ver2begin, ver2end;
};
#endif


void DiffDialog::keyPressEvent(QKeyEvent *e)
{
    switch (e->key())
	{
	case Key_Up:
            diff1->up();
            diff2->up();
            break;
	case Key_Down:
            diff1->down();
            diff2->down();
            break;
	case Key_Next:
            diff1->next();
            diff2->next();
            break;
	case Key_Prior:
            diff1->prior();
            diff2->prior();
            break;
        default:
            QDialog::keyPressEvent(e);
	}
}


void DiffDialog::toggleSynchronize(bool b)
{
    diff1->setPartner(b? diff2 : 0);
    diff2->setPartner(b? diff1 : 0);
}


static void interpretRegion(QString line, int *linenoA, int *linenoB)
{
    //  No KRegExp in KDE1 :-(
    line.remove(0, 2);
    int pos1, pos2;
    if ( (pos1 = line.find('-')) == -1)
        return;
    pos1++;
    if ( (pos2 = line.find(',', pos1)) == -1)
        return;
    *linenoA = line.mid(pos1, pos2-pos1).toInt()-1;
    if ( (pos1 = line.find('+'), pos2) == -1)
        return;
    pos1++;
    if ( (pos2 = line.find(',', pos1)) == -1)
        return;
    *linenoB = line.mid(pos1, pos2-pos1).toInt()-1;
}


bool DiffDialog::parseCvsDiff(QString sandbox, QString repository,
                              QString filename, QString revA, QString revB)
{
    QStrList linesA, linesB;
    int linenoA, linenoB;
    enum { Normal, VersionA, VersionB } state;

    setCaption("CVS Diff: " + filename);
    revlabel1->setText( revA.isEmpty()?
                        QString(i18n("Repository"))
                        : i18n("Revision ")+revA );
    revlabel2->setText( revB.isEmpty()?
                        QString(i18n("Working dir"))
                        : i18n("Revision ")+revB );
    
    KConfig *config = capp->config();
    config->setGroup("General");
    QString cmdline = cvsClient() + " -f diff ";
    cmdline += config->readEntry("DiffOptions", "");
    cmdline += " -U ";
    cmdline += QString().setNum((int)config->readUnsignedNumEntry("ContextLines", 65535));
    if (!revA.isEmpty())
	{
	    cmdline += " -r ";
	    cmdline += revA;
	}
    if (!revB.isEmpty())
	{
	    cmdline += " -r ";
	    cmdline += revB;
	}
    cmdline += " ";
    cmdline += quote(filename);

    CvsProgressDialog l("Diff", this);
    l.setCaption("CVS Diff");
    if (!l.execCommand(sandbox, repository, cmdline, "diff"))
        return false;

    QCString line;
    while ( l.getOneLine(&line) && line.left(3) != "+++")
        ;
    
    state = Normal;
    linenoA = linenoB = 0;
    while ( l.getOneLine(&line) )
        {
            if (line.left(2) == "@@")
                {
                    interpretRegion(line, &linenoA, &linenoB);
                    diff1->addLine(line, DiffView::Separator);
                    diff2->addLine(line, DiffView::Separator);
                    continue;
                }
            if (line.length() < 1)
                continue;
            char marker = line[0];
            line.remove(0, 1);
            
            if (marker == '-')
                {
                    state = VersionA;
                    linesA.append(line);
                }
            else if (marker == '+')
                {
                    state = VersionB;
                    linesB.append(line);
                }
            else
                {
                            QStrListIterator itA(linesA);
                            QStrListIterator itB(linesB);
                            for (; itA.current() || itB.current(); ++itA, ++itB)
                                {
                                    if (itA.current())
                                        {
                                            diff1->addLine(itA.current(), DiffView::Neutral,
                                                           ++linenoA);
                                            if (itB.current())
                                                diff2->addLine(itB.current(), DiffView::Change,
                                                               ++linenoB);
                                            else
                                                diff2->addLine("", DiffView::Delete);
                                        }
                                    else
                                        {
                                            diff1->addLine("", DiffView::Neutral);
                                            diff2->addLine(itB.current(), DiffView::Insert,
                                                           ++linenoB);
                                        }
                                }
                    state = Normal;
                    linesA.clear();
                    linesB.clear();
                    diff1->addLine(line, DiffView::Unchanged, ++linenoA);
                    diff2->addLine(line, DiffView::Unchanged, ++linenoB);
                }
            
	}
    
    // Copy & Paste from above
                            QStrListIterator itA(linesA);
                            QStrListIterator itB(linesB);
                            for (; itA.current() || itB.current(); ++itA, ++itB)
                                {
                                    if (itA.current())
                                        {
                                            diff1->addLine(itA.current(), DiffView::Neutral,
                                                           ++linenoA);
                                            if (itB.current())
                                                diff2->addLine(itB.current(), DiffView::Change,
                                                               ++linenoB);
                                            else
                                                diff2->addLine("", DiffView::Delete);
                                        }
                                    else
                                        {
                                            diff1->addLine("", DiffView::Neutral);
                                            diff2->addLine(itB.current(), DiffView::Insert,
                                                           ++linenoB);
                                        }
                                }
    
    return true;
}


#if 0
const int SIDEWIDTH = 130;
const int COLUMNWIDTH = 67;


bool DiffDialog::parseCvsDiff(QString sandbox, QString repository,
                              QString filename, QString revA, QString revB)
{
    QString cmdline;
    int lineno1, lineno2;

    setCaption("CVS Diff: " + filename);
    revlabel1->setText( revA.isEmpty()?
                        QString(i18n("Repository"))
                        : i18n("Revision ")+revA );
    revlabel2->setText( revB.isEmpty()?
                        QString(i18n("Working dir"))
                        : i18n("Revision ")+revB );
    
    cmdline.setNum(SIDEWIDTH);
    cmdline = cvsClient() + " -Q diff --side-by-side -t -W " + cmdline;
    if (!revA.isEmpty())
	{
	    cmdline += " -r ";
	    cmdline += revA;
	}
    if (!revB.isEmpty())
	{
	    cmdline += " -r ";
	    cmdline += revB;
	}
    cmdline += " ";
    cmdline += filename;

    CvsProgressDialog l("Diff", this);
    l.setCaption("CVS Diff");
    if (!l.execCommand(sandbox, repository, cmdline, "diff"))
        return false;

    QCString line;
    for (int i = 0; i < 6; ++i)
        (void) l.getOneLine(&line);

    lineno1 = lineno2 = 0;
    while ( l.getOneLine(&line) )
        {
	    QString line1 = line.left(COLUMNWIDTH-3);
	    QString line2 = line.mid(COLUMNWIDTH, COLUMNWIDTH);
	    char marker =
                (line.length() > COLUMNWIDTH-3)? line[COLUMNWIDTH-3] : ' ';
	    DiffView::DiffType type = (marker == '|')? DiffView::Change
		: (marker == '<')? DiffView::Delete
		: (marker == '>')? DiffView::Insert
		: DiffView::Unchanged;
	    diff1->addLine(line1, (type!=DiffView::Unchanged)? DiffView::Neutral : type,
			   (type!=DiffView::Insert)? ++lineno1 : -1);
	    diff2->addLine(line2, type,
			   (type!=DiffView::Delete)? ++lineno2 : -1);
	}

    return true;
}
#endif

// Local Variables:
// c-basic-offset: 4
// End:
