#include <qpushbutton.h>
#include <qlayout.h>
#include <qlabel.h>

#include "kplineddlg.h"

KPLinedDlg::KPLinedDlg  (const QString &caption, const QString &prompt,
			 const QString &text,
			 QWidget *parent, const char *name):
  QDialog (parent, name, TRUE)
{
  setCaption (caption);


  QGridLayout* layout = new QGridLayout (this, 2, 3, 10);
  
  QPushButton *bok = new QPushButton(  "OK" , this );
  connect( bok, SIGNAL(clicked()), this, SLOT(accept()) );
  
  QPushButton *bcancel = new QPushButton(  "Cancel" , this );
  connect( bcancel, SIGNAL(clicked()), this, SLOT(reject()) );
  
  bok->setFixedWidth (bok->sizeHint().width());
  bok->setFixedHeight (bok->sizeHint().height());
  bcancel->setFixedWidth (bcancel->sizeHint().width());
  bcancel->setFixedHeight (bcancel->sizeHint().height());
  
  layout->addWidget (bok, 1,1);
  bok->setDefault( TRUE );

  layout->addWidget (bcancel, 1,2);

  le = new KLineEdit (this);

  le->setText( text );
  le->setFixedHeight( le->sizeHint().height() );
  le->setMinimumWidth ( le->sizeHint().width() );
  layout->addMultiCellWidget( le, 0, 0, 1, 2 );
  
  QLabel *label = new QLabel (le, prompt, this);
  label->setFixedHeight ( label->sizeHint().height() );
  layout->addWidget ( label, 0, 0 );
  
  le->setFocus();
}

QString
KPLinedDlg::text (void)
{
  return le->text();
}
