#include "kpcoords.moc"


KPCoords::KPCoords (KPCoordsProp *coordsp)
{
  setDefaults();
  setCxmin (coordsp->xMin());
  setCxmax (coordsp->xMax());
  setCymin (coordsp->yMin());
  setCymax (coordsp->yMax());

  setCCrossx (coordsp->xCross());
  setCCrossy (coordsp->yCross());

  setXTick (coordsp->xTick());
  setYTick (coordsp->yTick()); 

  setX0 (coordsp->origCoords()->oX0());
  setY0 (coordsp->origCoords()->oY0());
  setWidth (coordsp->origCoords()->owidth());
  setHeight (coordsp->origCoords()->oheight());
}

KPCoords::KPCoords ()
{
  setDefaults();
  defaultTicks();

}

KPCoords::KPCoords (double _cxmin, double _cxmax, double _cymin, double _cymax,
		    double _ccrossx, double _ccrossy,
		    int _ox0, int _oy0, int _owidth, int _oheight)

{
  setDefaults();

  setCxmin (_cxmin);
  setCxmax (_cxmax);
  setCymin (_cymin);
  setCymax (_cymax);

  setX0 (_ox0);
  setY0 (_oy0);
  setWidth (_owidth);
  setHeight (_oheight);

  setCCrossx (_ccrossx);
  setCCrossy (_ccrossy);

  defaultTicks();
}

void
KPCoords::setDefaults (void)
{
  cminx=cminy=0;
  cmaxx=cmaxy=1;
  crossx=crossy=0;
  x0=y0=0;
  width=height=1;
  xratio=yratio=1;
}

void
KPCoords::defaultTicks(void)
{
  xtickspc = (cxmax()-cxmin())/5.;
  ytickspc = (cymax()-cymin())/5.;
}

void
KPCoords::setXTick (double xspace)
{
  if (xspace<=(cmaxx-cminx))
    xtickspc = xspace;
}

void
KPCoords::setYTick (double yspace)
{
  if (yspace<=(cmaxy-cminy))
    ytickspc = yspace;
}

void
KPCoords::setCxmin (double _cxmin)
{
  cminx = _cxmin;
  setXRatio();
}

void
KPCoords::setCxmax (double _cxmax)
{
  cmaxx = _cxmax;
  setXRatio();
}

void
KPCoords::setCymin (double _cymin)
{
  cminy = _cymin;
  setYRatio();
}

void
KPCoords::setCymax (double _cymax)
{
  cmaxy = _cymax;
  setYRatio();
}

void
KPCoords::setX0 (int _ox0)
{
  x0=_ox0;
}

void
KPCoords::setY0 (int _oy0)
{
  y0=_oy0;
}

void
KPCoords::setWidth (int _owidth)
{
  width=_owidth;
  setXRatio();
}

void
KPCoords::setHeight (int _oheight)
{
  height=_oheight;
  setYRatio();
}




///////////////////

#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qgroupbox.h>

KPCoordsProp::KPCoordsProp (KPCoords *kc, QWidget *parent, const char *name,
			    WFlags _f) :
  QWidget (parent, name, _f)
{
  QGridLayout *layout = new QGridLayout (this, 7, 2, 10);

  QString qs;

  lexmin = new KLineEdit (this);
  qs.setNum (kc->cxmin());
  lexmin->setText (qs);
  lexmin->setMinimumSize (lexmin->sizeHint());
  layout->addWidget (lexmin, 0, 1);

  lexmax = new KLineEdit (this);
  qs.setNum (kc->cxmax());
  lexmax->setText (qs);
  lexmax->setMinimumSize (lexmax->sizeHint());
  layout->addWidget (lexmax, 1, 1);

  leymin = new KLineEdit (this);
  qs.setNum (kc->cymin());
  leymin->setText (qs);
  leymin->setMinimumSize (leymin->sizeHint());
  layout->addWidget (leymin, 2, 1);

  leymax = new KLineEdit (this);
  qs.setNum (kc->cymax());
  leymax->setText (qs);
  leymax->setMinimumSize (leymax->sizeHint());
  layout->addWidget (leymax, 3, 1);

  lexcross = new KLineEdit (this);
  qs.setNum (kc->ccrossx());
  lexcross->setText (qs);
  lexcross->setMinimumSize (lexcross->sizeHint());
  layout->addWidget (lexcross, 4, 1);

  leycross = new KLineEdit (this);
  qs.setNum (kc->ccrossy());
  leycross->setText (qs);
  leycross->setMinimumSize (leycross->sizeHint());
  layout->addWidget (leycross, 5, 1);


  QLabel *label = new QLabel (lexmin, "Minimum X:", this);
  label->setMinimumSize (label->sizeHint());
  layout->addWidget (label, 0, 0);

  label = new QLabel (lexmax, "Maximum X:", this);
  label->setMinimumSize (label->sizeHint());
  layout->addWidget (label, 1, 0);

  label = new QLabel (leymin, "Minimum Y:", this);
  label->setMinimumSize (label->sizeHint());
  layout->addWidget (label, 2, 0);

  label = new QLabel (leymax, "Maximum Y:", this);
  label->setMinimumSize (label->sizeHint());
  layout->addWidget (label, 3, 0);

  label = new QLabel (lexcross, "X axis crossing:", this);
  label->setMinimumSize (label->sizeHint());
  layout->addWidget (label, 4, 0);

  label = new QLabel (leycross, "Y axis crossing:", this);
  label->setMinimumSize (label->sizeHint());
  layout->addWidget (label, 5, 0);



  QGroupBox *gb = new QGroupBox ("Tick marks", this);
  QGridLayout *l2 = new QGridLayout (gb, 5, 2, 10);

  
  l2->addRowSpacing (1, 10);
  l2->addRowSpacing (4, 5);

  lextick = new KLineEdit (gb);
  qs.setNum (kc->xTickSpacing());
  lextick->setText (qs);
  lextick->setMinimumSize (lextick->sizeHint());
  l2->addWidget (lextick, 1, 1);

  leytick = new KLineEdit (gb);
  qs.setNum (kc->yTickSpacing());
  leytick->setText (qs);
  leytick->setMinimumSize (leytick->sizeHint());
  l2->addWidget (leytick, 2, 1);

  label = new QLabel (leytick, "Y tick spacing:", gb);
  label->setMinimumSize (label->sizeHint());
  l2->addWidget (label, 2, 0);

  label = new QLabel (lextick, "X tick spacing:", gb);
  label->setMinimumSize (label->sizeHint());
  l2->addWidget (label, 1, 0);

  QPushButton *b = new QPushButton ("&Default spacing", gb);
  b->setMinimumSize (b->sizeHint());
  connect ( b, SIGNAL (clicked()),
	    this, SLOT (slotDefault()) );
  l2->addMultiCellWidget (b, 3, 3, 0, 1);
  l2->activate();



  layout->addMultiCellWidget (gb, 6, 6, 0, 1);

  //  layout->freeze();

  coords = kc;
}


void 
KPCoordsProp::slotDefault ()
{
  KPCoords tc (xMin(), xMax(), 
		      yMin(), yMax(),
		      xCross(), yCross());

  tc.defaultTicks();

  QString qs;
  qs.setNum (tc.xTickSpacing());
  lextick->setText (qs);

  qs.setNum (tc.yTickSpacing());
  leytick->setText (qs);
}
