#ifndef __KPSIMPLE_H__
#define __KPSIMPLE_H__


#include <qstring.h>
#include <qstrlist.h>

#include <ktmainwindow.h>

#include <kpmessages.h>

class KPComm;
class KPMatrix;
class QWidget;
class KTreeList;
class KProcess;
class KSocket;


class KPSimple : public KTMainWindow
{
 Q_OBJECT

 public:
  KPSimple (const char *name=0);
  
 public slots:
   void slotImport ();
   void slotMessageWaiting (int message);
   void slotShow();
   void slotCancel();
   void slotMakeConnection();
   void slotConnectionLost( KSocket *);
   void slotOutput (KProcess *, char *, int);

   void slotHighlighted (int);
   void slotActivated (int);

 protected:
   virtual KPMatrix *loadMatrix (const QString &filename);
   virtual void closeEvent (QCloseEvent *);
   void startKPlot (void);
   struct SIndexedMatrixDesc
   {
     int index;
     SKPCMatrixDesc matdesc;
     QString filename;
   };
   QList<SIndexedMatrixDesc> matrices;


   /**
    * Find the record with the given <em>index</em>
    *  in matrices.
    **/
   int findIndex (int index);

   void createFromFile (QString filename, bool add=true);
 private:
   QPopupMenu *file;
   int idimportmatrix;

   QString connectmessage;
   int connecttries;

   KPComm *kpcomm;
   QString dirpath;
   QStrList filenames;
   QWidget *cancelwid;
   bool bcanceled;
   KTreeList *tree;
   KProcess *kproc;
};

#endif
