#include <stdio.h>
#include <unistd.h>

#include <qlabel.h>

#include <kapp.h>

#include "tst.moc"

KTest::KTest (int argc)
{
  if (argc>1) // server
    {
      printf ("SERVER\n");
      KServerSocket *server = new KServerSocket (SOCKNAME);
      connect ( server, SIGNAL (accepted(KSocket *)),
		this, SLOT (slotAccept(KSocket *)) );
    }
  else //client
    {
      printf ("CLIENT\n");
      kpcomm = new KPComm (SOCKNAME);
      char *data = strdup ("Hello");
      printf ("SENDING [%d] [%s]\n",sizeof (char)*strlen(data),data);
      kpcomm->send (KPComm::NOP, 37, data, sizeof (char)*strlen(data));
    }
}


void      
KTest::slotAccept (KSocket *socket)
{
  printf ("ACCEPT\n");
  int newsocket = dup (socket->socket());
  kpcomm = new KPComm (newsocket);
  delete socket;
  connect ( kpcomm, SIGNAL (messageWaiting (int)),
	    this, SLOT (slotMessageWaiting (int)) );
  printf ("ACCEPT DONE\n");
}

void
KTest::slotMessageWaiting (int)
{
  char *data;
  int datasize, id, option;
  printf ("message is [%d]\n", kpcomm->get ((void *)data, option, datasize, id));
  printf ("option is [%d]\n", option);
  kpcomm->releaseData (data, id);
}

int
main (int argc, char *argv[])
{
  KApplication app (argc, argv, "ktest");
  KTest *ktest = new KTest (argc);

  app.setMainWidget (new QLabel ("Hello!"));
  app.exec();
}
