/**
 * These are the messages that KPlot can receive via KPComm.
 * The data type that is sent is also given.
 * To send these messages to KPlot use libkpcomm.
 *
 * @author David Sweet <dsweet@chaos.umd.edu>
 **/

#ifndef __KPMESSAGES_H__
#define __KPMESSAGES_H__

/**
 * Matrix description.
 *  option = a matrix id
 *  data = SKPCMatrixDesc
 **/
const int KPCMatrixDesc = 100;
struct SKPCMatrixDesc
{
  int nrows;
  int ncols;
  char name [255]; //A user-friendly identifier for the matrix.
};

/**
 * Matrix data.
 * Send a KPCMatrixDesc with the same matrix id first.
 *  option = a matrix id
 *  data = a row-major order matrix of doubles
 **/
const int KPCMatrix = 101;



//For testing:  all plot and UI methods will be delivered via KOM
//  when this becomes and OpenPart.  Rule of thumb:  if it needs to
//  pass large chunks of data, use KPComm, or else use KOM.
/**
 * Create plot.
 * Define the matrix (ref'd by mtrix id) with KPCMatrixDesc and 
 * KPCMatrix first.
 *  option = matrix id to use
 *  data = SKPCCreatePlot
 **/
const int KPCCreatePlot = 102;
const int SKPCCreatePlotAuto = -1;
struct SKPCCreatePlot
{
  int plottype; //choose a plot type from kps2dwhatami.h, or SKPCCreatePlotAuto to let KPlot decide
};



#endif

