#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <time.h>

#include "kpcomm.moc"

SHMComm::SHMComm (int socket) : KSocket (socket)
{
  init();
}

SHMComm::SHMComm (const char *socketfilename) : KSocket (socketfilename)
{
  init();
}

void
SHMComm::init (void)
{
  enableRead(true);
  enableWrite(true);

  QObject::connect ( this, SIGNAL (readEvent (KSocket *)),
		     this, SLOT (slotReadMessage (KSocket *)) );
  QObject::connect ( this, SIGNAL (writeEvent (KSocket *)),
		     this, SLOT (slotWriteMessage (KSocket *)) );
  cursendmessage=NoMessage;

  time_t t;
  time (&t);
  srand (t);
}

void
SHMComm::slotReadMessage (KSocket *)
{
  SPacket *packet = new SPacket;
  ::read (socket(), packet, sizeof (SPacket));
  
  printf ("READ [%d]\n", packet->message);

  if (packet->message == SHMDelete)
    shmctl (packet->option, IPC_RMID, 0);
  else
    {
      recvpackets.enqueue (packet);
      emit messageWaiting (packet->message);
    }
}


void *
SHMComm::get (int &message, int &option, int &datasize, int &id)
{
  void * data=0;

  if (!recvpackets.isEmpty())
    {
      SPacket *packet = recvpackets.dequeue();
      message = packet->message;
      printf ("GET [%d]\n", packet->message);
      if (packet->shmid!=NoDataMessage)
	{
	  data = (void *)shmat (packet->shmid, 0, SHM_RDONLY);
	  id = packet->shmid;
	  option = packet->option;
	}
      else
	{
	  data=0;
	  datasize=0;
	  option=packet->option;
	  id=-1;
	}

      delete packet;
      return data;
    }
  else
    return 0;
}

void
SHMComm::releaseData (void *data, int id)
{
  shmdt (data);
  send (SHMDelete, id);
}

void
SHMComm::send (int message, int option)
{
  printf ("SEND2 [%d]\n", message);

  SPacket *packet = new SPacket;

  packet->shmid=NoDataMessage;
  packet->option = option;
  packet->message=message;

  sendpackets.enqueue (packet);
}

void
SHMComm::send (int message, int option, const void *data, int datasize)
{
  printf ("SEND [%d]\n", message);

  SPacket *packet = new SPacket;

  packet->shmid=shmget (rand(), datasize, IPC_CREAT | 16+32+128+256);
  printf ("SHMRESULT [%d]\n", packet->shmid);
  
  char *shmdata;
  shmdata = (char *)shmat (packet->shmid, 0, 0);
  printf ("SHMRESULT [%d]\n", (int)shmdata);
  memcpy (shmdata, data, datasize);
  shmdt (shmdata);

  packet->size = datasize;
  packet->option = option;
  packet->message=message;
  sendpackets.enqueue (packet);
}

void
SHMComm::slotWriteMessage (KSocket *)
{
  if (!sendpackets.isEmpty())
    {
      SPacket *packet = sendpackets.dequeue();
      printf ("WRITE [%d]\n", packet->message);
      write (socket(), packet, sizeof (SPacket));

      delete packet;
    }
}

KPComm::KPComm (const char *socketfilename) : SHMComm (socketfilename)
{}
KPComm::KPComm (int socket) : SHMComm (socket)
{}




//Convenience methods for KPServer messages
void
KPComm::sendMatrixDescription (int matrixid, int nrows, int ncols, const char *name)
{
  SKPCMatrixDesc matdesc;
  matdesc.nrows = nrows;
  matdesc.ncols = ncols;
  strncpy (matdesc.name, name, 255);
  send (KPCMatrixDesc, matrixid, &matdesc, sizeof (SKPCMatrixDesc));
}

void
KPComm::sendMatrix (int matrixid, int nrows, int ncols, double *matrix)
{
  send (KPCMatrix, matrixid, matrix, 
	nrows*ncols*sizeof (double));
}
