#ifndef __XDevice_CLASS__
#define __XDevice_CLASS__

#include <list.h>
#include <device.h>
#include <qpixmap.h>
#include <xobject.h>
#include <device.h>

class XWire;

/********************************************
* a device                                  *
*********************************************/
class XDevice: public XObject, public Device
{
public:
	XDevice(int func, int x, int y);
	XDevice(int func, int x, int y, int size, int del, int undef, int clock);
	~XDevice();

	// settings for all devices
	static int defSize();
	static void setDefSize(int);
	static int isDefInverted();
	static void setDefInverted(int);
	static void displayTextGlobal(int);
	static int textDisplayedGlobal();

	// positioning methods
	int contains(QPoint);
	int contains(QRect);
	int setPos(QPoint);

	// drawing methods
	void erase(QPainter *);				// erase device image
	void setImage();				// internal redraw of the device pixmap
	void drawImage(QPainter *);			// draw device as lines and text to a printer device
	int setColor();					// set image by actual state of input/output  (e.g. LED)
	void drawImage(QPaintDevice *, QPainter *);	// the usual method to draw devices!

	// graph methods
	int drawGraph();
	int graphEnabled();
	void enableGraph(int);
	int invertGraph(int, int);

	// some status methods
	int size();
	int setSize(int);
	int neededSize();
	int isEditable();
	int isInverted();
	void setInverted(int);
	int maxI();
	int currI();
	void setMaxI(int);
	int maxO();
	int currO();
	void setMaxO(int);
	void setClock(int);
	void displayText(int);
	int textDisplayed();
	void setText(QString);

	// device import/export
	QString device2string(int, int);
	int string2device(QString, int, int);

	// special cases: properties dialog methods
	// return pointers to input/output lists
	// called by DevProp
	list<XWire> *getIRef();
	list<XWire> *getORef();

	// check and set/reset connections
	int checkConnection(XWire *, int invert = 0);

	// called by wire: add/remove connections
	void addInput(XWire *, int);
	void removeInput(XWire *, int);
	void addOutput(XWire *);
	void removeOutput(XWire *);

	// remove garbage from wires
	void garbageCollection();

	// add/remove named inputs/outputs (overloaded from class Device)
	int addInputName(QString, int pos = -1, int dev_id = 0);
	int changeInputName(int, QString);
	void removeInputName(int);
	int addOutputName(QString, int pos = -1, int dev_id = 0);
	int changeOutputName(int, QString);
	void removeOutputName(int);

	// set connection-lines	(connected by wires)
	void eraseConnectionLines(QPainter *prt = (QPainter *)NULL);
	void drawConnectionLines(QPainter *prt = (QPainter *)NULL);

	static void loadPix();

        static const int MINSIZE=2;
        static const int MAXSIZE=99;
        static const int MAXI=99;
        static const int MAXO=99;
	static const int MAXOSZCNT=10000;

private:
	static int STATdef_size;
	static int STATdef_inverted;
	static int STATdisplay_name;

	// some usual pixmaps
	static QPixmap *pxPOS, *pxNEG;
	static QPixmap *PTOPL, *PMIDL, *PBOTL, *PTOP, *PMID, *PBOT;
	static QPixmap *pxOUT, *pxIN, *pxLED0, *pxLED1, *pxSWI0, *pxSWI1;
	static QPixmap *pxJKF, *pxJK, *pxRSCMF, *pxRS, *pxRSC, *pxRSCM, *pxDM, *pxD;
	static QPixmap *pxSSB, **pxSS;
	static QPixmap *pxLED0blue, *pxLED1blue, *pxLED0red, *pxLED1red, *pxLED0green, *pxLED1green, *pxLED0yellow, *pxLED1yellow;
	// devices symbols
	static QPixmap *syAND, *syOR, *syXOR, *syINV, *syOSZ, *syNET, *sySS, *syMONOFLOP;
	static int pix_loaded;

	void setFuncDep(int);
	void setRegions();
	void updateWires();

	int checkInput(XWire *, int, int);
	int connectInput(XWire *, QPoint, int, int output_id = 0);
	int checkOutput(XWire *, int, int);
	int connectOutput(XWire *, QPoint, int, int output_id = 0);

	void setInputLine(XWire *, QColor, int, QPainter *prt = (QPainter *)NULL, int x = 0, int y = 0);
	void setOutputLine(XWire *, QColor, QPainter *prt = (QPainter *)NULL, int x = 0, int y = 0);

	QRect input_region;
	QRect output_region;

	list<XWire> in_w;
	list<XWire> out_w;

	// some device parameters
	int _size;
	int _maxi;
	int _maxo;
	int editable;
	int inverted;
	int graph_enabled;

	// text device, optionally displayed above this
	XDevice *text_dev;
};

#endif

