#ifndef __DEVW_CLASS
#define __DEVW_CLASS

class QWidget;
class QPaintEvent;
class QCheckBox;
class QButtonGroup;
class QScrollBar;
class XWire;
class DevWidget;

#include <xdevice.h>
#include <list.h>

class InverterWidget : public QWidget
{	Q_OBJECT
public:
	InverterWidget(QWidget *, const char *, XDevice *);
	~InverterWidget();
	void setGeometry(int, int, int, int);
	void paintEvent(QPaintEvent *);
	void setInputButtons();
	void setOutputButtons();

private slots:
	void vScroll(int);

private:
	DevWidget *devw;
	QScrollBar *vscroll;
	XDevice *dev;
	int curr_y_size;
};


class DevWidget : public QWidget
{	Q_OBJECT
public:
	DevWidget(QWidget *, const char *, XDevice *);
	~DevWidget();
	void paintEvent(QPaintEvent *);
	void setInputButtons();
	void setOutputButtons();

private slots:
	void inputButton(int);
	void outputButton(int);
private:
	XDevice *dev;

	QCheckBox *iswitch[XDevice::MAXSIZE];
	list<XWire> iwire[XDevice::MAXSIZE];
	QButtonGroup *bg_i;
	QCheckBox *oswitch[XDevice::MAXSIZE];
	list<XWire> owire[XDevice::MAXSIZE];
	QButtonGroup *bg_o;
};

#endif
