#ifndef __XObject_CLASS__
#define __XObject_CLASS__

class QPaintDevice;
class QPainter;
class QPixmap;

// input/output region (x-pixel)
#define IOREG	4

// standard vertical offset of an object
#define VOFFSET	3

/*********************************************
* screen-object
*********************************************/
class XObject
{
public:
	XObject();
	~XObject();

	// vertical image offset
	void setVOffset(int);
	void setHOffset(int);
	int getVOffset();

	// should be private: _initial_ positioning
	void initPos(int, int);

	// object movement
	QRect getPos();
	int setPos(QPoint);
	void addPos(int, int);

	// undo movement methods
	void setOrigin();
	void toOrigin();
	int isOrigin(QPoint);

	// pixmap methods
	void drawImage(QPaintDevice *, QPainter *p);
	QPixmap *getImage();

	// selection methods
	void select(int);
	int isSelected();

protected:
	QRect getOldPos();
	int contains(QPoint, int, int);
	int contains(QRect);
	void setImage();

	void erase(QPainter *);
private:
	QPoint origin;
	// positions on the screen
	QRect oldPos;
	QRect newPos;
	// delta between grabbed and true position
	QPoint delta;
	// image of object
	QPixmap *img;

	// image offset
	int voffset;
	int hoffset;

	// flag if object s selected or not
	int selected;
};

#endif

