#ifndef __NETWCLASS
#define __NETWCLASS

#include <qframe.h>
class QPainter;
class QRect;
class QMouseEvent;
class QTimer;
class QPaintEvent;
class QPopupMenu;

class XDeviceNet;
class XDevice;
class XWire;
class Selection;

#define RPOP_DEL	100
#define RPOP_PROP	101
#define RPOP_SUB	102
#define RPOP_SUBW	103
#define RPOP_GRAPH	104
#define RPOP_SHOWGRAPH	105
#define RPOP_EQU	106

#define RPOPSEL_CUT	100
#define RPOPSEL_COPY	101
#define RPOPSEL_PASTE	102
#define RPOPSEL_PASTEAT 103

class NetWidget : public QFrame
{	Q_OBJECT
public:
	NetWidget(QWidget *, QWidget *);
	NetWidget(QWidget *, QWidget *, XDeviceNet *);
	~NetWidget();

	// draw mode should be static
	static void setDrawMode(int);
	static int getDrawMode();

	// sim mode should be static
	static void setSimMode(int);
	static int getSimMode();
	static void setDevice(int);

	void toParentNet();
	XDeviceNet *getActive();
	int contained(XDeviceNet *);

	void removeSelection();

	int saveNet(QString);
	int openNet(QString, int init=0);
	int newNet();
	int printNet(QPainter *);
	void showCircuitEquations();
	void showDeviceEquations();
	void applyDefaults();

	static const int MODE_DRAW = 500;
	static const int MODE_DROP = 501;
	static const int MODE_SEL = 502;
	static const int MODE_SIM_STEP = 502;
	static const int MODE_SIM_MULT = 503;

	static const int MIN_SIMSTEPTIME = 1;
	static const int MAX_SIMSTEPTIME = 400;
	static const int MIN_SIMBURST = 1;
	static const int MAX_SIMBURST = 99999;

	static int simTime();
	static void setSimTime(int);
	static int simBurst();
	static void setSimBurst(int);

	static QTimer simTimer;

signals:
	void netChanged(int);
	void netDeleted(XDeviceNet *);
	void netContentChanged();
	void createNewWidget(XDeviceNet *);
	void simStepped();

	void graphChanged();
	void showGraph(XDeviceNet *);

public slots:
	void visible(QRect);
	void delayChanged();
	void simStep();
	void rmenuCallback(int);
	void rmenuSelCallback(int);

private:
	int toSubNetW();
	int toSubNet();
	void deleteDev(int);
	int openProp();

	static int STATsimBurst;
	static int STATsimStepTime;
	static int drawmode;
	static int simmode;
	static int actualDevFunc;

	QWidget *_parent;
	QRect visi;

	void mousePressEvent( QMouseEvent * );
	void mouseReleaseEvent( QMouseEvent * );
	void mouseMoveEvent( QMouseEvent * );
	void mouseDoubleClickEvent( QMouseEvent * );
	void paintEvent(QPaintEvent *);
	void selRightMenu(QMouseEvent *);
	void selRightSelMenu(QMouseEvent *);

	XDeviceNet *activeNet;
	XDevice *activeDev;
	XWire *activeWire;
	Selection *activeSelection;

	QPopupMenu *rpop;
	QPopupMenu *rselpop;

	int changed;
	int rmenuActive;
	int client;
	int movecursor;
};

#endif
