/*
 * cwidget.cpp
 *
 * Copyright (C) 2000 Matthias Lieber <Mali_@web.de>
 */
#include "cwidget.h"

#include <qwidget.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapp.h>
#include <qpalette.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <kfiledialog.h>
#include <kprocess.h>
#include <iostream.h>

extern bool Restart;

CWidget::CWidget()
    :QWidget()
{
    readConfig();

    setMinimumWidth(260);
    setFixedHeight(140);
    resize(260,140);

    Ok = new QPushButton(i18n("&Ok"),this);
	connect( Ok,SIGNAL(clicked()),this,SLOT(ok()) );
	Cancel = new QPushButton(i18n("&Cancel"),this);
	connect( Cancel,SIGNAL(clicked()),this,SLOT(cancel()) );
	Ok->setGeometry(width()-170,110,80,25);
	Cancel->setGeometry(width()-85,110,80,25);

    QLabel *t1 = new QLabel(i18n("Let me know"),this);
    t1->setGeometry(5,5,(t1->sizeHint()).width(),20);

    Spinbox = new QSpinBox(0,365,1,this);
    Spinbox->setGeometry(10+(t1->sizeHint()).width(),5,40,20);
    Spinbox->setValue(Days);
    connect( Spinbox,SIGNAL(valueChanged(int)),this,SLOT(daysChanged(int)) );

    QLabel *t2 = new QLabel(i18n("days in advance."),this);
    t2->setGeometry(15+t1->width()+Spinbox->width(),5,(t2->sizeHint()).width(),20);

    line1 = new QFrame(this);
    line1->setGeometry(0,30,width(),10);
    line1->setFrameStyle(QFrame::Sunken | QFrame::HLine);

    t3 = new QLabel(i18n("Calendar file:"),this);
    t3->setGeometry(5,45,(t3->sizeHint()).width(),20);

    Led = new QLineEdit(this);
    Led->setGeometry(10+t3->width(),45,width()-(15+t3->width()),20);
    Led->setText(Filename);

    Browse = new QPushButton(i18n("&Browse"),this);
	connect( Browse,SIGNAL(clicked()),this,SLOT(browse()) );
	Edit = new QPushButton(i18n("&Edit"),this);
	connect( Edit,SIGNAL(clicked()),this,SLOT(edit()) );
    New = new QPushButton(i18n("&New File"),this);
	connect( New,SIGNAL(clicked()),this,SLOT(newFile()) );
    New->setGeometry(90,70,80,20);
    Browse->setGeometry(5,70,80,20);
	Edit->setGeometry(175,70,80,20);

    line2 = new QFrame(this);
    line2->setGeometry(0,95,width(),10);
    line2->setFrameStyle(QFrame::Sunken | QFrame::HLine);


}

void CWidget::resizeEvent(QResizeEvent *)
{
    Led->resize( width()-(15+t3->width()),Led->height() );
    line1->resize(width(),line1->height());
    line2->resize(width(),line2->height());
    Ok->move(width()-170,Ok->y());
    Cancel->move(width()-85,Cancel->y());
}


void CWidget::edit(void)
{
    // Edit the file Filename with KWrite
    KProcess pro;
    pro << "kwrite" << Filename;
  	pro.start(KProcess::DontCare);
}

void CWidget::browse(void)
{
    QString file;
    QString dir=getDir(Filename);
    file=KFileDialog::getOpenFileName( dir,"",this,i18n("Open Calendar File"));
    if (file)
    {
        Filename=file;
        Led->setText(Filename);
    }
}

void CWidget::newFile(void)
{
    QString file;
    QString dir=getDir(Filename);
    file=KFileDialog::getSaveFileName( dir,"",this,i18n("New Calendar File"));

    if (file)
    {
        Filename=file;
        Led->setText(Filename);
        edit();
    }
}

QString CWidget::getDir(const QString path)
{
	int l;
	int pos;
	l=path.length();
	if (!l)
		return( QString("/") );
	pos=path.findRev("/",l);
	QString r = path.mid(0,pos);
	return(r);
}

void CWidget::readConfig(void)
{
    // load config
    kapp->config()->setGroup("Config");
    Filename=( kapp->config()->readEntry("File",QString()) ).data();
    Days=kapp->config()->readNumEntry("Days",10);

}

 void CWidget::writeConfig(void)
{

}

void CWidget::daysChanged(int d)
{
    Days=d;
}

void CWidget::ok(void)
{
    kapp->config()->setGroup("Config");
    Days=Spinbox->value();
    Filename=Led->text();
    // save config
    kapp->config()->writeEntry("File",Filename);
	kapp->config()->writeEntry("Days",Days);
    hide();
    // SIGANL changed() restarts the KMainWindow klendar
    emit changed();
}

void CWidget::cancel(void)
{
    // set Spinbox to old value
    Spinbox->setValue(kapp->config()->readNumEntry("Days",10));
    Led->setText( kapp->config()->readEntry("File",QString()) );
    hide();
}


