/***************************************************************************
                          kextable.cpp  -  description
                             -------------------
    begin                : Tue Mar 5 2002
    copyright            : (C) 2002 by Tero Favorin
    email                : tero@favorin.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qtable.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qvbox.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <kstddirs.h>
#include <klocale.h>
#include <kdialog.h>
#include <kcombobox.h>

#include "kexdatasource.h"
#include "kexsource.h"
#include "kexrateitem.h"
#include "kextable.h"

#define CURRENCYCOL 0
#define CODECOL 1
#define RATECOL 2

KExTable::KExTable(QWidget * parent=0, const char * name=0, WFlags f=0):QWidget(parent,name,f) {
	QVBoxLayout *layout =new QVBoxLayout(this,KDialog::marginHint(),KDialog::spacingHint());

	QHBox *baseBox=new QHBox(this);
	baseBox->setSpacing(KDialog::spacingHint());
	layout->addWidget(baseBox);
	base = new QLabel(i18n("Base currency"),baseBox);
	baseCombo=new KComboBox(baseBox);
	QToolTip::add( baseCombo, i18n("Rates table base currency") );
	QWhatsThis::add( baseCombo, i18n("This is the base currency to which all currencies in the table are compared to.") );
	connect (baseCombo,SIGNAL(activated(int)),this,SLOT(updateBase(int)));

	table=new QTable(1,3,this);
	layout->addWidget(table);
	table->setSelectionMode(QTable::NoSelection);
	table->setLeftMargin( 0 );
  table->verticalHeader()->hide();
  table->horizontalHeader()->setLabel(CURRENCYCOL,i18n("Currency"));
  table->horizontalHeader()->setLabel(CODECOL,i18n("Code"));
  table->horizontalHeader()->setLabel(RATECOL,i18n("Exchange rate"));

	source=new KExSource(this);
	layout->addWidget(source);

	locale=new KLocale();
}
KExTable::~KExTable(){
}
void KExTable::setOptions(KExDataSource *d, bool e) {
	QPixmap flag;

	data=d;
	oldeuro=e;
	source->setSource(data);
	list=data->getCurrencies(oldeuro);
	table->setNumRows(list.count());
	baseCombo->clear();
	int row=0;
  for ( QStringList::ConstIterator it = list.begin(); it != list.end(); ++it ) {
		flag=data->getFlag(*it);
	  table->setItem(row,CURRENCYCOL,new QTableItem(table,QTableItem::Never,data->getCurrencyName(*it),flag));
	  table->setItem(row++,CODECOL,new QTableItem(table,QTableItem::Never,*it));
	  baseCombo->insertItem(flag, data->getCurrencyName(*it));
  }
	table->adjustColumn(CURRENCYCOL);
	table->adjustColumn(CODECOL);
}
QString KExTable::getBase() {
	return data->getCode(list,baseCombo->currentItem());
}
void KExTable::setBase(QString base) {
	baseCombo->setCurrentItem(list.findIndex(base));	
	updateBase(-1);
}
void KExTable::updateBase(int) {
	QString base=getBase();
	int row=0;
  for ( QStringList::ConstIterator it = list.begin(); it != list.end(); ++it ) {
	  table->setItem(row++,RATECOL,new KExRateItem(table,QTableItem::Never,
			locale->formatNumber(data->getRate(*it,base).rate,5)));
  }	
	table->adjustColumn(RATECOL);
}
