/***************************************************************************
                          kexpacific.cpp  -  description
                             -------------------
    begin                : Tue Mar 5 2002
    copyright            : (C) 2002 by Tero Favorin
    email                : tero@favorin.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qfile.h>
#include <qtextstream.h>

#include <kio/job.h>

#include "kexpacific.h"

#define TAB_CHAR 9

KExPacific::KExPacific(QWidget *w) : KExDataSource(w) {
}
KExPacific::~KExPacific() {
}
const QString KExPacific::source() {
	return "PACIFIC Exchange Rate Service";
}
const QString KExPacific::sourceURL() {
	return "http://pacific.commerce.ubc.ca/xr/";
}
const QString KExPacific::copyright() {
	return " Prof. Werner Antweiler\nUniversity of British Columbia, Vancouver, Canada";
}
void KExPacific::refresh() {
	QByteArray postData;
	QString *args=new QString("rd=7&f=tab&q=volume&y=daily&b=USD&g=z"); //KIO will delete this
	postData.assign(args->latin1(),args->length());
	KIO::TransferJob *job = KIO::http_post( "http://blacktusk.commerce.ubc.ca/cgi-bin/fxdata", postData, false );
	job->addMetaData("content-type", "Content-Type: application/x-www-form-urlencoded" ); // This is a bit strange??
	transferData(job);
}
int KExPacific::readData(QTextStream t) {
	typedef QValueList<QDate> Dates;
	Dates dates;
	QString line,pair,target,base;
	int slash;
	bool ok;
	int row=1;
	int result=0;
	addCurrency("USD");
	while ( !t.eof() ) {
	  line = t.readLine();
		if (row==2) {
			QStringList datelist=QStringList::split(TAB_CHAR,line,true);
			QStringList::ConstIterator it;
      for( it = datelist.begin(); it != datelist.end(); ++it )
          dates.append(parseDate(*it,'/'));
		}
		if (row>2) {
			QStringList ratelist=QStringList::split(TAB_CHAR,line,true);
			QStringList::ConstIterator it=ratelist.begin();
			pair=*it;
			slash=pair.find('/');
			if (slash>0) {
        target=pair.left(slash);
				base=pair.right(pair.length()-slash-1);			
				int i=5;
      	for( it = ratelist.fromLast(); it != ratelist.begin(); --it ) {
					Rate r=(Rate)(*it).toDouble(&ok);
					if (ok && r>0) {
						//qDebug(target+"-"+base+"-"+QString::number(r)+"-"+dates[i].toString());
						addCurrency(target);
						addRate(target,base,r,dates[i],Reliable);
						result++;
						break;
					}
					i--;
				}
			}
		}
		row++;
  }
	storeData();
	return result;
}
