/***************************************************************************
                          mydialog.cpp  -  description
                             -------------------
    begin                : Mon Feb 7 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mydialog.h"

MyDialog::MyDialog(QWidget *parent, const char *name, bool modal, WFlags f )
		: QDialog(parent,name,modal)
{
	QFont fnt("helvetica",12, QFont::Bold);
	fnt.setUnderline(true);

	QLabel *qLab = new QLabel(i18n("Please choose :"), this);
	qLab->setGeometry(10,10,280,30);
	qLab->setFont(fnt);
	qLab->setAlignment(AlignCenter);

	yesBut = new QRadioButton(i18n("KWebGet-Wizard"), this);
	yesBut->setGeometry(60,55,190,20);
	QToolTip::add(yesBut, i18n("The Wizard takes you step by step through the configuration..."));

	noBut = new QRadioButton(i18n("KWebGet-Advanced"),this);
	noBut->setGeometry(60,85,190,20);
	QToolTip::add(noBut, i18n("Set up everything your own..."));

	showAgain = new QCheckBox(i18n("Don't ask again"), this);
	showAgain->setGeometry(10,125,170,20);
	
	closeBut = new MyPushButton(i18n("Exit"), this);
	closeBut->setGeometry(210,125,80,20);
	connect(closeBut, SIGNAL(clicked()), kapp, SLOT(quit()));
}

MyDialog::~MyDialog()
{
}

void MyDialog::closeEvent(QCloseEvent *ce)
{
	// Nothing happens :-)
}