/***************************************************************************
                          gutenbrowser.cpp  -  description
                             -------------------
    begin                : Mon Jul 24 22:33:12 MDT 2000
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/
/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
// http search
//        http://digital.library.upenn.edu/books/authors.html
//        http://digital.library.upenn.edu/books/titles.html


#include "gutenbrowser.h"
#include "LibraryDialog.h"
#include "bookmarksdlg.h"
#include "optionsDialog.h"
#include "helpme.h"
#include "openetext.h"

#include <qplatinumstyle.h>
#include <qmotifstyle.h>
#include <qcdestyle.h>
#include <qsgistyle.h>
#include <stdio.h>
#include <stdlib.h>
#if defined(_WS_WIN_)
#include <windows.h>
#endif
#if defined(_WS_X11_)
#include <unistd.h>
#include "sys/stat.h"
#endif

#include <qpaintdevicemetrics.h>
#include <qvaluelist.h>
#include <qlabel.h>
#include <qclipboard.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qobjectlist.h>
#include <qfontdialog.h>
#include <qtextview.h>
#include <qbrush.h>
#include <qfile.h>
#include <qfontinfo.h>
//#include "pix/gutenbrowser.xpm"
#if defined(_WS_WIN_)

#endif


Gutenbrowser::Gutenbrowser()
{
    local_library = (QDir::homeDirPath ()) +"/.gutenbrowser/";
    QString msg;
    msg="You have now entered unto gutenbrowser,\n";
    msg+="make your self at home, sit back, relax and read something great.\n";

#if defined(_WS_X11_)
    setCaption("linuxgutenbrowser "  VERSION);
    printf(msg);
    this->setIcon(QPixmap("/usr/share/gutenbrowser/pix/gutenbrowser.xpm"));
#endif

#if defined(_WS_WIN_)
    setCaption("winuxgutenbrowser " VERSION);
    if( local_library.find( "//", 0, TRUE) != -1)
        local_library.replace( local_library.find( "//", 0, TRUE) , 2, "/");
    this->setIcon(QPixmap(local_library+"pix/gutenbrowser.xpm"));
#endif
    this->setIcon( QPixmap(local_library+"pix/gutenbrowser.xpm"));
    this->setUpdatesEnabled(TRUE);
    iniFile = local_library + "gutenbrowserrc";
    config = new CConfigFile( iniFile);
    bool firstTime=FALSE;
    if( !QFile(iniFile).exists() ) {
        QMessageBox::message("Note 1", msg);
        firstTime=TRUE;
    }

    config->read();
// call inits to invoke all other construction parts
    qDebug("Starting layout engine.");
    topLayout = new QVBoxLayout( this, 10, 0, "topLayout");
    menu = new QHBoxLayout(10, "menu");
    buttons = new QHBoxLayout(10, "buttons");
    buttons2 = new QHBoxLayout(10, "buttons2");
    edits = new QHBoxLayout(10, "edits");

    initMenuBar();
    initButtonBar();
    initStatusBar();
    initDoc();
    initView();
    qDebug("Adding statusbar widget to topLayout.");
    topLayout->addWidget( statusBar);
    initConfig();
    initSlots();

    if( useIcons)
        toggleButtonIcons( TRUE);
    else
        toggleButtonIcons( FALSE);

    QString pix_dir = local_library+"pix/marble.xpm";
      //parchment.xpm
      //parchment_3.xpm
/*
      QColorGroup mypapcolgrp;
    QColorGroup papcolgrp;
    d->mypapcolgrp = palette().active();
    d->papcolgrp = d->mypapcolgrp;

void QTextView::setPaper( const QBrush& pap)
{
    d->mypapcolgrp.setBrush( QColorGroup::Base, pap );
    d->papcolgrp.setBrush( QColorGroup::Base, pap );
    d->ownpalette = TRUE;
    viewport()->setBackgroundColor( pap.color() );
    viewport()->update();
}


 */
//           QColorGroup mypapcolgrp;
//           Lview.mypapcolgrp=palette().active();
//      QPalette p = Lview->palette();
//        QBrush b;
//        b.setPixmap( pix_dir);
//setPaper(const QBrush & pap)
//      p.setBrush(QColorGroup::Base, b);
//      p.setColor(QColorGroup::Base, QColor(220,220,220));
//       mypapcolgrp.setBrush(QColorGroup::Base, b);
//      Lview->setPalette(p);
//       Lview->setBackgroundColor(b.color());
//      Lview->setBackgroundMode(FixedPixmap);
//      Rview->setBackgroundMode(FixedPixmap);
//      Lview->setForegroundPixmap( QPixmap( pix_dir ) );
//      Rview->setBackgroundPixmap( QPixmap( pix_dir ) );
//x       Lview->update();

        /// hmmmmppfffft the view must not be the background
    // I want setPaper() in this function!!
#if defined(_WS_X11_)
    chdir(local_library);
    QString gutenIndex= local_library + "GUTINDEX.ALL";
    if( QFile( gutenIndex).exists() ) {
        indexLib.setName( gutenIndex);
    } else {
        QString localLibIndexFile= local_library + "PGWHOLE.TXT";
//       if( QFile( localLibIndexFile).exists() ) {
            newindexLib.setName( localLibIndexFile);
//          } else {
//              QString sysLibIndexFile="/usr/share/doc/gutenbrowser/PGWHOLE.TXT";

//              if( QFile( sysLibIndexFile).exists() ) {
//                  newindexLib.setName( sysLibIndexFile);
//              } else
//                  QMessageBox::message("Note","hey");
//             switch( QMessageBox::warning( this, "Application name",
//                                            "Install the library index?",
//                                            QMessageBox::Yes,   QMessageBox::No)) {
//                      case   QMessageBox::Yes: // yes
//           {
//               QString cmd;
//                      cmd="cp "+sysLibIndexFile+" "+localLibIndexFile;
//                      newindexLib.setName( localLibIndexFile);
//                   QMessageBox::message("Note",cmd);
//                   system(cmd);
//           }
//                      break;
//                      case   QMessageBox::No: // No
//                        // exit
//                      break;
//              }
              // }
    }
#endif
#if defined(_WS_WIN_)
    newindexLib.setName( local_library + "PGWHOLE.TXT");
#endif
    qDebug("init finished.");
    if(firstTime)
        Bookmark();

}

Gutenbrowser::~Gutenbrowser()
{
  delete printer;
}

void Gutenbrowser::InfoBarClick()
{
    title.replace( QRegExp("\\s"), "%20");
    QString s_lookup = "http://google.com/search?q="+title+"&num=30&sa=Google+Search";
    goGetit( s_lookup, false);
}

void Gutenbrowser::goGetit( QString url, bool showMsg)
{
int eexit=0;
    config->read();
    config->setGroup( "Browser" );
    QString brow = config->readEntry("Preferred", "");
    if ( showMsg)
    eexit=QMessageBox::information(this, "Note",
                                      "This part under construction.\nDo you want to use "+brow+" to download\n"+url+"?\nPlease save it into the ~/.gutenbrowser directory.",
                                      QMessageBox::Ok, QMessageBox::Cancel);
    if (eexit== 1 || eexit== 0) {
    QString cmd;
#if defined(_WS_X11_)
    if( brow == "Konq") {
        cmd = "konqueror "+url+" &";
    }
    if ( brow == "Netscape") {
        QString str = QDir::homeDirPath() + "/.netscape/lock";
/*          //  struct stat *stat_p;
//
          //  if ( -1 !=  lstat (str, stat_p))  { // if theres a lock file
          //      cmd = "netscape -remote 'openURL( "+url+" )'";
//            KShellProcess proc("bash");
//            proc << "netscape" <<"-remote" << "'openURL(" <<url << ")'";
//            proc.start(KProcess::DontCare,KProcess::All);
*/
//            }
          //  else {
        cmd = "netscape "+url+" &";
    }

    if( brow =="Lynx") {
//      if( url.find(".zip", 0, TRUE)
//        cmd = ""xterm -fg black -bg white -e lynx -source "+ s_lookup + " | cat >> ~/somefile.html";
//        else
        cmd = "xterm -fg black -bg white -e lynx "+url+" &";
    }
    if( brow == "Opera")  {
        cmd = "opera "+url+" &\n";
    }
    if( brow == "Mozilla")  {
        cmd = "mozilla "+url;
    }
    if(brow == "wget")
        cmd="wget -q "+url;
//// http://www.encyclopedia.com/home.html
    chdir(local_library);
    qDebug("Issuing the system command: %s", cmd.latin1());
    system(cmd);
#endif

#if defined(_WS_WIN_)
    QString ind=local_library.left(local_library.length()-1);
    QString m_Player,vip;
    if(!showMsg) {
        m_Player=local_library+"llkcrbrowser.exe";
        vip=" /"+url;
    } else {
        m_Player=local_library+"wget.exe";
        vip=" -q "+url;
    }
    if( !QFile(m_Player).exists() )
      QMessageBox::message("Note","please install llkcrbrowser");
    if( url.find("http://", 0, false))
      url=url.right( url.length()-7);
//    vip=" "+url;
//    vip=" "+url;
    m_Player+=vip;
    WinExec( m_Player, SW_SHOWNORMAL);
//  WinExec( m_Player, SW_HIDE);
#endif
    } else {

    }
}

void Gutenbrowser::toggleButtonIcons( bool useEm) {
    if(useEm)
        useIcons=TRUE;
    else
        useIcons=FALSE;
    QString pixDir;
#if defined(_WS_X11_)
    pixDir="/usr/share/gutenbrowser";
    if(!QDir(pixDir).exists())
    pixDir=local_library;
#endif
#if defined(_WS_WIN_)
  pixDir=local_library;
#endif
    if( useIcons && QDir( pixDir+"/pix").exists() ) {

        DownloadButton->setPixmap( QPixmap( pixDir+"/pix/down.xpm") );
        LibraryButton->setPixmap(  QPixmap( pixDir+"/pix/home.xpm"));
        OpenButton->setPixmap(  QPixmap( pixDir+"/pix/openbook.xpm"));
        ForwardButton->setPixmap(  QPixmap( pixDir+"/pix/forward.xpm"));
        BackButton->setPixmap( QPixmap( pixDir+"/pix/back.xpm") );
        PrintButton->setPixmap(  QPixmap( pixDir+"/pix/fileprint.xpm"));
        SearchButton->setPixmap( QPixmap( pixDir+"/pix/search.xpm") );
        ExitButton->setPixmap( QPixmap( pixDir+"/pix/exit.xpm") );
        lastBmkButton->setPixmap(  QPixmap( pixDir+"/pix/flag.xpm"));
        setBookmarkButton->setPixmap( QPixmap( pixDir+"/pix/tick.xpm") );
        FontButton->setPixmap( QPixmap( pixDir+"/pix/text.xpm") );
        ClearButton->setPixmap(  QPixmap( pixDir+"/pix/eraser.xpm"));
        OptionsButton->setPixmap( QPixmap( pixDir+"/pix/configure.xpm") );
        HelpButton->setPixmap(  QPixmap( pixDir+"/pix/help.xpm"));
        dictionaryButton->setPixmap( QPixmap( pixDir+"/pix/spellcheck.xpm") );
    } else {
        DownloadButton->setText("&Download");
        LibraryButton->  setText("&Library");
        OpenButton->setText("&Open" );
        ForwardButton->setText( "&Forward");
        BackButton->setText("&Back");
        PrintButton->setText("&Print");
        SearchButton->setText("&Search");
        ExitButton->setText("&Exit");
        lastBmkButton->setText("goto &Mark");
        setBookmarkButton->setText("setMa&rk");
        FontButton->setText("Fon&t");
        ClearButton->setText("Cle&ar");
        OptionsButton->setText( "Optio&ns" );
        HelpButton->setText("&About");
        dictionaryButton->setText("Loo&kup");
    }
}


bool Gutenbrowser::queryExit()
{// I hate this, is why its never called
    int exit=QMessageBox::information(this, "Quit...", "Do your really want to quit?", QMessageBox::Ok, QMessageBox::Cancel);
    if (exit==1) {
        writeConfig();
        qApp->quit();
    } else {
    };
    return (exit==1);
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION

void Gutenbrowser::slotFileNew()
{
    statusBar->message("Creating new file...");
    doc->newDoc();
    statusBar->message(IDS_STATUS_DEFAULT);
}

void Gutenbrowser::slotFileOpen()
{
    statusBar->message("Opening file...");

    QString fileName = QFileDialog::getOpenFileName(0,0,this);
    if (!fileName.isEmpty()) {
        doc->load(fileName);
        setCaption(fileName);
        QString message="Loaded document: "+fileName;
        statusBar->message(message, 2000);
    } else {
        statusBar->message("Opening aborted", 2000);
    }
}


void Gutenbrowser::slotFileSave()
{
    statusBar->message("Saving file...");
    doc->save();
    statusBar->message(IDS_STATUS_DEFAULT);
}

void Gutenbrowser::slotFileSaveAs()
{
    statusBar->message("Saving file under new filename...");
    QString fn = QFileDialog::getSaveFileName(0, 0, this);
    if (!fn.isEmpty()) {
        doc->saveAs(fn);
    } else {
        statusBar->message("Saving aborted", 2000);
    }
    statusBar->message(IDS_STATUS_DEFAULT);
}

void Gutenbrowser::slotFileClose()
{
    statusBar->message("Closing file...");
    statusBar->message(IDS_STATUS_DEFAULT);
}

void Gutenbrowser::slotFilePrint()
{
    const int Margin = 10;
    int pageNo = 1;
    statusBar->message("Printing...");
   // QPrinter printer;
    if (printer->setup(this)) {
        QPainter painter;
       if( !painter.begin( printer) )
         return;

          ///////////////////////////////////////////////////////////////////
          // TODO: Define printing by using the QPainter methods here
        // oh man, your gonna make ME do some qwork here?
        // i dont even have a printer hooked up..
 //      QMessageBox::message("Note","yo, printer isn't hooked up\n >>=====>    :D    <=====<<");
  /// hmm that was easy!
       // thanks QT! from Application.cpp
    painter.setFont( Lview->font() );
    int yPos    = 0;            // y position for each line
    QFontMetrics fm = painter.fontMetrics();
    QPaintDeviceMetrics metrics( printer ); // need width/height
                        // of printer surface
    for( int i = 0 ; i < Lview->numLines() ; i++ ) {
        if ( Margin + yPos > metrics.height() - Margin ) {
        QString msg( "Printing (page " );
        msg += QString::number( ++pageNo );
        msg += ")...";
        statusBar->message( msg );
        printer->newPage();     // no more room on this page
        yPos = 0;           // back to top of page
        }
        painter.drawText( Margin, Margin + yPos,
            metrics.width(), fm.lineSpacing(),
            ExpandTabs | DontClip, Lview->textLine( i ) );
        yPos = yPos + fm.lineSpacing();
    }

  painter.end();
    };
    statusBar->message(IDS_STATUS_DEFAULT);
}

void Gutenbrowser::slotFileQuit()
{
    statusBar->message("Exiting application..."); //heh
      // exits the Application
    if(doc->isModified()) {
        if(queryExit()) {
            qApp->quit();
        } else {
        };
    } else {
        qApp->quit();
    };
    statusBar->message(IDS_STATUS_DEFAULT);
}

void Gutenbrowser::slotEditCut()
{
    statusBar->message("Cutting selection...");
    statusBar->message(IDS_STATUS_DEFAULT);
}

void Gutenbrowser::slotEditCopy()
{
    statusBar->message("Copying selection to clipboard...");
    statusBar->message(IDS_STATUS_DEFAULT);
}

void Gutenbrowser::slotEditPaste()
{
    statusBar->message("Inserting clipboard contents...");
    statusBar->message(IDS_STATUS_DEFAULT);
}

void Gutenbrowser::slotViewToolBar()
{
    statusBar->message("Toggle toolbar...");
      // turn Toolbar on or off

    if (fileToolbar->isVisible()) {
        fileToolbar->hide();
        viewMenu->setItemChecked(ID_VIEW_TOOLBAR, false);
    } else {
        fileToolbar->show();
        viewMenu->setItemChecked(ID_VIEW_TOOLBAR, true);
    };
    statusBar->message(IDS_STATUS_DEFAULT);
}

void Gutenbrowser::slotViewStatusBar()
{
    statusBar->message("Toggle statusbar...");
      //turn Statusbar on or off

    if (statusBar->isVisible()) {
        statusBar->hide();
        viewMenu->setItemChecked(ID_VIEW_STATUSBAR, false);
    } else {
        statusBar->show();
        viewMenu->setItemChecked(ID_VIEW_STATUSBAR, true);
    }
    statusBar->message(IDS_STATUS_DEFAULT);
}

void Gutenbrowser::slotHelpAbout()
{
      //QMessageBox::about(this,"About...", IDS_APP_ABOUT ); //FIXME
}

void Gutenbrowser::slotStatusHelpMsg(const QString &text)
{
qDebug("%s",text.latin1());
      // change status message of whole statusbar temporary (text, msec)
//    statusBar->message(text, 2000);
//    HelpBtn();
}

//  void Gutenbrowser::statusCallback(int id_)
//  {
//      switch (id_)
//      {
//          case ID_FILE_NEW:
//              slotStatusHelpMsg("Creates a new document");
//              break;

//          case ID_FILE_OPEN:
//              slotStatusHelpMsg("Opens an existing document");
//              break;

//          case ID_FILE_SAVE:
//              slotStatusHelpMsg("Saves the actual document");
//              break;

//          case ID_FILE_SAVE_AS:
//              slotStatusHelpMsg("Saves the actual document as...");
//              break;

//          case ID_FILE_CLOSE:
//              slotStatusHelpMsg("Closes the actual document");
//              break;

//          case ID_FILE_PRINT:
//              slotStatusHelpMsg("Prints out the actual document");
//              break;

//          case ID_FILE_QUIT:
//              slotStatusHelpMsg("Quits the application");
//              break;

//          case ID_EDIT_CUT:
//              slotStatusHelpMsg("Cuts the selected section and puts it to the clipboard");
//              break;

//          case ID_EDIT_COPY:
//              slotStatusHelpMsg("Copies the selected section to the clipboard");
//              break;

//          case ID_EDIT_PASTE:
//              slotStatusHelpMsg("Pastes the clipboard contents to actual position");
//              break;

//          case ID_EDIT_SELECT_ALL:
//              slotStatusHelpMsg("Selects the whole document contents");
//              break;

//          case ID_VIEW_TOOLBAR:
//              slotStatusHelpMsg("Enables/disables the toolbar");
//              break;

//          case ID_VIEW_STATUSBAR:
//              slotStatusHelpMsg("Enables/disables the statusbar");
//              break;

//          case ID_HELP_ABOUT:
//              slotStatusHelpMsg("Shows an aboutbox");
//              break;
//      }
//  }

/*exits the app*/
void Gutenbrowser::ByeBye()
{
    if (b_queryExit)
        queryExit();
    else {
        writeConfig();
        qApp->quit();
        }
}

void Gutenbrowser::HelpBtn()
{
    statusBar->message("Help me...");
    statusBar->message(IDS_STATUS_DEFAULT);
    HelpMe* HelpDlg;
    HelpDlg = new HelpMe( this, "Help Dialog");
    HelpDlg->show();
}

void Gutenbrowser::DownloadIndex()
{
    {
        switch( QMessageBox::information( 0, (tr("Download Library Index, or FTP sites?")),
                                          (tr("Do you want to download the newest\n"
                                              "Project Gutenberg Library Index?\n"
                                              "or select an ftp site?\n")),
                                          (tr("&Library Index")), (tr("&Ftp Site")), (tr("&Cancel")), 2, 2 ) )
        {
            case 0: // index clicked,
                downloadLibIndex();
            break;

            case 1: // ftp selected
                downloadFtpList();
            break;

            case 2: // Cancel
                break;
        };
            }
} // end DownloadIndex

void Gutenbrowser::downloadFtpList()
{
    setCursor( waitCursor );
      //  QString cmd="wget http://www.promo.net/pg/list.html");
//system(cmd);
    optionsDialog* optDlg;
    optDlg = new optionsDialog( this,"Options_Dlg", true);
    optDlg->getSite();
    if(optDlg)
        delete optDlg;
    setCursor(  arrowCursor);
}


void Gutenbrowser::downloadLibIndex()
{
setCursor( waitCursor );
                  // QString dwmloader = local_library + "pgwhole.zip";
                  // QString cmd = "lynx -source http://www.gutenberg.net/pgwhole.zip | cat >> " + dwmloader;
                  //                  system(cmd);

//                QString outputFile= local_library+ "GUTINDEX.ALL";
//                config->setGroup( "FTPsite" );  // ftp server config
//                ftp_host=config->readEntry("SiteName", "");
//                ftp_base_dir= config->readEntry("base",  "");
//                QString networkUrl= "ftp://"+ftp_host+ftp_base_dir+"/GUTINDEX.ALL";
                QDir dir( local_library);
#if defined(_WS_WIN_)
    if( local_library.find( "//", 0, TRUE) != -1)
      local_library.replace( local_library.find( "//", 0, TRUE) , 2, "/");
    local_library=dir.convertSeparators(local_library);
#endif
    dir.cd("", TRUE);
    goGetit( "http://www.gutenberg.net/pgwhole.zip", true); // until ghttp works on binaries -qt3
//                NetworkDialog *NetworkDlg;
//                NetworkDlg = new NetworkDialog( this,"Network Protocol Dialog", TRUE, 0, networkUrl, outputFile );
//                if( NetworkDlg->exec() != 0 )
//                { // use new, improved, *INSTANT* network-dialog-file-getterer
  ////              QMessageBox::message("Note","");
//                }
                setCursor(  arrowCursor);
                cursor();
              // if(NetworkDlg)
                //    delete NetworkDlg;
}

//void Gutenbrowser::setBrowser()
//{
//    BrowserChooserDialog*     browserDlg;
//    browserDlg = new BrowserChooserDialog( this,"Choose Browser Dialog", TRUE, 0);
//    browserDlg ->exec();// != 0 )
/// for dictionary lookups
//     brow =  browserDlg->browserName;
//     config->setGroup( "Browser" );
//     config->writeEntry("Preferred",brow);
//     config->write(); // ????
// if(browserDlg)
//     delete browserDlg;
//}

void Gutenbrowser::PrintBtn()
{
    statusBar->message(IDS_STATUS_DEFAULT);
    slotFilePrint();

}

void Gutenbrowser::SearchBtn()
{
  if( loadCheck)
    Search();
//  else
//  QMessageBox::message("Note","Sorry, can't search. No etext is loaded");
}

void Gutenbrowser::ForwardBtn()
{
    QString topR;
    QString lastR;
    QString pageR;
    int sizer =  Rview->lastRow() - Rview->topRow();
    int i_rLastRow = Rview->lastRow();
    int i_numbLines = Rview->numLines();

    if( i_pageNum != pages) {
        if( sizer > ( i_numbLines - i_rLastRow) ) {
//        if( Rview->lastRow() <= i_numbLines ) {
            Lview->MultiLine_Ex::ScrollUp( i_numbLines - i_rLastRow);
            Rview->MultiLine_Ex::ScrollUp( i_numbLines - i_rLastRow);
        } else {
            for (int i = 0; i <2; i++) {
                Lview->MultiLine_Ex::pageDown( FALSE);
                Rview->MultiLine_Ex::pageDown( FALSE);
            }
            i_pageNum++;
            status= title + (tr("  :page "));
            setStatus();
            Lview->setCursorPosition( Lview->Top(), 0, FALSE);
        }
    } else {
        status = title+(tr(" End of book  "));
        setStatus();
    }
}

void Gutenbrowser::BackBtn()
{
    QString topR;
    QString lastR;
    QString pageR;
    int sizer =  Lview->lastRow() - Lview->topRow();
    int i_topRow = Lview->topRow();

    if( sizer > i_topRow ) {
        Lview->MultiLine_Ex::ScrollDown( i_topRow);
        Rview->MultiLine_Ex::ScrollDown( i_topRow);
    } else {
        if (Lview->atBeginning()) {
            status= (tr("Start of book  "));
            setStatus();
        } else {
            for (int i = 0; i <2; i++) {
                Rview->MultiLine_Ex::pageUp( FALSE);
                Lview->MultiLine_Ex::pageUp( FALSE);
            }
            i_pageNum--;
            if( i_pageNum < 1)
                i_pageNum = 1;
            status= title + (tr("  :page "));
            setStatus();
        }
//          Rview->MultiLine_Ex::pageUp( FALSE);
        Lview->setCursorPosition( Lview->Top(), 0, FALSE);
    }
    for (int i = 0; i <2; i++) {
//                Lview->scrollBy(0 ,-Lview->visibleHeight() );
//                Rview->scrollBy(0 ,-Rview->visibleHeight() );
    }
    i_pageNum--;
    if( i_pageNum < 1)
        i_pageNum = 1;
    status=( tr("  :page "));
    setStatus();
//          }
//          Lview->setCursorPosition( Lview->Top(), 0, FALSE);
//      }
}

bool Gutenbrowser::UnZipIt(QString zipFile)
{
      ///usr/bin/unzip";
    if( QFile::exists( zipFile)) {
      // TODO findsome other way of dealingwithzip files.
//            QString thatFile = local_library +"PGWHOLE.TXT";
#if defined(_WS_X11_)
        QString cmd = "unzip -o " + zipFile /*newestLibraryFile  */+" -d " + local_library;
#endif
#if defined(_WS_WIN_)
      QString temp= QDir::convertSeparators(local_library);
      zipFile=QDir::convertSeparators( zipFile);
      QString cmd = temp+"unzip.exe -o " +zipFile/*newestLibraryFile  */+" -d " + temp;
#endif

        int exit=QMessageBox::information(this, "Ok to unzip?",
                                          "Ok to unnzip "+ zipFile+" ?",
                                          QMessageBox::Yes, QMessageBox::No);
        if (exit==QMessageBox::Yes) {
#if defined(_WS_X11_)//
          system( cmd);
#endif
#if defined(_WS_WIN_)
            WinExec( cmd, SW_HIDE );
#endif
            remove( zipFile);
            return true;
        }
        else if(exit==QMessageBox::No) {
            qDebug("unzip");
            return false;
        }
    }
    else
        QMessageBox::message( "Note",( tr("Please install unzip in your PATH")) );
    return false;
}


/*
 Loads the selected exext into the view*/
bool Gutenbrowser::load( const char *fileName)
{
    statusBar->message(IDS_STATUS_DEFAULT);
    QString o_file = fileName;
#if defined(_WS_X11_)
    if( o_file.left(1) != "/") {
        o_file = local_library + o_file;
    }
#endif
#if defined(_WS_WIN_)
    if( o_file.find( "//", 0, TRUE) != -1)
      o_file.replace( o_file.find( "//", 0, TRUE) , 2, "/");
#endif

    if (i_pageNum == 0) {
        i_pageNum = 1;
    }
    QFile f( o_file);
    if ( !f.open( IO_ReadOnly)) {
        QMessageBox::message( (tr("Note")), (tr("File not opened sucessfully." +o_file)) );
        return  false;
    }
    QTextStream t(&f);
    QString s, first, second;
    int i=0;
    while ( !t.atEnd()) {
    s+=t.readLine()+"\n";
    i++;
    }
    Lview->setText( s );
    Rview->setText( s );
    f.close();
    setCaption( fileName );
    Lview->setAutoUpdate( TRUE);
    Rview->setAutoUpdate( TRUE);
//    Lview->repaint();
//    Rview->repaint();
    Rview->setCursorPosition(0,1,FALSE);
    Rview->MultiLine_Ex::pageDown( FALSE);
    Lview->setCursorPosition(0,0,FALSE);

    pages = (( Lview->numLines() / Lview->editSize() ) / 2 ) +1;
    status = title +(tr("  :page "));

    setStatus();
    Lview->setCursor(  arrowCursor);
    Rview->setCursor(  arrowCursor);
    loadCheck = true;
    return false;
} // end load

/* searches opened etext for words*/
void Gutenbrowser::Search()
{
  if(!searchDlg){
  searchDlg = new SearchDialog( this, "Search", true);
  searchDlg->setCaption( tr( "Etext Search"  ) );
  searchDlg->setLabel( "searches etext.");
  connect( searchDlg,SIGNAL( search_signal()),this,SLOT( search_slot()));
  connect( searchDlg,SIGNAL( search_done_signal()),this,SLOT( searchdone_slot()));
  }
    QString resultString;
//  // If we already searched / replaced something before make sure it shows
//  // up in the find dialog line-edit.
//
          //searchDlg->getText();
          //  if(string.isEmpty())
          //  searchDlg->setText(pattern); //// FIXME
        QString string = searchDlg->searchString;
        Lview->deselect();
 //       QPoint point = Lview->mapToGlobal (QPoint (0,0));
   //     QRect pos = Lview->geometry();
//          searchDlg->setGeometry( point.x() + pos.width()/2  -  searchDlg->width()/2,
//                                  point.y() + pos.height()/2 -  searchDlg->height()/2,
//                                  searchDlg->width(),
//                                  searchDlg->height());

    searchDlg->show();
    searchDlg->result();
    AdjustStatus();
}

/*
  Starts the etext search work */
void Gutenbrowser::search_slot( )
{
  int line, col;
  if (!searchDlg /*&& !loadCheck */)
    return;
  Lview->getCursorPosition(&line,&col);
  QString to_find_string=searchDlg->get_text();

  // searchDlg->get_direction();// is true if searching backward
  if ( last_search != 0 && searchDlg->get_direction() ){
    col = col  - pattern.length() - 1 ;
  }
again:
  int  result = doSearch( to_find_string , searchDlg->case_sensitive() , searchDlg->forward_search(), line, col);
  if(result == 0){
    if(!searchDlg->get_direction()){ // forward search
      int query = QMessageBox::information( searchDlg, "Find",
        "End of document reached.\nContinue from the beginning?",
        "Yes", "No", "", 0,1);
      if (query == 0){
        line = 0;
        col = 0;
        goto again;
      }
    } else { //backward search
      int query = QMessageBox::information( searchDlg, "Find",
        "End of document reached.\nContinue from the beginning?",
        "Yes", "No", "", 0,1);
      if (query == 0){
        QString string = Lview->textLine( Lview->numLines() - 1 );
        line = Lview->numLines() - 1;
        lineCheck = line;
        col  = string.length();
        last_search = -1; //BACKWARD;
        goto again;
      }
    }
  } else {

////    emit CursorPositionChanged(); textLine
  }

}

/*
 Does the etext search work */
int Gutenbrowser::doSearch( QString s_pattern, bool case_sensitive,  bool forward, int line, int col )
{
    int i, length;
    int pos = -1;
    if(forward) {
        QString string;
        for(i = line; i < Lview->numLines(); i++) {
            string = Lview->textLine(i);
            pos = string.find(s_pattern, i == line ? col : 0, case_sensitive);
            if( pos != -1) {
                int top = Lview->Top();
                length = s_pattern.length();
                if( i > Lview->lastRow() ) {
                    Lview->setCursorPosition(i,pos,FALSE);
                    for(int l = 0 ; l < length; l++) {
                        Lview->cursorRight(TRUE);
                    }
                    Lview->setCursorPosition( i , pos + length, TRUE );
                    int newTop = Lview->Top();
                    if(Lview->lastRow() > i)
                    Lview->ScrollUp( newTop - top);
                    AdjustStatus();
                } else {
                    Lview->setCursorPosition(i,pos,FALSE);
                    for(int l = 0 ; l < length; l++) {
                        Lview->cursorRight(TRUE);
                    }
                    Lview->setCursorPosition( i , pos + length, TRUE );
                    AdjustStatus();
                }
                pattern = s_pattern;
                last_search = 1; //FORWARD;
                return 1;
            }
        }
    } else { //////////////// searching backwards
        QString string;
        for( i = line; i >= 0; i--) {
            string = Lview->textLine(i);
            int line_length = string.length();
            pos = string.findRev(s_pattern, line == i ? col : line_length , case_sensitive);
            if (pos != -1) {
                int top = Lview->Top();
                length = s_pattern.length();
                if( i <  Lview->Top() ) {
                    Lview->ScrollDown( Lview->PageSize() );
                    Lview->MultiLine_Ex::pageUp( FALSE );
                    if( ! (line == i && pos > col ) ) {
                        Lview->setCursorPosition( i ,pos ,FALSE );
                        for(int l = 0 ; l < length; l++) {
                            Lview->cursorRight(TRUE);
                        }
                        Lview->setCursorPosition(i ,pos + length ,TRUE );
                        int newTop = Lview->Top();
                        Rview->ScrollUp( newTop - top);
                    }
                } else {
                    if( ! (line == i && pos > col ) ) {
                        Lview->setCursorPosition( i, pos, FALSE );
                        for( int l = 0 ; l < length; l++) {
                            Lview->cursorRight( TRUE);
                        }
                        Lview->setCursorPosition( i, pos + length, TRUE );
                    }
                    pattern = s_pattern;
                    last_search = -1;
                    return 1;
                }
            }
        }
    }
    return 0;
}

void Gutenbrowser::LibraryBtn()
{
    this->setCursor( waitCursor );
    QString newestLibraryFile = local_library +"pgwhole.zip";
    QString zipFile;
    qDebug("Local Library is %s ", local_library.latin1());
#if defined(_WS_X11_)
        zipFile="/usr/bin/unzip";
#endif

#if defined(_WS_WIN_)
        zipFile= local_library+"unzip.exe";
#endif
    if( QFile::exists( newestLibraryFile)) {
        if( QFile::exists(zipFile) ) {
            UnZipIt(newestLibraryFile);
            }
            else
            QMessageBox::message( "Note",( tr("Please install unzip")) );
        }
        LibraryDialog* LibraryDlg;
        LibraryDlg = new LibraryDialog( this, "Library Index" /*, TRUE */);
        if( LibraryDlg->exec() != 0 ) {
            listItemNumber = LibraryDlg->DlglistItemNumber;
            listItemFile =  LibraryDlg->DlglistItemFile;
            listItemYear = LibraryDlg->DlglistItemYear;
            listItemTitle = LibraryDlg->DlglistItemTitle;
            file_name = LibraryDlg->File_Name;
            title = listItemTitle;

                config->setGroup( "Proxy" );
            if( LibraryDlg->checked == 1) {
                config->writeEntry("IsChecked", "TRUE");
                } else {
                config->writeEntry("IsChecked", "FALSE");
            }
                config->write();

            if ( listItemNumber.isNull()) {
                setCursor(  arrowCursor);
                } else {
                setCursor(  arrowCursor);
                i_pageNum = 1;
                if( file_name !="Error" && file_name.length() >2 && !file_name.isEmpty() ) {
                    //replace .zip with txt for opening it.
//                    printf("\nFile name is now\n");
//                    printf(file_name);
//                    printf("\n");
//
//              if( file_name.find(".zip"))
//              {
//              printf("Found zip file\n");
//              QString cmd = "/usr/bin/unzip -o " + local_library+file_name + " -d " + local_library;
//              printf( cmd);
//              system(cmd);
//              remove( file_name);

//              }
//  //
//                    file_name = file_name.left(4)+ ".txt";
                    setTitle();
                    load( file_name);
                } else {
                    printf("Not opening the file.\n");
                }
            }
        }
        if( LibraryDlg)
            delete LibraryDlg;
   setCursor(  arrowCursor);
}

void Gutenbrowser::OpenBtn()
{
    QString s_temp;
    s_temp = status;
    statusBar->message( tr("Opening File" ));
    statusBar->message(IDS_STATUS_DEFAULT);
    OpenEtext* OpenDlg;
    OpenDlg = new  OpenEtext(this,"OpenDlg");
    if( OpenDlg->exec() != 0) {
        title = OpenDlg->openFileTitle;
        file_name = OpenDlg->file;
        i_pageNum = 1;
//        {
          //  if( file_name.find( local_library,0, TRUE))
          //  file_name = local_library + file_name;
        setCursor( waitCursor );
        Lview->setCursor( waitCursor);
        Rview->setCursor( waitCursor);

        if( !file_name.isEmpty() || file_name.length() > 2 ) {
            load(file_name);
        }
//        printf("Browser: "+brow+"\n");
//        }
//        else
//        {
          // file presumable does not exist.
          //   printf( "Etext Error");
          // printf( file_name);
          // printf("\ndoes not exist.\n" );
//       }
    }
//    Rview->scrollBy(0 ,Rview->visibleHeight() );
    Lview->setCursor( arrowCursor);
    Rview->setCursor( arrowCursor);
//    printf("Enjoy....\n");
    setCursor( arrowCursor);
    if( OpenDlg)
        delete OpenDlg;
//    BeginBtn();
    ResizeEdits();
    AdjustStatus();
//  setStatus();
}

void Gutenbrowser::ChangeFont()
{
    bool ok;

    weight= Lview->fontInfo().weight();
    italic = Lview->fontInfo().italic();
    bold=Lview->fontInfo().bold();
    pointSize= Lview->fontInfo().pointSize();
    fontStr=Lview->fontInfo().family();

    if(italic == true)
      italicStr="TRUE";
    else
      italicStr="FALSE";

    QFont currentfont( fontStr, pointSize, weight, italic );
    QFont font = QFontDialog::getFont( &ok , currentfont, this);
    if (ok) {
    QFontInfo fontInfo(font );
    fontStr=fontInfo.family();

    pointSize= fontInfo.pointSize();
    pointSizeStr.setNum( pointSize);
    weight= fontInfo.weight();
    weightStr.setNum( weight);
    italic =fontInfo.italic();
    bold=fontInfo.bold();

    if(italic == true)
      italicStr="TRUE";
    else
      italicStr="FALSE";
    if(bold == true)
      boldStr="TRUE";
    else
      boldStr="FALSE";

      pointSizeStr.setNum( pointSize);
      config->setGroup( "Font" );
      config->writeEntry("Family", fontStr );
      config->writeEntry("Size", pointSizeStr );
      config->writeEntry("Weight", weightStr );
      config->writeEntry("Italic", italicStr );
      config->writeEntry("Bold", boldStr );
      config->write();

      Lview->setFont(font);
      Rview->setFont(font);
      QRect lRect;
      QRect rRect;
      lRect = Lview->rect();
      rRect = Rview->rect();
      if(loadCheck) {
        ResizeEdits();
      }
      update();
//  Lview->setFocus();
   }
}

/*goes to last set bookmark*/
bool Gutenbrowser::Bookmark()
{
    config->setGroup( "Bookmarks" );
#if defined(_WS_WIN_)
    file_name = config->readEntry("File Name", "C:/.gutenbrowser/COPYING");
#endif //*DOH*
#if defined(_WS_X11_)
    file_name = config->readEntry("File Name", "/usr/share/gutenbrowser/COPYING");
#endif

    QString s_pageNum = config->readEntry("Page Number", "0");
    QString s_Bmrkrow;
    s_Bmrkrow = config->readEntry("LineNumber","0");
    bool ok;
    int Bmrkrow=s_Bmrkrow.toInt( &ok, 10);
    i_pageNum=s_pageNum.toInt( &ok, 10);

    if( !file_name.contains("/")) {
        file_name = local_library + file_name;
    }
    getTitle(file_name);
    load(file_name);
    if( Bmrkrow >  Lview->topRow() ) {
//      //  if editview is smaller
        Lview->MultiLine_Ex::ScrollUp( Bmrkrow  -  Lview->topRow() );
        AdjustStatus();
    }
    else if( Bmrkrow <  Lview->topRow() ) {
//      // if editview is larger
        Lview->MultiLine_Ex::ScrollDown( Lview->topRow() - Bmrkrow );
        AdjustStatus();
    }
    ResizeEdits();
    return true;
}

void Gutenbrowser::setBookmark()
{
/*  bookMarksDlg* bookDlg;
    bookDlg = new  bookMarksDlg(this,"bookMarkDlg");
    if(bookDlg->exec() != 0)
    {
//    QMessageBox::message( "Note", "accepted");
//    QMessageBox::message( "Note", file_name );
}
*/
    if( file_name.contains(local_library) ) {
        QFileInfo f1( file_name);
        QString file = f1.fileName();
        file_name = file;
    }

    QString temp;
    temp.setNum(i_pageNum);
    config->setGroup( "Bookmarks" );
    config->writeEntry("File Name",file_name);
    config->writeEntry("Page Number",temp);

    int row =  Lview->topRow();// Lview->Top();
    QString numb;
    numb.setNum( row);
    config->writeEntry("LineNumber",numb);

    config->write();
}

/*
performs dictionary look ups on the web */
void Gutenbrowser::LookupBtn()
{

    QString text;
    if( Lview->hasSelectedText()) {
     Lview->copy();
    }
    else if( Rview->hasSelectedText()) {
     Rview->copy();
    }
    QClipboard *cb = QApplication::clipboard();
    text = cb->text();

    QString cmd; // using system(), until we have qprocess
    QString s_lookup = "http://www.m-w.com/cgi-bin/dictionary?" + text;

#if defined(_WS_X11_)
 if( brow == "Konq") {
     cmd = "konqueror "+s_lookup;
 }
 if ( brow == "Netscape") {
     QString str = QDir::homeDirPath() + "/.netscape/lock";
       //  struct stat *stat_p;
//
       //  if ( -1 !=  lstat (str, stat_p))  { // if theres a lock file
       //      cmd = "netscape -remote 'openURL( "+s_lookup+" )'";
       //  }
       //  else {
     cmd = "netscape "+s_lookup;
 }

 if( brow =="Lynx") {
     cmd = "xterm -fg black -bg white -e lynx "+s_lookup;
//    cmd = "lynx -source "+ s_lookup + " | cat >> ~/somefile.html";
 }
 if( brow == "Opera")  {
     cmd = "opera "+s_lookup;
 }
 if( brow == "Mozilla")  {
     cmd = "mozilla "+s_lookup;
 }
//// http://www.encyclopedia.com/home.html
// printf("Issuing the system command: "+cmd+"\n");

 system(cmd);
#endif

#if defined(_WS_WIN_)
 goGetit( s_lookup, true);
#endif

}

void Gutenbrowser::ClearEdit()
{
    Lview->setText("");
    Rview->setText("");
    loadCheck = false;
    status = ( tr("Gutenbrowser"));
    InfoBar->setText( "");
    setCaption( tr("Gutenbrowser"));
    i_pageNum = 0;
    statusBar->message( status);
}


bool Gutenbrowser::getTitle( const char *file )
{
    QString s_file;
    QString filer = file;
    if( filer.contains(local_library, TRUE))  {
        QFileInfo f(file);
        s_file =  f.fileName();
    } else {
        s_file = filer;
    }

    config->setGroup( "Files" );
    QString s_numofFiles = config->readEntry("NumberOfFiles", "0" );
    int  i_numofFiles = s_numofFiles.toInt();

    for (int i = 1; i <= i_numofFiles; i++) {
        QString temp;
        temp.setNum(i);
        QString ramble = config->readEntry(temp, "" );

        if( strcmp(ramble, s_file) == 0) {
            config->setGroup( "Titles" );
            title = config->readEntry(ramble, "");
        }
    }
    return true;
}

void Gutenbrowser::searchdone_slot()
{
 // if (!searchDlg)
 //   return;
 // searchDlg->hide();
//    Lview->setFocus();
      this->setFocus();
  last_search = 0;
  ResizeEdits();
}

/*
sets the status message */
bool Gutenbrowser::setStatus()
{
    QString s_pages;
    s_pages.setNum( pages);
    QString chNum;
    statusTop = status.left( status.find("  ", TRUE) );
    status.append(chNum.setNum(i_pageNum));
    status += " out of " + s_pages;
    if(loadCheck) {
        statusBar->message( status);
        InfoBar->setText( title);
        } else {
            }
    return true;
}

void Gutenbrowser::keyReleaseEvent( QKeyEvent *e)
{
    switch ( e->key() ) {

        case Key_M:
            Bookmark();
            break;
        case Key_D:
            DownloadIndex();
            break;
        case Key_L:
            LibraryBtn();
            break;
        case Key_O:
            OpenBtn();
            break;
        case Key_F:
            ForwardBtn();
            break;
        case Key_B:
            BackBtn();
            break;
        case Key_P:
            PrintBtn();
            break;
        case Key_S:
            SearchBtn();
            break;
        case Key_E:
            ByeBye();
            break;
        case Key_R:
            setBookmark();
            break;
        case Key_T:
            ChangeFont();
            break;
        case Key_C:
            ClearEdit();
            break;
        case Key_H:
            HelpBtn();
            break;
        case Key_K:
            LookupBtn();
            break;
        case Key_Down:
          if( !e->isAutoRepeat() )
          AdjustStatus();
            break;
        case Key_Up:
          if( !e->isAutoRepeat() )
            AdjustStatus();
            break;
        case Key_Home:
          BeginBtn();
          break;
        case Key_Right: // move splitter here
          moveSplitter(1);
          break;
        case Key_Left: // move splitter here
          moveSplitter(-1);
          break;
    };
}

void Gutenbrowser::keyPressEvent( QKeyEvent *e)
{
    switch ( e->key() ) {
        case Key_Next:
            ForwardBtn();
            break;
        case Key_Prior:
            BackBtn();
            break;
        case Key_Space:
            ForwardBtn();
            break;
        case Key_Down:
          Lview->MultiLine_Ex::ScrollUp( 1);
          Rview->MultiLine_Ex::ScrollUp( 1);
            break;
        case Key_Up:
          if( Lview->Top() != 0) {
            Lview->MultiLine_Ex::ScrollDown( 1);
            Rview->MultiLine_Ex::ScrollDown( 1);
          }
          break;
    }
}

void Gutenbrowser::resizeEvent( QResizeEvent *)
{
    if(  loadCheck == true) {
        ResizeEdits();
        AdjustStatus();
    }
}

/*
  handles the view when the window is resized*/
void Gutenbrowser::ResizeEdits()
{
    int rTopRow = Rview->topRow();
    int lLastRow = Lview->lastRow();
    if( lLastRow >  rTopRow ) {
        Rview->MultiLine_Ex::ScrollUp( lLastRow - rTopRow  );
    } else if( lLastRow < rTopRow ) {
        Rview->MultiLine_Ex::ScrollDown( rTopRow - lLastRow );
    }
}

/*
  adjusts the status bar to reflect new pages*/
void Gutenbrowser::AdjustStatus()
{
    int linesPerPage = Rview->lastRow() - Lview->topRow();
    pages = ((Lview->numLines() / Lview->editSize() ) / 2 ) +1;
    i_pageNum = (( Lview->topRow() - 1) / linesPerPage) +1;
    if( i_pageNum < 1)
        i_pageNum = 1;
    status = title +(tr("  :page "));
    setStatus();
    Rview->repaint( TRUE);
}

void Gutenbrowser::doOptions()
{
    optionsDialog* optDlg;
    optDlg = new optionsDialog( this,"Options_Dlg", true);
    if( optDlg->exec() !=0) {
        brow=optDlg->browserName;
       toggleButtonIcons( optDlg->useIcon);
        ftp_host= optDlg->ftp_host;
        ftp_base_dir= optDlg->ftp_base_dir;
        brow=optDlg->browserName;
        if(optDlg->styleChanged)
        setStyle( optDlg->styleInt);
        if(optDlg->b_qExit==TRUE)
            b_queryExit=TRUE;
        else
            b_queryExit=FALSE;
        }


    if(b_queryExit)
        qDebug("Please query before leaving the library.");
    else
        qDebug("Please DO NOT query before leaving the library.");
   // if(optDlg)
     //   delete optDlg;
//
}
/*
 Sets the correct title/name/filename
 of the etext, in the config file*/
bool Gutenbrowser::setTitle()
{
    if( file_name.contains( local_library)) {
        QFileInfo f( file_name);
        QString s_file =  f.fileName();
        file_name = s_file;
    }

    int test = 0;
    config->setGroup( "Files" );
    QString s_numofFiles = config->readEntry("NumberOfFiles", "0" );
    int  i_numofFiles = s_numofFiles.toInt();

    for (int i = 1; i <= i_numofFiles; i++) {
        QString temp;
        temp.setNum(i);
        QString ramble = config->readEntry(temp, "" );

        if( strcmp(ramble, file_name) == 0) {
            test = 1;
        }
    }
    if (test == 0) {
        config->writeEntry("NumberOfFiles",i_numofFiles +1 );
        QString interger;
        interger.setNum( i_numofFiles +1);
        config->writeEntry(interger, file_name);

        config->setGroup( "Titles" );
        config->writeEntry(file_name,listItemTitle);
    }
    test = 0;
    config->write();
    return true;
}

/*
  This scrolls the etext past the intro stuff,
   directly to the start of the book. */
void Gutenbrowser::BeginBtn()
{
    i_pageNum = 1;
    status= title + ( tr("  :page "));
    QString s_pattern="*END*";
//    int i;//, col =0;
    int line=0;
    int pos, i;
    int i_topRow = Lview->topRow();
    QString LeftText;// = Lview->text();
    for(i=line; i < Lview->numLines(); i++) {
        LeftText = Lview->textLine(i);
        pos = LeftText.find( s_pattern, 0 , TRUE);
        if( pos != -1) {
            if( i > i_topRow ) {
                Lview->MultiLine_Ex::ScrollUp( (i-i_topRow)+1);
            } else {
               Lview->MultiLine_Ex::ScrollDown( (i_topRow-i)-1);
            }
        }
    }
    ResizeEdits();
    AdjustStatus();
}

/*Calls new fangled network dialog */
void Gutenbrowser::OnNetworkDialog( QString networkUrl, QString output)
{
    NetworkDialog *NetworkDlg;
    if( networkUrl.length() < 4 ) networkUrl= "http://sailor.gutenberg.org/mirror.sites.html";
    NetworkDlg = new NetworkDialog( this,"Network Protocol Dialog", TRUE, 0, networkUrl, output);
    if( NetworkDlg->exec() != 0 ) {
    }
    if(NetworkDlg)
        delete NetworkDlg;
}

void Gutenbrowser::donateGutenberg() {
    int exit=QMessageBox::information(this, "Donate", "http://www.gutenberg.org", QMessageBox::Ok, QMessageBox::Cancel);

    if (exit==1) {
#if defined(_WS_WIN_)
    QString m_Player,vip, url;
    url="http//www.gutenberg.org";
    m_Player=local_library+"llkcrbrowser.exe";
    if( url.find("http://", 0, false) )
      url=url.right( url.length()-6);
    vip=" /"+url;
    m_Player+=vip;
   // QMessageBox::message("Note", url);
    WinExec( m_Player, SW_SHOWNORMAL);
#endif
    } else {
    };
}

void Gutenbrowser::donateByteMonkie() {
    // hmmmmmm this'll might cost me some noodles, eh?
//    int exit=QMessageBox::information(this, "Donate", "the ByteMonkey\nljp@llornkcor.com", QMessageBox::Ok, QMessageBox::Cancel);
// -heh-
    int exit=QMessageBox::information(this, "Donate", "Trolltech\nhttp://www.trolltech.com", QMessageBox::Ok, QMessageBox::Cancel);

    if (exit==1) {

#if defined(_WS_WIN_)
    QString m_Player,vip, url;
    url="http//www.trolltech.com";
    m_Player=local_library+"llkcrbrowser.exe";
    if( url.find("http://", 0, false) )
      url=url.right( url.length()-7);
    vip=" /"+url;
    m_Player+=vip;
    WinExec( m_Player, SW_SHOWNORMAL);
#endif
        } else {
    };
}

void Gutenbrowser::moveSplitter(  int pos )
{
//int jargon;
//typedef QValueList<jargon> splitterPos;
//
if (pos < 0 ) {//is negative, so we want to move the splitter left
 QValueList<int> jargon;
 QValueList<int> jargon2;
jargon= splitter->sizes();
//int count= jargon.count();
QString cheese;
//  QValueListIterator::Iterator it;

//    jargon2.append( end );
//    jargon2.append( begin);
//
//    for(int i=0; i<2;i++) {
//
//for( it = jargon.begin(); it != jargon.end(); ++it ) {
//   cheese.sprintf( "%d\n",  jargon.begin() );
//             QMessageBox::message("Note", cheese);
//             cheese.sprintf( "%d\n",  jargon.end() );
//             QMessageBox::message("Note", cheese);
//           QSplitter::moveSplitter(120,splitter->idAfter(Lview));
//           //splitter.idAfter(QWidget*w)
           //                       Lview
//}
// splitter->setSizes( jargon2);
   }
//int jcount = jargon.count();


//uintQValueList::count()

//   }
/// else { // is positive, so we want to move the splitter right

/*
   _itemListWidth=_itemList->width();
    QValueList<int> sizes;
    sizes.append(_mainWidget->width());
    _itemList->hide();
    move(x()+_itemListWidth,y());
    resize(width()-_itemListWidth, height());
    _splitter->setSizes(sizes);
 */
//        }

}


void Gutenbrowser::writeConfig()
{
   config->read();
    config->setGroup( "Geometry" );
    QString s;
    QString globalPosition;
    QPoint point;
    point=mapToGlobal(QPoint(0,0) );
    int posiX, posiY;
    posiX=point.x();
    posiY=point.y();
    globalPosition.sprintf("%i,%i", posiX, posiY);

    QRect frameRect;
    frameRect = geometry();
    s.sprintf("%i,%i", frameRect.width(), frameRect.height());
    config->writeEntry("Frame", s);
    config->writeEntry("Position", globalPosition);
//
    if( useIcons==TRUE)
        config->writeEntry("Icons", "TRUE");
    else
        config->writeEntry("Icons", "FALSE");

    config->setGroup( "FTPsite" );  // ftp server config
    if(ftp_host.find( "SiteName",0,true) !=-1) {
        ftp_host="sailor.gutenberg.org";
        ftp_base_dir= "/pub/gutenberg";
    }

    config->writeEntry("SiteName", ftp_host);
    config->writeEntry("base", ftp_base_dir);

    config->setGroup( "Browser" );

    if(brow.length() > 2)
    config->writeEntry("Preferred", brow);


//  config->setGroup( "Proxy" ); // use ftp/http config
//  if( config->readEntry("IsChecked", "FALSE") == "TRUE")
//    {
//    Http_CheckBox->setChecked( TRUE);
//    Ftp_CheckBox->setChecked( FALSE);
//    }
//    else
//    {
//    Http_CheckBox->setChecked( FALSE);
//    Ftp_CheckBox->setChecked( TRUE);
//    }



    /////////// fonts
    weight= Lview->fontInfo().weight();
    italic = Lview->fontInfo().italic();
    bold=Lview->fontInfo().bold();
    pointSize= Lview->fontInfo().pointSize();
    fontStr=Lview->fontInfo().family();

    if(italic == true)
      italicStr="TRUE";
    else
      italicStr="FALSE";
    if(bold == true)
      boldStr="TRUE";
    else
      boldStr="FALSE";

    pointSizeStr.setNum( pointSize);
    weightStr.setNum( weight);
    config->setGroup( "Font" );
    config->writeEntry("Family", fontStr );
    config->writeEntry("Size", pointSizeStr );
    config->writeEntry("Weight", weightStr );
    config->writeEntry("Italic", italicStr );
    config->writeEntry("Bold", boldStr );

    QString temp;
    temp.setNum(styleI, 10);
    config->setGroup( "StyleIze" );
    config->writeEntry( "Style", temp);

//    config->setGroup("General");
    //QString qExit;
//
//    if( b_queryExit) {
//        config->writeEntry("queryEntry","TRUE");
//        } else {
//        config->writeEntry("queryEntry","FALSE");
//            }

    config->write();
}

void Gutenbrowser::annotations() {
QMessageBox::message("Note","hi annotate");
lastBmkButton->setDown(FALSE);
}
