/*
 * score.c
 *
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 *
 */

#include <stdio.h>
#include "rogue.h"
#include "dun.h"

extern char login_name[];
extern char *m_names[];
extern short max_level;
extern boolean score_only, show_skull;
extern char *byebye_string, *nick_name;

char *killed_by_setbuf(monster, other)
object *monster;
short other;
{
	char fmt[MSGLEN];
	static char buf[MSGLEN];
	if (other != QUIT) {
		rogue.gold = ((rogue.gold * 9) / 10);
	}

	if (other) {
		switch(other) {
		case HYPOTHERMIA:
			(void) strcpy(fmt, "died of hypothermia with ${0} gold");
			break;
		case STARVATION:
			(void) strcpy(fmt, "died of starvation with ${0} gold");
			break;
		case POISON_DART:
			(void) strcpy(fmt, "killed by a dart with ${0} gold");
			break;
		case QUIT:
			(void) strcpy(fmt, "quit with ${0} gold");
			break;
		}
		return format_str(buf, fmt, "diedof", 1, LNUMBER, 0, &rogue.gold);
	} 
	return format_str(buf, "Killed by a ${1} with ${0} gold", "killedby",
		2, LNUMBER, 0, &rogue.gold, MONSTER, monster->m_char - 'A',
		m_names[monster->m_char - 'A']);
}

win_unwear()
{
	unwield(rogue.weapon);		/* disarm and relax */
	unwear(rogue.armor);
	un_put_on(rogue.left_ring);
	un_put_on(rogue.right_ring);
	id_all();
}

char *score_str(m_char, other, level, amulet)
short m_char, other, level, amulet;
{
	short i;
	static char buf[MSGLEN], buf2[MSGLEN];
	
	if (other) {
		switch(other) {
		case HYPOTHERMIA:
			(void) strcpy(buf2, "died of hypothermia on level ${0}");
			break;
		case STARVATION:
			(void) strcpy(buf2, "died of starvation on level ${0}");
			break;
		case POISON_DART:
			(void) strcpy(buf2, "killed by a dart on level ${0}");
			break;
		case QUIT:
			(void) strcpy(buf2, "quit on level ${0}");
			break;
		case WIN:
			(void) strcpy(buf2, "a total winner (returned from level ${0})");
			break;
		}
		format_str(buf, buf2, "scdiedof", 1, SNUMBER, 0, &level);
	} else {
		format_str(buf, "killed by a ${1} on level ${0}", 
		    "sckilledby", 2, SNUMBER, 0, &level, MONSTER, m_char - 'A',
		    m_names[m_char - 'A']);
	}
	if ((other != WIN) && amulet) {
		APPEND(buf, transl(" with amulet"), MSGLEN);
	}
	return buf;
}

is_vowel(ch)
short ch;
{
	return( (ch == 'a') ||
		(ch == 'e') ||
		(ch == 'i') ||
		(ch == 'o') ||
		(ch == 'u') );
}

object *sell_pack(obj, name, value)
object *obj;
char *name;
int *value;
{
	obj = obj->next_object;
	if (!obj) return obj;

	if (obj->what_is != FOOD) {
		obj->identified = 1;
		*value = get_value(obj);
		rogue.gold += *value;
		get_desc(obj, name);
	} else name[0]=0;
	
	if (rogue.gold > MAX_GOLD) {
		rogue.gold = MAX_GOLD;
	}
	
	return obj;
}

get_value(obj)
object *obj;
{
	short wc;
	int val;

	wc = obj->which_kind;

	switch(obj->what_is) {
	case WEAPON:
		val = id_weapons[wc].value;
		if ((wc == ARROW) || (wc == DAGGER) || (wc == SHURIKEN) ||
			(wc == DART)) {
			val *= obj->quantity;
		}
		val += (obj->d_enchant * 85);
		val += (obj->hit_enchant * 85);
		break;
	case ARMOR:
		val = id_armors[wc].value;
		val += (obj->d_enchant * 75);
		if (obj->is_protected) {
			val += 200;
		}
		break;
	case WAND:
		val = id_wands[wc].value * (obj->o_class + 1);
		break;
	case SCROLL:
		val = id_scrolls[wc].value * obj->quantity;
		break;
	case POTION:
		val = id_potions[wc].value * obj->quantity;
		break;
	case AMULET:
		val = 5000;
		break;
        case RING:
	        val = id_rings[wc].value * (obj->o_class + 1);
                break;
	}
	if (val <= 0) {
		val = 10;
	}
	return(val);
}

id_all()
{
	short i;

	for (i = 0; i < SCROLLS; i++) {
		id_scrolls[i].id_status = IDENTIFIED;
	}
	for (i = 0; i < WEAPONS; i++) {
		id_weapons[i].id_status = IDENTIFIED;
	}
	for (i = 0; i < ARMORS; i++) {
		id_armors[i].id_status = IDENTIFIED;
	}
	for (i = 0; i < WANDS; i++) {
		id_wands[i].id_status = IDENTIFIED;
	}
	for (i = 0; i < POTIONS; i++) {
		id_potions[i].id_status = IDENTIFIED;
	}
}

name_cmp(s1, s2)
char *s1, *s2;
{
	short i = 0;
	int r;

	while(s1[i] != ':') {
		i++;
	}
	s1[i] = 0;
	r = strcmp(s1, s2);
	s1[i] = ':';
	return(r);
}

xxxx(buf, n)
char *buf;
short n;
{
	short i;
	unsigned char c;

	for (i = 0; i < n; i++) {

		/* It does not matter if accuracy is lost during this assignment */
		c = (unsigned char) xxx(0);

		buf[i] ^= c;
	}
}

long
xxx(st)
boolean st;
{
	static long f, s;
	long r;

	if (st) {
		f = 37;
		s = 7;
		return(0L);
	}
	r = ((f * s) + 9337) % 8887;
	f = s;
	s = r;
	return(r);
}

nickize(buf, score, n_name)
char *buf, *score, *n_name;
{
	short i = 15, j;

	if (!n_name[0]) {
		(void) strcpy(buf, score);
		return;
	}
	(void) strncpy(buf, score, 16);

	while (score[i] != ':') {
		i++;
	}

	(void) strcpy(buf+15, n_name);
	j = strlen(buf);

	while (score[i]) {
		buf[j++] = score[i++];
	}
	buf[j] = 0;
	buf[79] = 0;
}
