#include <kcmdlineargs.h>
#include <kmessagebox.h>
#include <kiconloader.h>
#include <qwhatsthis.h>
#include <kaboutdata.h>
#include <sys/param.h>
#include <ktoolbar.h>
#include <kmenubar.h>
#include <qkeycode.h>
#include <ktoolbar.h>
#include <kimageio.h>
#include <klocale.h>
#include <kconfig.h>
#include <unistd.h>
#include <stdio.h>
#include <kapp.h>
#include <krun.h>
#include "rogue/dun.h"
#include "khtmldlg.h"
#include "krogueqh.h"
#include "kmsgbar.h"
#include "kinvwnd.h"
#include "krogue.h"
#include "roguec.h"
#include "kropts.h"
#include "kgame.h"
#include "kcmdr.h"
#include "kdun.h"
/*
#include <unistd.h>
#include <fcntl.h>
*/
KRogueWnd *top;
KLocale *loc;
KMsgBar *msg;
KConfig *cfg;
KDun *dun;

int saved_uid, true_uid;

#define KDE_HOMEPAGE    "http://www.kde.org"
#define KROGUE_HOMEPAGE "http://ksi.ii.uj.edu.pl/krogue"
#define BUGS_EMAIL      "M.Zalewski@pegaz.if.uj.edu.pl"

#define FAILED {initFailed=true; return;}

KRogueWnd::KRogueWnd(void)
:KTMainWindow(NULL)
{
  int i;
  top=this;
  initFailed=false;
  for (i=0; i<20; i++) enab[i]=1;
  if (!(cmdr=new KCmdr())) FAILED;
  if (!(gam=new KGame(this))) FAILED;
  if (!(dunv=new KDunView(this))) FAILED;
  if (!(dun=new KDun(dunv->viewport()))) FAILED;
  setView(dunv, true);
  initMenuBar();
  initToolBar();
  initMsgBar();
  initStatusBar();
  dunv->addChild(dun);
  connect(cmdr, SIGNAL(noArmor()), SLOT(wearbt()));
  connect(cmdr, SIGNAL(wearsArmor()), SLOT(takeoffbt()));
  connect(cmdr, SIGNAL(noLRing()), SLOT(lputbt()));
  connect(cmdr, SIGNAL(noRRing()), SLOT(rputbt()));
  connect(cmdr, SIGNAL(putLRing(struct obj *)), SLOT(lrembt(struct obj *)));
  connect(cmdr, SIGNAL(putRRing(struct obj *)), SLOT(rrembt(struct obj *)));
  connect(cmdr, SIGNAL(onStairs(bool)), SLOT(stairbt(bool)));
  connect(cmdr, SIGNAL(isRunning(bool)), SLOT(setRunning(bool)));
  connect(cmdr, SIGNAL(newlevel()), dun, SLOT(initLevel()));
  connect(cmdr, SIGNAL(newlevel()), SLOT(newTitle()));
  connect(cmdr, SIGNAL(enableButtons(bool)), SLOT(enableButtons(bool)));
  connect(cmdr, SIGNAL(wizard()), SLOT(wizard()));
  connect(cmdr, SIGNAL(quit()), dun, SLOT(quit()));
  connect(cmdr, SIGNAL(roguePosChanged(int, int)), dunv, SLOT(makeCellVisible(int, int)));
  connect(cmdr, SIGNAL(help()), SLOT(appHelpActivated()));
  connect(kapp, SIGNAL(aboutToQuit()), SLOT(writeCfg()));
  connect(gam, SIGNAL(newNick()), SLOT(newTitle()));
}

void KRogueWnd::initGame()
{
  char fn[PATH_MAX]="";
  if (initFailed) return;
  if (!dun->initDungeon(NULL)) FAILED;
  if (kapp->argc()>=2)
  {
    qstrncpy(fn, kapp->argv()[1], PATH_MAX);
    if (!dun->restoreFile(fn))
    {
      exit(0);
      return;
    }
  }
  dun->setFocus();
  if (fn[0]) restoresg=1; else restoresg=0;
  newTitle();
}

void KRogueWnd::initMenuBar()
{
  QPopupMenu *submenu;
  if (!(mb=new KMenuBar(this))) FAILED;
  if (!(submenu=new QPopupMenu)) FAILED;
  submenu->insertItem(i18n("&Restore..."), dun, SLOT(load()), 0, 1);
  submenu->insertItem(i18n("&Save..."), gam, SLOT(save()), CTRL+Key_S, 2);
  submenu->insertSeparator();
  submenu->insertItem(i18n("&Create character file..."), dun, SLOT(charfile()));
  submenu->insertSeparator();
  submenu->insertItem(i18n("&High scores..."), dun, SLOT(highscores()));
  submenu->insertItem(i18n("&Your high scores..."), dun, SLOT(uhighscores()));
  submenu->insertSeparator();
  submenu->insertItem(i18n("&Quit"), dun, SLOT(quit()), CTRL+Key_Q);
  mb->insertItem(i18n("&Game"), submenu);
  if (!(submenu=new QPopupMenu)) FAILED;
  submenu->insertItem(i18n("&Inventory\ti"), cmdr, SLOT(showinv()));
  submenu->insertItem(i18n("&Call an item\tc"), cmdr, SLOT(call()));
  submenu->insertSeparator();
  submenu->insertItem(i18n("&Eat\te"), cmdr, SLOT(eat()));
  submenu->insertItem(i18n("&Quaff a potion\tq"), cmdr, SLOT(quaff()));
  submenu->insertItem(i18n("&Read a scroll\tr"), cmdr, SLOT(read()));
  submenu->insertItem(i18n("&Zap a wand\tz"), cmdr, SLOT(zap()));
  submenu->insertItem(i18n("&Wield a weapon\tw"), cmdr, SLOT(wield()));
  submenu->insertItem(i18n("&Throw an item\tt"), cmdr, SLOT(throwsl()));
  submenu->insertItem(i18n("&Drop an item\td"), cmdr, SLOT(drop()));
  submenu->insertItem(i18n("P&ut on a ring\tShift+P"), cmdr, SLOT(puton()));
  submenu->insertItem(i18n("Re&move a ring\tShift+R"), cmdr, SLOT(remove()));
  submenu->insertItem(i18n("We&ar an armor\tShift+W"), cmdr, SLOT(wear()));
  submenu->insertItem(i18n("Ta&ke off an armor\tShift+T"), cmdr, SLOT(takeoff()));
  mb->insertItem(i18n("&Inventory"), submenu, 3);
  if (!(submenu=new QPopupMenu)) FAILED;
  submenu->insertItem(i18n("&Downstair\t>"), cmdr, SLOT(downstair()));
  submenu->insertItem(i18n("&Upstair\t<"), cmdr, SLOT(upstair()));
  submenu->insertItem(i18n("&Identify trap\t^"), cmdr, SLOT(idtrap()));
  submenu->insertSeparator();
  submenu->insertItem(i18n("&Fast moving\tCtrl"), cmdr, SLOT(run()), 0, 10);
  submenu->insertSeparator();
  submenu->insertItem(i18n("&Normal window size"), this, SLOT(normalSize()));
  submenu->insertSeparator();
  submenu->insertItem(i18n("&Options..."), this, SLOT(options()), Key_F9);
  mb->insertItem(i18n("&Commands"), submenu, 4);
  submenu=helpMenu(i18n("KRogue %0 - rogue for KDE\n\n"
    "Based on rogue-clone: Version II that can be found at\n"
    "ftp://metalab.unc.edu/pub/Linux/games/dungeon/rogue985.tar.Z\n\n"
    "Ported to KDE by Mikolaj Zalewski <M.Zalewski@pegaz.if.uj.edu.pl>").
    arg(KR_VERSION));
#define APPICON(x) SmallIcon(x)
  submenu->insertItem(APPICON("www"), i18n("KRogue home page..."),
    this, SLOT(krHomepage()), 0, 101, 5);
  submenu->insertSeparator(7);
  submenu->insertItem(APPICON("www"), i18n("KDE home page..."),
    this, SLOT(kdeHomepage()), 0, 102, 8);
#undef APPICON
  mb->insertItem(i18n("&Help"), submenu);
  setMenu(mb);
  connect(mb, SIGNAL(highlighted(int)), SLOT(statusHint(int)));
}

void KRogueWnd::initToolBar()
{
  tl=new KToolBar(this);
  KInvPopup *eat=new KInvPopup(FOOD),
            *quaff=new KInvPopup(POTION),
            *read=new KInvPopup(SCROLL),
	    *zap=new KInvPopup(WAND),
	    *wield=new KInvPopup(WEAPON),
	    *throwbt=new KInvPopup(WEAPON|WAND),
	    *drop=new KInvPopup(ALL_OBJECTS);
  wear=new KInvPopup(ARMOR);
  lrings=new KInvPopup(RING, ON_LEFT_HAND|ON_RIGHT_HAND);
  rrings=new KInvPopup(RING, ON_LEFT_HAND|ON_RIGHT_HAND);
  if (!tl || !eat || !quaff || !read || !zap || !wield || 
    !throwbt || !drop || !wear || !lrings || !rrings) FAILED;
  connect(eat, SIGNAL(activated(int)), cmdr, SLOT(eat(int)));
  connect(quaff, SIGNAL(activated(int)), cmdr, SLOT(quaff(int)));
  connect(read, SIGNAL(activated(int)), cmdr, SLOT(read(int)));
  connect(wield, SIGNAL(activated(int)), cmdr, SLOT(wield(int)));
  connect(zap, SIGNAL(activated(int)), cmdr, SLOT(zap(int)));
  connect(throwbt, SIGNAL(activated(int)), cmdr, SLOT(throwsl(int)));
  connect(drop, SIGNAL(activated(int)), cmdr, SLOT(drop(int)));
  connect(wear, SIGNAL(activated(int)), cmdr, SLOT(wear(int)));
  connect(lrings, SIGNAL(activated(int)), cmdr, SLOT(putonl(int)));
  connect(rrings, SIGNAL(activated(int)), cmdr, SLOT(putonr(int)));
  tl->insertButton(BarIcon("fileopen"), 2, SIGNAL(clicked()),
      dun, SLOT(load()), true, i18n("Restore"));
  tl->insertButton(BarIcon("filesave"), 3, SIGNAL(clicked()),
      gam, SLOT(save()), true, i18n("Save"));
  tl->insertSeparator();
  tl->insertButton(BarIcon("invent"), 18, SIGNAL(clicked()),
      cmdr, SLOT(showinv()), true, i18n("Inventory"));
  tl->insertButton(BarIcon("eat"), 4, eat, true, i18n("Eat"));
  tl->insertButton(BarIcon("quaff"), 5, quaff, true, i18n("Quaff"));
  tl->insertButton(BarIcon("read"), 6, read, true, i18n("Read"));
  tl->insertButton(BarIcon("zap"), 7, zap, true, i18n("Zap"));
  tl->insertButton(BarIcon("wield"), 8, wield, true, i18n("Wield"));
  tl->insertButton(BarIcon("throw"), 9, throwbt, true, i18n("Throw"));
  tl->insertButton(BarIcon("drop"), 10, drop, true, i18n("Drop"));
  tl->insertSeparator();
  tl->insertButton(BarIcon("takeoff"), 11, SIGNAL(clicked()), cmdr,
      SLOT(takeoff()), true, i18n("Take off"));
  tl->insertButton(BarIcon("lputr"), 12, lrings, true, i18n("Put on ring"));
  tl->insertButton(BarIcon("rputr"), 13, rrings, true, i18n("Put on ring"));
  tl->insertSeparator();
  tl->insertButton(BarIcon("downstair"), 14, SIGNAL(clicked()), cmdr,
      SLOT(downstair()), true, i18n("Downstair"));
  tl->insertButton(BarIcon("upstair"), 15, SIGNAL(clicked()), cmdr,
      SLOT(upstair()), true, i18n("Upstair"));
  tl->insertButton(BarIcon("rest"), 16, SIGNAL(clicked()), cmdr,
      SLOT(restbt()), true, i18n("Rest"));
  tl->insertButton(BarIcon("kr_search"), 17, SIGNAL(clicked()), cmdr,
      SLOT(searchbt()), true, i18n("Search"));
  tl->insertSeparator();
  tl->insertButton(BarIcon("contexthelp"), 100, SIGNAL(clicked()), this,
      SLOT(whatsthis()), true, i18n("What's this?"));
  tl->setAutoRepeat(16, true);
  tl->setAutoRepeat(17, true);
  tlButtons=18;
  addToolBar(tl);
  krwtSetToolBar(tl);
}

void KRogueWnd::initMsgBar(void)
{
  if (!(msg=new KMsgBar(this))) FAILED;
  addToolBar(msg);
}

void KRogueWnd::initStatusBar(void)
{
  if (!(s=new KStatusBar(top))) FAILED;
  s->insertItem(statusStr(1, "MM"), 1, 1);
  s->insertItem(statusStr(2, "MMMMM"),2, 1);
  s->insertItem(statusStr(3, "MMM(MMM)"),3, 1);
  s->insertItem(statusStr(4, "MM(MM)"),4, 1);
  s->insertItem(statusStr(5, "MM"), 5, 1);
  s->insertItem(statusStr(6, "MM/MMMMM"), 6, 1);
  s->insertItem("MMMMMMMM", 7, 1);
  setStatusBar(s);
}

QString KRogueWnd::statusStr(int id, const char *str)
{
  QString tstr;
  switch (id)
  {
    case 1: tstr=i18n("Level: "); break;
    case 2: tstr=i18n("Gold: "); break;
    case 3: tstr=i18n("Hp: "); break;
    case 4: tstr=i18n("Str: "); break;
    case 5: tstr=i18n("Arm: "); break;
    case 6: tstr=i18n("Exp: "); break;
    default: tstr="???";
  }
  tstr+=str;
  return tstr;
}

void KRogueWnd::statusHint(int i)
{
  static int hint=0;
  int newhint=1;

  switch (i)
  {
    case 101:
      s->message(i18n("Visit ")+KROGUE_HOMEPAGE);
      break;
    case 102:
      s->message(i18n("Visit ")+KDE_HOMEPAGE);
      break;
    default:
      newhint=0;
      if (hint) s->clear();
  }

  hint=newhint;
}

void KRogueWnd::show()
{
  int x, y;

  cfg->setGroup("Window");
  dunv->setSize(cfg->readNumEntry("W", DCOLS*PIXMAP_X),
                cfg->readNumEntry("H", DROWS*PIXMAP_Y));
  resize(sizeHint());
  dunv->makeCellVisible(rogue.row, rogue.col);

  KTMainWindow::show();
  if (!kapp->isRestored())
  {
    cfg->setGroup("Window");
    x=cfg->readNumEntry("X", -1);
    y=cfg->readNumEntry("Y", -1);
    if (x!=-1 && y!=-1) move(x, y);
    readToolBar(tl, "Toolbar");
    readToolBar(msg, "Msgbar");
  }

  if (!restoresg)
  {
    KHTMLDlg intro(QSize(600, 330), top);
    intro.setVar("DUNGEONS_OF_DOOM", i18n("The Dungeons of Doom"));
    intro.setVar("PAR0", i18n(
      "You have just finished your years as a student at the local fighter's\n"
      "guild. After much practice and sweat you have finally completed your training\n"
      "and are ready to embark upon a perilous adventure. As a test of your\n"
      "skills, the local guildmasters have sent you into the Dungeons of  Doom. Your\n"
      "task is to return with the Amulet of Yendor. Your reward for the completion\n"
      "of this task will be a full membership in the local guild.  In addition, you\n"
      "are allowed to keep all the loot you bring back from the dungeons.\n"));
    intro.setVar("PAR1", i18n(
      "In preparation for your journey, you are given an enchanted mace, a bow, and a\n"
      "quiver of arrows taken from a dragon's hoard in the far off Dark Mountains.\n"
      "You are  also outfitted with elf-crafted armor and given enough food to reach\n"
      "the dungeons. You say goodbye to family and friends for what may be the last\n"
      "time and head up the road.\n"));
    intro.setVar("PAR2", i18n(
      "You set out on your way to the dungeons and after several days of uneventful\n"
      "travel, you see the ancient ruins that mark the entrance to the Dungeons of\n"
      "Doom. It is late at night, so you make camp at the entrance and spend the night\n"
      "sleeping under the open skies. In the morning you gather your weapons, put on\n"
      "your armor, eat what is almost your last food, and enter the dungeons.\n"));
    intro.loadFile("intro.qml");
    if (intro.loaded()) intro.exec();
  }
}

void KRogueWnd::whatsthis()
{
  QWhatsThis::enterWhatsThisMode();
}

void KRogueWnd::options()
{
  KROpts optdlg(this);
  optdlg.exec();
}

void KRogueWnd::wizard()
{
  QString str;
  if (::wizard) wizardize(NULL);
    else
    {
      KStrDlg strdlg(i18n("&Wizard's password:"), true, top);
      strdlg.exec();
      str=strdlg.text();
      if (strdlg.result()!=QDialog::Rejected && !str.isNull() && !str.isEmpty())
        wizardize(str.utf8());
    }
  if (::wizard) top->mb->setAccel(0, 2);
    else top->mb->setAccel(CTRL+Key_S, 2);
}

void KRogueWnd::kdeHomepage()
{
  new KRun(KDE_HOMEPAGE);
}

void KRogueWnd::krHomepage()
{
  new KRun(KROGUE_HOMEPAGE);
}

void KRogueWnd::writeCfg()
{
  cfg->setGroup("Window");
  cfg->writeEntry("X", geometry().x());
  cfg->writeEntry("Y", geometry().y());
  dunv->writeCfg(cfg);
  writeToolBar(tl, "Toolbar");
  writeToolBar(msg, "Msgbar");
}

void KRogueWnd::closeEvent(QCloseEvent *e)
{
  KTMainWindow::closeEvent(e);
  if (e->isAccepted()) writeCfg();
}

void KRogueWnd::writeToolBar(KToolBar *tl, const char *name)
{
  char str[200];
  snprintf(str, 200, "%d,%d,%d", (int)(tl->barPos()),
    tl->x(), tl->y());
  cfg->writeEntry(name, str);
}

void KRogueWnd::readToolBar(KToolBar *tl, const char *name)
{
  KToolBar::BarPosition p;
  int x, y;
  QString str=cfg->readEntry(name, "0,0,0");
  sscanf(str.latin1(), "%d,%d,%d", (int *)&p, &x, &y);
  tl->setBarPos(p);
  if (p==KToolBar::Floating)
  {
    tl->move(x, y);
    tl->show();
  }
}

void KRogueWnd::enableButtons(bool enabled)
{
  int i;
  for (i=2; i<=tlButtons; i++)
    if (!cmdr->readOnly() || (i!=2 && i!=18))
      if (enab[i]) tl->setItemEnabled(i, enabled);
  for (i=(cmdr->readOnly()?2:1); i<=4; i++)
    if (enab[i]) mb->setItemEnabled(i, enabled);
}

bool KRogueWnd::queryClose()
{
  if (!msg->willQuit) dun->quit(false);
  return msg->willQuit;
}

void KRogueWnd::normalSize()
{
  dunv->setSize();
  resize(sizeHint());
}

void KRogueWnd::printStats(int t)
{
  char str[20];
  if (msg->willQuit) return;
  if (t&STAT_LEVEL)
  {
    snprintf(str, 20, "%d", gam->level());
    s->changeItem(statusStr(1, str), 1);
  }
  if (t&STAT_GOLD)
  {
    snprintf(str, 20, "%ld", gam->rogueGold());
    s->changeItem(statusStr(2, str), 2);
  }
  if (t&STAT_HP)
  {
    snprintf(str, 20, "%d(%d)", gam->rogueHpCur(), gam->rogueHpMax());
    s->changeItem(statusStr(3, str), 3);
  }
  if (t&STAT_STRENGTH)
  {
    snprintf(str, 20, "%d(%d)", gam->rogueStrCur(), gam->rogueStrMax());
    s->changeItem(statusStr(4, str), 4);
  }
  if (t&STAT_ARMOR)
  {

    snprintf(str, 20, "%d", gam->rogueArmorClass());
    s->changeItem(statusStr(5, str), 5);
  }
  if (t&STAT_EXP)
  {
    snprintf(str, 20, "%d/%ld", gam->rogueExp(), gam->rogueExpPoints());
    s->changeItem(statusStr(6, str), 6);
  }
  if (t&STAT_HUNGER)
    if (gam->hungerStr())
      s->changeItem(i18n(gam->hungerStr()), 7);
      else s->changeItem("", 7);
}

void KRogueWnd::newTitle()
{
  char title[MSGLEN];
  short level=gam->level();
  format_str(title, "${1} on level ${0} - Rogue", "caption", 2, SNUMBER, 0, &level,
    STRING, 0, gam->rogueNameUtf8());
  setPlainCaption(QString::fromUtf8(title));
}

void KRogueWnd::takeoffbt()
{
  krwtRemoveTl(tl, 11);
  tl->removeItem(11);
  tl->insertButton(BarIcon("takeoff"), 11, SIGNAL(clicked()), cmdr,
     SLOT(takeoff()), true, i18n("Take off"), 12);
  krwtSetTlTakeOff(tl);
}

void KRogueWnd::wearbt()
{
  krwtRemoveTl(tl, 11);
  tl->removeItem(11);
  tl->insertButton(BarIcon("wear"), 11, wear, true, i18n("Wear"), 12);
  krwtSetTlWear(tl);
}

void KRogueWnd::lputbt()
{
  krwtRemoveTl(tl, 12);
  tl->removeItem(12);
  tl->insertButton(BarIcon("lputr"), 12, lrings, true, i18n("Put on ring"), 13);
  krwtSetTlLPutOn(tl);
}

void KRogueWnd::rputbt()
{
  krwtRemoveTl(tl, 13);
  tl->removeItem(13);
  tl->insertButton(BarIcon("rputr"), 13, rrings, true, i18n("Put on ring"), 14);
  krwtSetTlRPutOn(tl);
}

void KRogueWnd::lrembt(struct obj *obj)
{
  char name[MSGLEN];
  get_desc(obj, name);
  krwtRemoveTl(tl, 12);
  tl->removeItem(12);
  tl->insertButton(BarIcon("lremr"), 12, SIGNAL(clicked()), cmdr,
    SLOT(lremr()), true, QString::fromUtf8(name), 13);
  krwtSetTlLRemove(tl);
}

void KRogueWnd::rrembt(struct obj *obj)
{
  char name[MSGLEN];
  get_desc(obj, name);
  krwtRemoveTl(tl, 13);
  tl->removeItem(13);
  tl->insertButton(BarIcon("rremr"), 13, SIGNAL(clicked()), cmdr,
    SLOT(rremr()), true, QString::fromUtf8(name), 14);
  krwtSetTlRRemove(tl);
}

void KRogueWnd::stairbt(bool e)
{
  tl->setItemEnabled(14, e); enab[14]=e;
  tl->setItemEnabled(15, e); enab[15]=e;
}

void KRogueWnd::setRunning(bool e)
{
  mb->setItemChecked(10, e);
}

void KRogueWnd::saveProperties(KConfig *cfg)
{
  KTMainWindow::saveProperties(cfg);
  dun->saveProperties(cfg);
  msg->saveProperties(cfg);
  cmdr->saveProperties(cfg);
}

void KRogueWnd::readProperties(KConfig *cfg)
{
  KTMainWindow::readProperties(cfg);
  msg->readProperties(cfg);
  dun->readProperties(cfg);
  cmdr->readProperties(cfg);
  dun->setFocus();
  newTitle();
  restoresg=1;
}

int main(int argc, char **argv)
{
  int ret;
/*  
  int fh=open("/tmp/krogue.out", O_RDWR|O_APPEND|O_CREAT, 0666);
  close(1);
  dup2(fh, 1);
*/
  saved_uid=geteuid();
  setuid(true_uid=getuid());

  KAboutData about("krogue", I18N_NOOP("KRogue"), KR_VERSION,
      I18N_NOOP("Rogue for KDE"), 0, NULL, KROGUE_HOMEPAGE,
      I18N_NOOP("Rogue for KDE"), BUGS_EMAIL);
  KCmdLineArgs::init(argc, argv, &about);
  KApplication a(argc, argv);
  KImageIO::registerFormats();
  loc=KGlobal::locale();
  cfg=KGlobal::config();
  top=new KRogueWnd;
  if (a.isRestored()) top->restore(1);
    else top->initGame();
  if (!top || top->initFailed)
  {
    KMessageBox::sorry(NULL, i18n("Couldn't start KRogue"), i18n("Rogue"));
    return 1;
  }
  if (top->restoresg==-1) return 0;
  if (!a.isRestored()) top->show();
  a.setMainWidget(top);
  krwtSetStatusBar(top->s);
  cfg->setGroup("Settings");
  ret=a.exec();
  cfg->setGroup("Settings");
  cmdr->writeCfg(cfg);
  return ret;
}
