#ifndef KHTMLDLG_H
#define KHTMLDLG_H
#include <qasciidict.h>
#include <qdialog.h>
#include <qstack.h>

class QSimpleRichText;
class QBrush;
class QFile;

class KQMLWidget:public QWidget
{
  Q_OBJECT;
public:
  KQMLWidget(bool fullsize, QWidget *parent, const char *name=NULL);
  virtual ~KQMLWidget();
  void setText(const QString &str);
  void resizeParent();
  void setPixmap(const QPixmap &);
  int contentsHeight();
signals:
  void urlClicked(const QString &str);
protected:
  void setUrlCursor(bool c);
  void paintEvent(QPaintEvent *p);
  void mouseMoveEvent(QMouseEvent *e);
  void mousePressEvent(QMouseEvent *e);
  void mouseReleaseEvent(QMouseEvent *e);
  void leaveEvent(QEvent *e);
  QSimpleRichText *qml;
  QString url;
  QBrush *brush;
  bool urlcursor;
};

class KHTMLDlg:public QDialog
{
  Q_OBJECT
public:
  KHTMLDlg(QSize size, QWidget *parent=NULL, char *name=NULL);
  ~KHTMLDlg();
  void setVar(const char *name, const QString &val);
  void loadFile(const char *filename);
  bool loaded(void);
signals:
  void action(const char *);
public slots:
  void urlSelected(const QString &);
protected:
  QChar nextch(QFile *in);
  QChar getch(QFile *in, bool prepl=true);
  void keyPressEvent(QKeyEvent *e);
  void addstr(const QString *str, const QString &param);
  bool readVar(QFile *, QString *, QString *);
  struct varitem
  {
    const QString *str;
    QString *param;
    int pos;
  } *current;
  QString qml_text;
  QStack<varitem> vstack;
  QAsciiDict<QString> *dict;
//  QList<QString> *list;
  KQMLWidget *qml;
  bool load;
};

#endif
