#include <qsimplerichtext.h>
#include <kmessagebox.h>
#include <qpainter.h>
#include <qkeycode.h>
#include <kstddirs.h>
#include <klocale.h>
#include <kcursor.h>
#include <kglobal.h>
#include <qaccel.h>
#include <qfile.h>
#include <kapp.h>
#include "khtmldlg.h"

KQMLWidget::KQMLWidget(bool fullsize, QWidget *wdg, const char *name)
:QWidget(wdg, name)
{
  qml=NULL;
  brush=NULL;
  urlcursor=false;
  if (fullsize) resize(wdg->size());
  setMouseTracking(true);
}

KQMLWidget::~KQMLWidget()
{
  if (urlcursor) kapp->restoreOverrideCursor();
  if (qml) delete qml;
}

void KQMLWidget::setText(const QString &str)
{
  if (qml) delete qml;
  qml=new QSimpleRichText(str, font());
  CHECK_PTR(qml);
  qml->setWidth(width());
}

void KQMLWidget::setPixmap(const QPixmap &pix)
{
  if (!pix.isNull())
  {
     if (!brush) brush=new QBrush;
     CHECK_PTR(brush);
     brush->setPixmap(pix);
  } else if (brush) delete brush;
}

int KQMLWidget::contentsHeight()
{
  if (!qml) return 0;
  return qml->height();
}

void KQMLWidget::resizeParent()
{
  if (!qml) return;
  QWidget *p=(QWidget *)parent();
  if (qml->height()>p->height() || qml->height()<0.9*p->height())
  {
    p->resize(qml->width(), qml->height());
    resize(qml->width(), qml->height());
  }
}

void KQMLWidget::setUrlCursor(bool c)
{
  if (c) kapp->setOverrideCursor(KCursor::handCursor());
    else kapp->restoreOverrideCursor();
  urlcursor=c;
}


void KQMLWidget::mouseMoveEvent(QMouseEvent *e)
{
  if (!qml) return;
  if (qml->anchorAt(e->pos()).isEmpty())
  {
    if (urlcursor) setUrlCursor(false);
  } else if (!urlcursor) setUrlCursor(true);
}

void KQMLWidget::mousePressEvent(QMouseEvent *e)
{
  url=qml->anchorAt(e->pos());
}

void KQMLWidget::mouseReleaseEvent(QMouseEvent *e)
{
  if (qml->anchorAt(e->pos())==url) emit urlClicked(url);
  url=QString::null;
}

void KQMLWidget::leaveEvent(QEvent *)
{
  if (urlcursor) setUrlCursor(false);
}

void KQMLWidget::paintEvent(QPaintEvent *e)
{
  if (!qml) return;
  QPainter p;
  p.begin(this);
  qml->draw(&p, 0, 0, e->region(), palette(), brush);
  p.end();
}

KHTMLDlg::KHTMLDlg(QSize size, QWidget *parent, char *name)
:QDialog(parent, name, true)
{
  resize(size);
  qml=new KQMLWidget(true, this);
  dict=new QAsciiDict<QString>(17, false);
  dict->setAutoDelete(true);
  setCaption(i18n("Rogue"));
  setVar("OK", i18n("OK"));
  setVar("KDE_WALLPAPERDIR", *KGlobal::dirs()->resourceDirs("wallpaper").begin());
  setVar("OK_BTN", locate("data", "krogue/pics/okbt.png"));
  connect(qml, SIGNAL(urlClicked(const QString &)),
    SLOT(urlSelected(const QString &)));
  load=0;
}

KHTMLDlg::~KHTMLDlg()
{
  if (dict) delete dict;
  if (qml) delete qml;
}

void KHTMLDlg::setVar(const char *name, const QString &val)
{
  QString *ptr=new QString(val);
  dict->insert(name, ptr);
}

QChar KHTMLDlg::nextch(QFile *in)
{
  QChar c;
  int i;
  while (current)
  {
    if ((c=(*current->str)[current->pos++])!=QChar::null) return c;
    if (current->param) delete current->param;
    delete current;
    current=vstack.pop(); 
  }
  return (((i=in->getch())!=EOF)?QChar(i):QChar::null);
}

void KHTMLDlg::addstr(const QString *str, const QString &param)
{
  varitem *newi=new varitem;
  newi->pos=0;
  newi->str=str;
  if (!param.isEmpty()) newi->param=new QString(param);
    else newi->param=NULL;
  vstack.push(current);
  current=newi;
}

QChar KHTMLDlg::getch(QFile *in, bool prepl)
{
  QChar c;
  do
  {
    c=nextch(in);
    if (prepl && c=='%' && current && current->param)
      addstr(current->param, NULL);
      else break;
  } while (1);
  return c;
}

bool KHTMLDlg::readVar(QFile *in, QString *varn, QString *param)
{
  QString varval, *var;
  QChar c;
  int l=1, st=0;
  *varn=QString::null;
  *param=QString::null;
  if ((c=getch(in))!='{')
  {
    *varn="$";
    return true;
  }
  var=varn;
  c=getch(in);
//  if (current)
//    printf("current: str=%s param=%s\n", current->str, current->param);
  while (c!=QChar::null)
  {
    if (c=='{') l++;
    if (c=='}')
      if ((--l)==0)
        break;
    if (c=='=' && st==0)
    {
      var=&varval;
      st=1;
    } else if (c==':' && (st==0 || st==3))
      {
        if (st==3)
	{
//	  char varn1[200], varn2[200], param2[1000], *vv;
	  QString varn1, varn2, param2, *vv;
	  readVar(in, &varn1, param);
	  readVar(in, &varn2, &param2);
	  if ((vv=(*dict)[varn->latin1()])!=NULL && *vv==varval) *varn=varn1;
	    else
	    {
	      *param=param2;
	      *varn=varn2;
	    }
	  st=4;
	} else
	{
          var=param;
          st=2;
	}
      } else if (c=='?' && st==0)
        {
	  if ((c=getch(in))==QChar::null) return false;
	  if (c != '=') return false;
	  var=&varval;
	  st=3;
	} else if (st!=4) (*var)+=c;
    c=getch(in, st!=1);
  }
  if (st==1)
  {
    setVar(varn->latin1(), varval);
    return false;
  }
  return true;
}

#include <qimage.h>

void KHTMLDlg::loadFile(const char *filename)
{
  QString param, varn, *val;
  QString fn=KGlobal::dirs()->findResource("appdata", QString("templates/")+filename);
  QFile *in=new QFile(fn);
  QChar c;
  CHECK_PTR(in);
  if (!in->open(IO_ReadOnly))
  {
    KMessageBox::error(kapp->mainWidget(), i18n("Can't load file: ")+filename,
        i18n("Rogue"));
    return;
  }
  current=NULL;
  while ((c=getch(in))!=QChar::null)
  {
    if (c=='$')
    {
      if (!readVar(in, &varn, &param)) continue;
//      printf("var=%s param=%s\n", varn, param);
      if (varn[0]=='$')
      {
        qml_text+='$';
	continue;
      }
      if ((val=(*dict)[varn.latin1()])!=NULL)
        addstr(val, param);
    } else qml_text+=c;
  }
  QString *background=(*dict)["BACKGROUND"];
  if (background && !background->isEmpty())
  {
    QString path=locate("wallpaper", *background);
    if (path.isEmpty()) path=locate("appdata", "krogue/pics/"+(*background));
    if (!path.isEmpty())
    {
      QPixmap pixmap(path);
      if (!pixmap.isNull()) qml->setPixmap(pixmap);
        else printf("loadPixmap - blad!\n");
    }
  }
  dict->clear();
  qml->setText(qml_text);
  qml->resizeParent();
  qml_text=QString::null;
  load=1;
  in->close();
}

void KHTMLDlg::urlSelected(const QString &url)
{
  if (url=="ok:") accept();
  if (url.left(7)=="action:")
  {
    kapp->restoreOverrideCursor();
    emit action((const char *)url[7].latin1()+7);
  }
}

bool KHTMLDlg::loaded()
{
  return load;
}

void KHTMLDlg::keyPressEvent(QKeyEvent *e)
{
  if (e->key()==Key_Enter || e->key()==Key_Return) accept();
    else QDialog::keyPressEvent(e);
}
