/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PICVIEW_H
#define PICVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>

#include <qpixmap.h>
#include <qevent.h>
#include <qrect.h>
#include <qsize.h>

// #define PICVIEW_WIDTH 150.0
// #define PICVIEW_HEIGHT 100.0
#define PICVIEW_WIDTH 132.0
#define PICVIEW_HEIGHT 99.0

class CPicview : public QWidget
{
	Q_OBJECT
 public:
	CPicview(QWidget *parent);
	virtual ~CPicview();

// Data
 public:

 protected:
// Returns the size of the pixmap this widget shows
	QSize pixmapSize() { return _pixmap->size(); }
// Size of the game pixmap
	QSize gamePixmapSize() { return _gamePixmapSize; }
// The pixmap the widget shows may be "padded" to fit into a 4:3 frame. This is the real size,
// relevant for translating mouse events etc.
        QSize realPixmapSize() { return _realPixmapSize; }
// Representation of the area visible in the game widget in this widget
	QRect vRect() { return QRect(_vRectTopLeft,_vRectSize); }
	QPoint translate2GamePixmap(QPoint p);
	QPoint translateFromGamePixmap(QPoint p);
	float scaleX() { return (float) realPixmapSize().width() / gamePixmapSize().width(); }
	float scaleY() { return (float) realPixmapSize().height() / gamePixmapSize().height(); }

	QPixmap* _pixmap;
	QPoint _vRectTopLeft;
	QSize _vRectSize;
	QSize _gamePixmapSize;
        QSize _realPixmapSize;

// Implementation
 public:
// Update entire pixmap
	void updatePixmap(QPixmap* p,QRect udRect);
// Just add one piece (quicker)
	void addPiece(QPixmap* piece,QPoint pos);

 protected:
	virtual void paintEvent(QPaintEvent* e);
	virtual void mouseMoveEvent(QMouseEvent* e);
	virtual void mousePressEvent(QMouseEvent* e);
	virtual void mouseReleaseEvent(QMouseEvent* e);

	virtual QPoint DPtoLP(QPoint p);

 public slots:
	void slotChangeViewPos(QPoint pos);

 signals:
        void sigChangeViewPos(QPoint pos);

};

#endif // PICVIEW_H
