/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "main.h"

#include "highscore.h"

#include <qfile.h>
#include <qlist.h>
#include <qlineedit.h>
#include <qinputdialog.h>
#include <qdir.h>

#include <klocale.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <malloc.h>

#define HIGHSCORE_FILE_NAME "/.kpuzzle-highscores"

CHighscoreDialog::CHighscoreDialog(QWidget* parent,int ys) :
  QDialog(parent,"Highscores",true)
{
	_yourScore = ys;

//	setFixedSize(200,200);
	setCaption(i18n("Highscores"));

	_list = new QList<CListElement>;
	_list->setAutoDelete(true);

        _vbox = new QVBoxLayout(this,30,20);

        _yourResult = NULL;
	if (_yourScore) {
		_yourResult = new QLabel(this);
                _vbox->addWidget(_yourResult);
//		_yourResult->move(10,10);
//		_yourResult->setFixedWidth(180);
	}

	_listBox = new QListBox(this);
//	_listBox->setGeometry(10,40,180,80);
	_listBox->setEnabled(false);
        _listBox->setMinimumSize(QSize(80,100));
        _vbox->addWidget(_listBox);

	_ok = new QPushButton(i18n("OK"),this);
//	_ok->move(50,150);
	_ok->setDefault(true);
        _vbox->addWidget(_ok);

	connect(_ok,SIGNAL(clicked()),this,SLOT(accept()));

        _vbox->activate();
}

void CHighscoreDialog::initializeDialog()
{
	char temp[40];
	char newEntry = readList();

	if (_yourScore) {
		if (newEntry != -1) {
			QString n = nameDialog();
			if (n != "") {
				_list->insert(newEntry,new CListElement(_yourScore,n));
				sprintf(temp,i18n("%1 %2").arg(_yourScore).arg((const char*) n));
			} else
				sprintf(temp,i18n("%1 - No Highscore entry").arg(_yourScore));
		} else {
			sprintf(temp,i18n("You are not in the Highscores."));
		}

		_yourResult->setText(temp);
	}

	QListIterator<CListElement> it(*_list);
	it.toFirst();
	while(it.current()) {
		char* s; s = (char*) malloc(30);
		memset(s,0,30);
 		sprintf(s,i18n("%1 %2").arg(it.current()->_score).arg((const char*) it.current()->_name));
		_listBox->insertItem(new QListBoxText(s));
		++it;
		free(s);
	}

}

CHighscoreDialog::~CHighscoreDialog()
{
	writeList();
	delete _ok;
	delete _listBox;
	if (_yourScore) delete _yourResult;
	delete _list;
}

QString CHighscoreDialog::nameDialog()
{
// 	QDialog dlg(NULL,"YourName",true);
// 	dlg.setCaption(i18n("Your Name"));
// 	dlg.setFixedSize(200,150);

// 	QLabel lab(i18n("Enter your name for highscore list"),&dlg);
// 	lab.setGeometry(20,20,160,20);

// 	QLineEdit ed(&dlg);
// 	ed.setGeometry(20,50,160,ed.height());

// 	QPushButton ok(&dlg,i18n("OK"));
// 	ok.setGeometry(70,110,60,30);
// 	ok.setText(i18n("OK"));
// 	ok.setDefault(true);

// 	ed.setFocus();

// 	connect(&ok,SIGNAL(clicked()),&dlg,SLOT(accept()));

// 	dlg.exec();

// 	return ed.text();

        bool OK;
        QString ret = QInputDialog::getText(i18n("Your name"),i18n("Enter your name for highscore list"),i18n("My name"),&OK);
        if (!OK) return QString::null;
        else return ret;
}

void CHighscoreDialog::getHighscoreFile(QString& name)
{
        name = QDir::homeDirPath();
// 	char t[50];
// 	strcpy(t,getenv("HOME"));
// 	strcat(t,"/.kpuzzle-highscores");
// 	strcpy(name,t);
}

char CHighscoreDialog::readList()
{
// Perhaps more elegant, but the older version works...
//         QString filename;
//         QFile hsfile;
//         QDataStream hsstream;

//         UINT_32 score;
//         QString player;
//         UINT_32 magic;
//         char counter = 0;

//         filename = QDir::homeDirPath() + HIGHSCORE_FILE_NAME;
//         hsfile.setName(filename);
//         debug("Filename = %s",(const char*) filename);
//         if (hsfile.open(IO_ReadOnly)) {
//                 hsstream.setDevice(hsfile);
//                 hsstream >> magic;
//                 if (magic != MAGIC_NR_HIGHSCORES) return 0;
//                 while (counter < MAX_HIGHSCORES - 1) {
//                         hsstream >> score;

	char name[50];
	QString filename;

	int score;
	int readChars;
	char place = -1; // Place of player in highscores
	char counter = 0;

	filename = QDir::homeDirPath() + HIGHSCORE_FILE_NAME;
        debug("Filename = %s",(const char*) filename);
	FILE* f = fopen(filename,"r");

	if (!f) return 0;

	do {
		readChars = fscanf(f,"%d %s",&score,name);
		if (readChars != 2) break;

		char* spc;
		while ((spc = strchr(name,'\\')) != NULL) {
			*spc = ' ';
		}

		_list->append(new CListElement(score,name));

		if (place == -1 && score < _yourScore) place = counter;

		counter++;
	} while (counter < MAX_HIGHSCORES - 1);

	if (place == -1 && counter < MAX_HIGHSCORES - 1) place = counter;

	fclose(f);

	return place;
}

bool CHighscoreDialog::writeList()
{
	QString filename;

	filename = QDir::homeDirPath() + HIGHSCORE_FILE_NAME;
        debug("Filename = %s",(const char*) filename);
	FILE* f = fopen(filename,"w");
	if (!f) return false;

	QListIterator<CListElement> it(*_list);
	for (it.toFirst();it.current();++it) {
		char name[21];
		strcpy(name,it.current()->_name);
		char* spc;
		while ((spc = strchr(name,' ')) != NULL) {
			*spc = '\\';
		}

		fprintf(f,"%i %s\n",it.current()->_score,name);
 	}

	fclose(f);
	return true;
}
