/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "main.h"

#include "piece.h"

#include "kpuzzleapp.h"

#include <qrect.h>
#include <qsize.h>
#include <qwmatrix.h>

QCache<QBitmap>* maskCache;
QPixmap* blackPixmap; // for deleting a piece pixmap's content quickly

CPiece::CPiece(KPuzzleApp* owner,QDataStream* f)
{
	_owner = owner;
        _timerNr = -1;
	load(f);
}

CPiece::CPiece(KPuzzleApp* owner,QPoint pos)
{
	_owner = owner;
	_pos = pos;
	_turn = -1; // because mingling is the duty of KPuzzleApp
	_time = 0;
	_faults = 0;
	_hasBeenSet = false;
        _isCurrent = false;
        _timerNr = -1;
}

CPiece::~CPiece()
{
        hidePiece();
}

QSize CPiece::pieceSize() const
{
        return _owner->pieceSize();
}

QSize CPiece::piecesCount() const
{
        return _owner->piecesCount();
}

int CPiece::displace() const
{
        return _owner->displace();
}

bool CPiece::mayKeepPiece() const
{
        return !_hasBeenSet &&
                (_owner->gameType() == PIECE_TIME_GAME ? _time <= _owner->scoreData()->_maxPieceTime : true) &&
		(_owner->gameType() == PIECE_FAULTS_GAME ? _faults <= _owner->scoreData()->_maxFaults : true);
}

bool CPiece::showPiece()
{
	if (_hasBeenSet) return false; // This piece is already at its place
	if ((_owner->gameData()->_gameType == PIECE_TIME_GAME && _time > _owner->scoreData()->_maxPieceTime) ||
	    (_owner->gameData()->_gameType == PIECE_FAULTS_GAME && _faults > _owner->scoreData()->_maxFaults))
		return false; // This piece may not be shown

        //	connect(this,SIGNAL(sigHidePiece(bool)),_owner,SLOT(slotHidePiece(bool)));

        //	connect(&CPiece::_pieceTimer,SIGNAL(timeout()),this,SLOT(slotTimeout()));
	//connect(&_pieceTimer,SIGNAL(timeout()),this,SLOT(slotTimeout()));

        debug("connecting timer");
//	connect(&pieceTimer,SIGNAL(timeout()),this,SLOT(slotTimeout()));
	if (_owner->gameData()->_gameType == PIECE_TIME_GAME || _owner->gameData()->_gameType == UNBEARABLE_GAME) {
                //		CPiece::_pieceTimer.start(1000);
//		__pieceTimer.start(1000);
                startTimer();
                debug("Timer has been started, gameType = %d",_owner->gameData()->_gameType);
        }

        _isCurrent = true;

	return true;
}

void CPiece::hidePiece()
{
	disconnect(this,SIGNAL(sigHidePiece(bool)),0,0);

// 	CPiece::_pieceTimer.stop();
// 	disconnect(&CPiece::_pieceTimer,SIGNAL(timeout()),this,SLOT(slotTimeout()));
//	_pieceTimer.stop();
        stopTimer();
//	disconnect(&pieceTimer,SIGNAL(timeout()),this,SLOT(slotTimeout()));

        _isCurrent = false;
}

bool CPiece::setPiece(QPoint p)
{
	if (p != pos() || turn()) { // Wrong place or direction
		if (_owner->gameType() == PIECE_FAULTS_GAME) _faults++;
                return false;
	}
	_hasBeenSet = true;
	//	emit sigHidePiece(false);
	return true;
}

void CPiece::getPixmap(QPixmap* p) const
{
	//	QPoint pos(_pieceList->at(_currentPieceNr)->pos);
	ASSERT(p->size() == blackPixmap->size());
        debug("%d:%d---backPixmap: %d:%d",p->size().width(),p->size().height(),blackPixmap->size().width(),blackPixmap->size().height());
        bitBlt(p,QPoint(0,0),blackPixmap,blackPixmap->rect());
	QPoint realPos;
	if (_owner->maskedPieces()) {
		// If we aren't at the left/top border, we copy displace() pixels more at the left/top side
		realPos = QPoint(pos().x() * pieceSize().width() - (pos().x() != 0 ? displace() : 0),
				 pos().y() * pieceSize().height() - (pos().y() != 0 ? displace() : 0));
		// If we aren't at a border at all, we need 2 * _displace
		QSize copySize(pieceSize().width() + displace() +
			       ((pos().x() && pos().x() < piecesCount().width() - 1) ? displace() : 0),
			       pieceSize().height() + displace() +
			       ((pos().y() && pos().y() < piecesCount().height() - 1) ? displace() : 0));
		// If we copy less, the destination position must be adjusted
		QPoint copyTo(pos().x() ? 0 : displace(),pos().y() ? 0 : displace());
 		bitBlt(p,copyTo,_owner->mainPixmap(),QRect(realPos,copySize),CopyROP,false);
		p->setMask(*getPieceMask());
	} else {
		realPos = QPoint(pos().x() * pieceSize().width(),pos().y() * pieceSize().height());
		bitBlt(p,QPoint(0,0),_owner->mainPixmap(),QRect(realPos,pieceSize()),CopyROP,false);
	}
}

QBitmap* CPiece::getPieceMask() const
{
	//	ASSERT(_maskCache);
	QBitmap* ret;
	QString resName;
	// Calculate variant (1,2) and type of the piece
	int variant = ((pos().x() + pos().y()) % 2 ? 2 : 1);
	resName.sprintf("piece%i",variant);
	if (!pos().x()) resName += "-l";
	if (pos().x() == piecesCount().width() - 1) resName += "-r";
	if (!pos().y()) resName += "-t";
	if (pos().y() == piecesCount().height() - 1) resName += "-b";
        //	if ((ret = maskCache().find(resName))) return ret;
	if ((ret = maskCache->find(resName))) return ret;
	QPixmap pxm(PICFILE(resName + ".bmp"));
	ret = new QBitmap;
	*ret = pxm;
	if (ret->width() != _owner->pieceSizeDisp().width() || ret->height() != _owner->pieceSizeDisp().height()) {
		QBitmap* temp = new QBitmap;
		QWMatrix mx;
		mx.scale((float) _owner->pieceSizeDisp().width() / ret->width(),
			 (float) _owner->pieceSizeDisp().height() / ret->height());
		*temp = ret->xForm(mx);
		delete ret;
		ret = temp;
	}
        //	CPiece::_maskCache.insert(resName,ret);
       	maskCache->insert(resName,ret);

	return ret;

}

void CPiece::getTurnedPixmap(QPixmap* p) const
{
	QWMatrix t((turn() & TURN_LR ? -1 : 1),0,0,(turn() & TURN_UD ? -1 : 1),0,0);
	*p = _owner->currentPiecePixmap()->xForm(t);
	///	return ret;
}

void CPiece::save(QDataStream* f) const
{
        *f << _pos;
        *f << _turn;
        *f << _time;
        *f << _faults;
        *f << (Q_INT8) _hasBeenSet;
        *f << (Q_INT8) _isCurrent;
}

void CPiece::load(QDataStream* f)
{
        *f >> _pos;
        *f >> _turn;
        *f >> _time;
        *f >> _faults;
        *f >> (Q_INT8&) _hasBeenSet;
        *f >> (Q_INT8&) _isCurrent;
}

void CPiece::timerEvent(QTimerEvent*)
{
        debug("slotTimeout called");
	ASSERT(_owner->gameData()->_gameType == PIECE_TIME_GAME || _owner->gameData()->_gameType == UNBEARABLE_GAME);

        debug("slotTimeout called");
	_time++;
        debug("_time = %d,maxpiecetime = %d",_time,_owner->scoreData()->_maxPieceTime);
	if (_time > _owner->scoreData()->_maxPieceTime) {
                debug("hidePiece called");
                if (_owner->gameData()->_gameType == UNBEARABLE_GAME) _time = 0;
		_owner->hidePiece();
        }

}

void CPiece::startTimer()
{
        if (_owner->gameData()->_gameType == PIECE_TIME_GAME || _owner->gameData()->_gameType == UNBEARABLE_GAME)
                _timerNr = QObject::startTimer(1000); debug("XXXstart");
}

void CPiece::stopTimer()
{
        if (_timerNr != -1) killTimer(_timerNr);
}
