/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "main.h"

#include "savedialog.h"

#include <kapp.h>

#include <qpushbutton.h>

CSaveDialog::CSaveDialog(QWidget* parent, bool savePixmap) : QDialog(parent,0,true)
{
        setCaption(i18n("Saving parameters"));

        QPushButton* bt;

        _vbox = new QVBoxLayout(this,30,20);

//         _addExt = new QCheckBox(i18n("&Add filename extension"),this);
// 	_addExt->setChecked(addExt);
//         _addExt->setEnabled(enableAddExt);

//         _vbox->addWidget(_addExt);

        _annLabel = new QLabel(this);
        _annLabel->setText(i18n("Annotation"));

        _vbox->addWidget(_annLabel);

        _annotation = new QMultiLineEdit(this);
        _annotation->setText("");

        _vbox->addWidget(_annotation);

        _savePixmap = new QCheckBox(i18n("&Save pixmap"),this);
        _savePixmap->setChecked(savePixmap);

        _vbox->addWidget(_savePixmap);

        _hbox = new QHBoxLayout(_vbox,15);

        bt = new QPushButton(i18n("OK"),this);
	bt->setDefault(true);
	connect(bt,SIGNAL(clicked()),this,SLOT(accept()));
        _hbox->addWidget(bt);
        _hbox->addSpacing(5);

	bt = new QPushButton(i18n("Cancel"),this);
	connect(bt,SIGNAL(clicked()),this,SLOT(reject()));
        _hbox->addWidget(bt);
        _hbox->addSpacing(5);

        bt = new QPushButton(i18n("Help"),this);
        connect(bt,SIGNAL(clicked()),this,SLOT(slotHelp()));
        _hbox->addWidget(bt);

        _vbox->activate();
}

CSaveDialog::~CSaveDialog()
{

}

void CSaveDialog::slotHelp()
{
        kapp->invokeHTMLHelp(HF_DIALOG_SAVEGAME,HA_DIALOG_SAVEGAME);
        debug("CSaveDialog: help invoked");
}

