#ifndef KPUZZLEWIDGET_H 
#define KPUZZLEWIDGET_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kstatusbar.h>
#include <ktmainwindow.h>

#include <qwidget.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qevent.h>
#include <qlcdnumber.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <qarray.h>
#include <qbitmap.h>

class KGameWidget;
class KPuzzleApp;
class CPieceWidget;
class CPicview;

// These game pixmaps may be used. Before any function uses one, it has to
// call useGamePixmap(int) to ensure the pixmap is available.
#define GP_BIGLOGO 0x1
#define GP_PAUSE 0x2
#define GP_WIN 0x4
#define GP_LOSE 0x8
#define GP_LOGO 0x10

class KPuzzleWidget : public QWidget
{
	Q_OBJECT
 public:
	KPuzzleWidget(QWidget *parent = 0, const char *name = 0);
	virtual ~KPuzzleWidget();

// Data
 public:
	int status();
	QLCDNumber* time() { return _time; }
	CPicview* picview() { return _picview; }
	CPicview* fullview() { return _fullview; }
	KGameWidget* gameWidget() { return _gameWidget; }
	CPieceWidget* pieceWidget() { return _pieceWidget; }
	KPuzzleApp* game() { return _game; }
	void setLargePxm(QPixmap* p) { _largePxm = p; }
	
	void useGamePixmap(int which);
	void freeGamePixmap(int which);

 protected:
	KGameWidget* _gameWidget;
	QPushButton* _bLeft;
	QPushButton* _bRight;
	QPushButton* _bUp;
	QPushButton* _bDown;

	CPieceWidget* _pieceWidget;
	QPushButton* _bNextPiece;
	QPushButton* _bPrevPiece;
	QPushButton* _bTurn1;
	QPushButton* _bTurn2;

	CPicview* _picview;
	CPicview* _fullview;

	QLCDNumber* _score;
	QLCDNumber* _time;

	KPuzzleApp* _game; 

	QPixmap* _largePxm;

	QPixmap* _logoPxm;
	QPixmap* _bigLogoPxm;
	QPixmap* _winPxm;
	QPixmap* _losePxm;
	QPixmap* _pausePxm;
	
	int _usedGamePixmaps;

 private:
	
// Implementation
 public:
	void updateAll();
	void updateButtons(bool b1,bool b2,bool b3,bool b4);
	void showStatusMsg(QString s,int time=0) { ((KTMainWindow*) parentWidget())->statusBar()->
							   message(s,time); }
	void hideStatusMsg() { ((KTMainWindow*) parentWidget())->statusBar()->clear(); }
	void createPlayground(bool unbearable);
	void destroyPlayground();
	void showAll(bool s);

 protected:
	virtual void paintEvent(QPaintEvent* e);
	virtual void mousePressEvent(QMouseEvent* e);

 public slots:
	void slotTerm(int reason);

 protected slots:
	void slotLoadBackgroundPixmap();

};

#endif // KPUZZLEWIDGET_H 
