/*
 * kpuzzle.cpp
 *
 * Copyright (C) 1999 Michael Wand <mwand@gmx.de>
 */
#include "main.h"

#include "kpuzzle.h"
#include "kpuzzleapp.h"

#include "prefs.h"
#include "gamedialog.h"

#include <qkeycode.h>
#include <qdialog.h>

#include <kfm.h>
#include <kiconloader.h>
#include <kapp.h>

KPuzzle::KPuzzle()
{
	_view = new KPuzzleWidget(this);
	setView(_view);

	// create a popup menu -- in this case, the File menu
	_filemenu = new QPopupMenu;
	_filemenu->insertItem("&New Game",_view->game(),SLOT(slotNewGame()),CTRL+Key_N,0);
	_filemenu->insertItem("&Stop Game",_view->game(),SLOT(slotStopGame()),CTRL+Key_S,1);
	_filemenu->insertSeparator();
	_filemenu->insertItem("&Properties",this,SLOT(slotSetOptions()));
	_filemenu->insertSeparator();
	_filemenu->insertItem("&Quit",kapp, SLOT(quit()), CTRL+Key_Q);

	// put our newly created menu into the main menu bar
	menuBar()->insertItem(i18n("&File"), _filemenu);

	// Game menu
	_gamemenu = new QPopupMenu;
	_gamemenu->insertItem(i18n("&Show large image"),_view->game(),SLOT(slotShowLarge()),CTRL+Key_S,0);
	_gamemenu->insertItem(i18n("&Pause"),_view->game(),SLOT(slotPause()),CTRL+Key_P,1);

	menuBar()->insertItem(i18n("&Game"),_gamemenu);
	menuBar()->insertSeparator();

	// KDE will generate a short help menu automagically
	QPopupMenu* p = kapp->getHelpMenu(true, 
			 i18n("KPuzzle --- KDE puzzle game\n\n"
					"(c) 2000 Michael Wand \n"
					"This is a KDE-based puzzle game."));
	menuBar()->insertItem(i18n("&Help"), p);

	// insert a quit button.  the icon is the standard one in KDE
	toolBar()->insertButton((const char*) DATAFILE("newgame.xpm"),0,
				SIGNAL(clicked()),_view->game(),SLOT(slotNewGame()),"New Game");
	toolBar()->insertButton((const char*) DATAFILE("pause.xpm"),1,SIGNAL(clicked()),
				_view->game(),SLOT(slotPause()),"Pause Game");
	toolBar()->insertButton((const char*) DATAFILE("stop.xpm"),2,SIGNAL(clicked()),
				_view->game(),SLOT(slotStopGame()));

	toolBar()->insertButton(Icon("exit.xpm"),   // icon
	                        3,                  // button id
				SIGNAL(clicked()),  // action
				kapp, SLOT(quit()), // result
				i18n("Exit"));      // tooltip text
	toolBar()->insertSeparator();
	toolBar()->insertButton((const char*) DATAFILE("large.xpm"),5,SIGNAL(clicked()),
		_view->game(),SLOT(slotShowLarge()),"Show large image");

	// we do want a status bar
	enableStatusBar();

	enableMenuItems(MI_NONE);
	
	readOptions();

}

KPuzzle::~KPuzzle()
{

}

void KPuzzle::enableMenuItems(int enable)
{
	_filemenu->setItemEnabled(1,enable & MI_STOP_GAME);
	_gamemenu->setItemEnabled(0,enable & MI_SHOW_LARGE);
	_gamemenu->setItemEnabled(1,enable & MI_PAUSE);

	toolBar()->setItemEnabled(1,enable & MI_PAUSE);
	toolBar()->setItemEnabled(2,enable & MI_STOP_GAME);
	toolBar()->setItemEnabled(5,enable & MI_SHOW_LARGE);
}

void KPuzzle::saveOptions()
{
	KConfig *config = kapp->getConfig();
	config->writeEntry("UsePieceMask",_usePieceMask);
	config->writeEntry("TurnPieceAround",_turnPiecesAround);
	config->writeEntry("ImageLoading",_imageLoading);
	config->writeEntry("PlayerName",_playerName);
	
}

void KPuzzle::readOptions()
{
	KConfig *config = kapp->getConfig();
	_usePieceMask = config->readBoolEntry("UsePieceMask",true);
	_turnPiecesAround = config->readBoolEntry("TurnPieceAround",true);
	_imageLoading = config->readNumEntry("ImageLoading",IL_ON_USE);
	_playerName = config->readEntry("PlayerName","");
}

void KPuzzle::slotSetOptions()
{
	bool timerActive = view()->game()->timerActive();
	if (timerActive) view()->game()->stopTimer();
	int res;
	CPrefsDialog dlg(this);
	dlg._usePieceMask = _usePieceMask;
	dlg._turnPiecesAround = _turnPiecesAround;
	dlg._imageLoading = _imageLoading;
	dlg.setValues();
	if ((res=dlg.exec()) != QDialog::Accepted) {
		if (timerActive) view()->game()->startTimer();
		return;
	}
	dlg.retrieveValues();
	if (dlg._imageLoading == IL_PRELOAD && _imageLoading != IL_PRELOAD) {
			_view->useGamePixmap(GP_BIGLOGO);
			_view->useGamePixmap(GP_LOGO);
			_view->useGamePixmap(GP_WIN);
			_view->useGamePixmap(GP_LOSE);
			_view->useGamePixmap(GP_PAUSE);
	}
	_usePieceMask = dlg._usePieceMask;
	_turnPiecesAround = dlg._turnPiecesAround;
	_imageLoading = dlg._imageLoading;
	saveOptions();
	if (timerActive) view()->game()->startTimer();
}
