/***************************************************************************
                          ksquare.cpp  -  description
                             -------------------
    begin                : Sat Nov 10 2001
    copyright            : (C) 2001 by Jos Pablo Fernndez
    email                : jpablo@di.uc3m.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpainter.h>

#include "ksquare.h"

#include <iostream.h>
 /* DEBUG */


KSquare::KSquare(QWidget *parent, const char *name,
	KSquare::Background the_background,
	KSquare::State state, int i, int j , int size, QImage *img_background, QImage *image) :
		QWidget(parent,name)
{ 	
	row = i ;
	col = j ;
	KSquare::size = size ; 	
	selected = false ;
	tiped = false ;
	
	KSquare::state = state ;
	KSquare::the_background = the_background ;
	setMinimumSize(size, size) ;
	setMaximumSize(size, size) ;

	pixmap = new QPixmap(size, size) ;
	setBackground(img_background) ;
	setImage(image) ;
}

KSquare::~KSquare(){
}

int KSquare::getRow()
{
	return row ;
}

int KSquare::getCol()
{
	return col ;
}

KSquare::State KSquare::getState()
{
	return state ;
}

void KSquare::select()
{
	selected = true ;
	draw() ;
}

void KSquare::unselect()
{
	selected = false ;
	draw() ;
}

bool KSquare::isSelected()
{
	return selected ;
}

void KSquare::tip(void) {
	tiped = true ;
	draw() ;
}

void KSquare::untip(void) {
	tiped = false ;
	draw() ;
}

void KSquare::draw(void) {
	QPainter paint ;
	/* pixmap->fill() ; */

	paint.begin(pixmap) ;
	/* paint.eraseRect(rect()); */

	if (backgroundPixmap() != 0)
		paint.drawPixmap(0, 0, *backgroundPixmap()) ;

	if (image != 0)
		paint.drawImage(0, 0, *image) ;

	if (selected) {
		paint.setPen(Qt::yellow) ;
		paint.drawRect(rect()) ;
	}

	if (tiped) {
		paint.setBrush(Qt::green) ;
		paint.setPen(Qt::green) ;
		paint.drawEllipse(
			rect().x()+rect().width()*3/8, rect().y()+height()*3/8,
			rect().width()*2/8, rect().height()*2/8 ) ;
	}
	paint.end() ;
	update() ;
}

void KSquare::setBackground(QImage *img_background)
{
	if (img_background == 0)
		return ;
	QPainter paint ;
	QPixmap *pixmap_background = new QPixmap (size, size) ;
	paint.begin(pixmap_background) ;
	paint.drawImage(0,0, *img_background) ;
	paint.end() ;
	setBackgroundPixmap(*pixmap_background) ;
}

void KSquare::setImage(QImage *image)
{
	KSquare::image = image ;
	draw() ;
}

QImage *KSquare::getImage()
{
	return(image) ;
}

void KSquare::paintEvent (QPaintEvent *)
{
	if (backgroundPixmap() == 0)
		return ;

	bitBlt(this, 0, 0, pixmap) ;	
}

void KSquare::mousePressEvent (QMouseEvent *mouseevent)
{
		emit changeRequest(KSquare::Non, this) ;
}

void KSquare::setState (State state, QImage *image)
{
	KSquare::state = state ;
	KSquare::image = image ;
	draw() ;
}

void KSquare::setBackground (Background background)
{
	KSquare::the_background = background ;
	/* update() ; */ /* Es necesario dibujar? */
}
