/***************************************************************************
                          midata.h  -  description
                             -------------------
    begin                : Wed Nov 14 2001
    copyright            : (C) 2001 by Jos?Pablo Fern?dez
    email                : jpablo@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MIDATA_H
#define MIDATA_H

#include "astardata.h"
#include "matrix.h"
#include "tree.h"
#include <qarray.h>

/**
  *@author Jos?Pablo Fern?dez
  */
#define None -1
#define Vacia 0
#define Ocupada 1

#define Norte 0
#define Sur 1
#define Este 2
#define Oeste 3

class MiData : public AStarData  {
public: 
	MiData();
	MiData(MiData &data);	
	virtual ~MiData(void) ;
	int get(int i, int j) ;
	void set(int i, int j, int data) ;
	virtual void init(void) ;
	virtual bool isGoal(void) ;
	virtual Tree<AStarData> *sucesors(void) ;
	int calculate_h() ;
	Matrix<int> get_matriz() ;
	virtual bool isEqual(MiData data2) ;
	void print() ;
	
Matrix<int> matriz  ;

	int start_x ;
	int start_y ;
	int end_x ;
	int end_y ;

private:
	bool posicionValida(int i, int j) ;
};

#endif
