/***************************************************************************
                          kmudplugin.h
                      -------------------
    description          : base class for all plugins
    begin                : Mon May 15 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KMUDPLUGIN_H
#define KMUDPLUGIN_H

#include <qobject.h>
//#include "kmudapi.h"
class KmudAPI;

/**
	* Base class for all plugins
  *@author Stephan Uhlmann
	*
	* every plugin must reimplement the virtual methods start() and stop()
	* start() is for doing things when the plugin is activated
	* note that the time when the plugin is loaded and when it is
	* activated can differ (that's why we have start() and don't
	* use the constructor).
	* stop() is for cleaning up things when the plugin is halted.
	* good idea is to insert and remove the plugin from the plugin
	* menu in start/stop
  */

class KmudPlugin : public QObject  {
	Q_OBJECT

public:
	/** constructor */
	KmudPlugin();
	/** destructor */
	~KmudPlugin();

	// pure virtual methods which have to be implemented by the plugin

	/** start the plugin */
	virtual void start()=0;
	/** stop the plugin */
	virtual void stop()=0;


	// methods called in CMudStream

	/** process the user input */
	virtual QString processInput(QString);

	/** process the raw mud output (as it come from the mud with all
	  * ansi codes etc.)
		*/
	virtual QString processRawOutput(QString);

	/** process the parsed mud output (after it went through Kmuds filters
	  * for filtering out ansi codes etc.)
		*/
	virtual QString processParsedOutput(QString);



	/** call configuration dialog, blocks until dialog is closed */
	virtual void callConfigDialog();


	void init(KmudAPI* pkmud);

	QString getName();
	QString getVersion();
	QString getDescription();
	QString getAuthor();
	QString getEmail();
	QString getHomepage();
	QString getCopyright();
	bool isConfigurable();

protected:
	/** name of the plugin */
	QString name;
	/** plugin version */
	QString version;
	/** description of the plugin */
	QString description;
	/** author's name */
	QString author;
	/** contact email */
	QString email;
	/** plugin homepage */
	QString homepage;
	/** copyright of the plugin */
	QString copyright;

	/** true when the plugin has a configuration dialog */
	bool configurable;


	/** pointer to the KmudApp class */
	KmudAPI*	kmudapi;


};

#endif
