/***************************************************************************
                          kmuddoc.cpp
                      -------------------
    description          : Document Class (Character Database)
    begin                : Sun Jun 20 14:17:54 MEST 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kmuddoc.h"


KmudDoc::KmudDoc(QObject *parent, const char *filename):QObject(parent)
{
	currentIndex=0;
	currentProfIndex=0;
	currentMudIndex=0;

	currentCharacterID="";
	currentMudID="";

	aliasesDisabled = false;
	
	readCharDB();
}

KmudDoc::~KmudDoc()
{
	writeCharDB();
}

void KmudDoc::readCharDB()
{
	QFileInfo fi(QDir::homeDirPath()+"/.kde/share/apps/kmud/chardb");

	if (fi.exists())
	{
		KSimpleConfig chardb(QDir::homeDirPath()+"/.kde/share/apps/kmud/chardb");
		QString groupname;
		CharDBEntry* entry;
		KGroupIterator* gi;

		db.setAutoDelete(true);
		db.clear();

		readProfs();
		readMuds();

		gi=chardb.groupIterator();

		gi->toFirst();
		while (gi->current())
		{
			groupname=gi->currentKey();

			if (groupname!="<default>")
			{
				entry = new CharDBEntry;
				entry->ID=groupname;
				chardb.setGroup(groupname);
				entry->login=chardb.readEntry("Login","");
				entry->password=decodePassword(chardb.readEntry("Password",""));
				entry->profile=chardb.readEntry("ProfileFile","");
				entry->mudfile=chardb.readEntry("MudFile","");

				db.append(entry);
			}
			++(*gi);
		}
		delete gi;

	} // if (fi.exists())
	else
	{
		QDir localKmudDir;

		localKmudDir.setCurrent(QDir::homeDirPath());
		localKmudDir.mkdir(".kde",false);
		localKmudDir.mkdir(".kde/share",false);
		localKmudDir.mkdir(".kde/share/apps",false);
		localKmudDir.mkdir(".kde/share/apps/kmud",false);
		localKmudDir.mkdir(".kde/share/apps/kmud/profiles",false);
		localKmudDir.mkdir(".kde/share/apps/kmud/muds",false);
	}
}

void KmudDoc::writeCharDB()
{
	QDir localKmudDir;
	KSimpleConfig chardb(QDir::homeDirPath()+"/.kde/share/apps/kmud/chardb");
	QString groupname;
	KGroupIterator* gi;
	int i;

	localKmudDir.setCurrent(QDir::homeDirPath());
	localKmudDir.mkdir(".kde",false);
	localKmudDir.mkdir(".kde/share",false);
	localKmudDir.mkdir(".kde/share/apps",false);
	localKmudDir.mkdir(".kde/share/apps/kmud",false);


	gi=chardb.groupIterator();
	gi->toFirst();
	while (gi->current())
	{
		groupname=gi->currentKey();
		chardb.deleteGroup(groupname);
//  ++(*gi);  // this did't work. deleting items and then incrementing iterator is bad
		gi->toFirst(); // always delete first item
	}
	delete gi;

	chardb.sync();

	// write profs + muds
	for (i=0;(unsigned int)i<db.count();i++)
	{
		chardb.setGroup(db.at(i)->ID);
		chardb.writeEntry("Login",db.at(i)->login);
		chardb.writeEntry("Password",encodePassword(db.at(i)->password));
		chardb.writeEntry("ProfileFile",getCharacterProfile(db.at(i)->profile)->getFileName());
		chardb.writeEntry("MudFile",getMudProfile(db.at(i)->mudfile)->getFileName());
	}

	writeProfs();
	writeMuds();
}

void KmudDoc::readProfs()
{
	QDir localKmudDir;
	QStrList files;
	CCharacterProfile* prof;
	unsigned int i;

	profs.setAutoDelete(true);
	profs.clear();

	// if it's not there... create it
	localKmudDir.setCurrent(QDir::homeDirPath());
	localKmudDir.mkdir(".kde",false);
	localKmudDir.mkdir(".kde/share",false);
	localKmudDir.mkdir(".kde/share/apps",false);
	localKmudDir.mkdir(".kde/share/apps/kmud",false);
	localKmudDir.mkdir(".kde/share/apps/kmud/profiles",false);

	localKmudDir.setPath(QDir::homeDirPath()+"/.kde/share/apps/kmud/profiles/");
	localKmudDir.setNameFilter("*.prof");
	localKmudDir.setFilter(QDir::Files);
	
	if (localKmudDir.exists() && localKmudDir.isReadable())
	{
		files=*localKmudDir.entryList();

		for (i=0; i < files.count(); i++)
		{
			prof = new CCharacterProfile();
			prof->setFileName(files.at(i));
			prof->readData();
			insertCharacterProfile(prof);
		}
	}
}

void KmudDoc::writeProfs()
{
	QDir localKmudDir;
	unsigned int i;

	localKmudDir.setCurrent(QDir::homeDirPath());
	localKmudDir.mkdir(".kde",false);
	localKmudDir.mkdir(".kde/share",false);
	localKmudDir.mkdir(".kde/share/apps",false);
	localKmudDir.mkdir(".kde/share/apps/kmud",false);
	localKmudDir.mkdir(".kde/share/apps/kmud/profiles",false);

	for (i=0;i < profs.count();i++)
		profs.at(i)->writeData();
}

void KmudDoc::readMuds()
{
	QDir localKmudDir;
	QStrList files;
	unsigned int i;
	CMudProfile* mud;


	muds.setAutoDelete(true);
	muds.clear();

	// if it's not there... create it
	localKmudDir.setCurrent(QDir::homeDirPath());
	localKmudDir.mkdir(".kde",false);
	localKmudDir.mkdir(".kde/share",false);
	localKmudDir.mkdir(".kde/share/apps",false);
	localKmudDir.mkdir(".kde/share/apps/kmud",false);
	localKmudDir.mkdir(".kde/share/apps/kmud/muds",false);

	localKmudDir.setPath(QDir::homeDirPath()+"/.kde/share/apps/kmud/muds/");
	localKmudDir.setNameFilter("*.mud");
	localKmudDir.setFilter(QDir::Files);

	if (localKmudDir.exists() && localKmudDir.isReadable())
	{
		files=*localKmudDir.entryList();

		for (i=0; i < files.count(); i++)
		{
			mud = new CMudProfile();
			mud->setFileName(files.at(i));
			mud->readData();
			insertMudProfile(mud);
		}
	}
}

void KmudDoc::writeMuds()
{
	QDir localKmudDir;
	unsigned int i;

	localKmudDir.setCurrent(QDir::homeDirPath());
	localKmudDir.mkdir(".kde",false);
	localKmudDir.mkdir(".kde/share",false);
	localKmudDir.mkdir(".kde/share/apps",false);
	localKmudDir.mkdir(".kde/share/apps/kmud",false);
	localKmudDir.mkdir(".kde/share/apps/kmud/muds",false);

	for (i=0;i < muds.count();i++)
		muds.at(i)->writeData();
}

void KmudDoc::insertEntry(QString ID, QString login, QString password,CCharacterProfile* pprof, CMudProfile* pmud)
{
	CharDBEntry* entry;
	CCharacterProfile* prof;
	CMudProfile* mud;

	entry=first();
	while ((entry!=NULL) && (entry->ID!=ID) ) 
		entry=next();
	if (entry==NULL) // if not in list -> insert
	{
		entry = new CharDBEntry;

		entry->ID=ID;
		entry->login=login;
		entry->password=password;

		prof=profs.first(); // check if prof is already in list...
		while ((prof!=NULL) && (prof->getFileName()!=pprof->getFileName()))
			prof=profs.next();

		if (prof==NULL) // ...if not take the given
			insertCharacterProfile(pprof);
		entry->profile=pprof->getFileName();

		mud=muds.first(); // check if mud is already in list...
		while ((mud!=NULL) && (mud->getFileName()!=pmud->getFileName()))
			mud=muds.next();

		if (mud==NULL) // ...if not take the given
			insertMudProfile(pmud);
		entry->mudfile=pmud->getFileName();

		db.append(entry);
	} //end if not in list -> insert
}

void KmudDoc::deleteEntry(QString ID)
{
	QString mudfile="", profile="";
	CharDBEntry* entry;
	CCharacterProfile* charprof;
	CMudProfile* mudprof;
	bool usedbymore;


	entry=db.first();
	while (entry!=NULL)
	{
		if (entry->ID==ID) // if it's the same ID
		{
			profile=entry->profile; // remember character profile
			mudfile=entry->mudfile;   // and mud profile

			db.remove(entry); // remove from list
		}
		entry=db.next();
	}

	usedbymore=false; // check if entry was the only entry that used the profile
	entry=db.first();
	while (entry!=NULL)
	{
		if (entry->profile==profile) // if it's the same file
			usedbymore=true;    // it's used by more
		entry=db.next();
	}

	if ((!usedbymore) && (profile!="")) // if not used by more
	{
		charprof=getCharacterProfile(profile);
		deleteCharacterProfile(charprof);         // delete it
	}

	usedbymore=false; // check if entry was the only entry that used the profile
	entry=db.first();
	while (entry!=NULL)
	{
		if (entry->mudfile==mudfile) // if it's the same file
			usedbymore=true;    // it's used by more
		entry=db.next();
	}

	if ((!usedbymore) && (mudfile!="")) // if not used by more
	{
		mudprof=getMudProfile(mudfile);
		deleteMudProfile(mudprof);         // delete it
	}
}


int KmudDoc::insertCharacterProfile(CCharacterProfile* cp)
{
	if (!profs.contains(cp))
		profs.append(cp);
	return profs.at();
}

void KmudDoc::deleteCharacterProfile(CCharacterProfile* cp)
{
	profs.remove(cp);
}

int KmudDoc::insertMudProfile(CMudProfile* mp)
{
	if (!muds.contains(mp))
		muds.append(mp);

	return muds.at();
}

void KmudDoc::deleteMudProfile(CMudProfile* mp)
{
	muds.remove(mp);
}

CharDBEntry* KmudDoc::first()
{
	currentIndex=0;
	if (db.count() > 0)
		return db.at(0);
	return NULL;
}

CharDBEntry* KmudDoc::next()
{
	currentIndex++;
	if (db.count() > (unsigned int)currentIndex) 
		return db.at(currentIndex);
	return NULL;
}

CharDBEntry* KmudDoc::current()
{
	if (db.count() > (unsigned int)currentIndex) 
		return db.at(currentIndex);
	return NULL;
}


CharDBEntry* KmudDoc::getEntry(QString login,QString mudTitle)
{
	CharDBEntry* entry;
	CMudProfile* mud;

	entry=first();
	while (entry!=NULL)
	{
		mud = getMudProfile(entry->mudfile);
		if ((entry->login==login) && (mud->getTitle()==mudTitle)) 
			return entry;
		entry=next();
	}

	return NULL;
}

CharDBEntry* KmudDoc::getEntry(QString ID)
{
	CharDBEntry* entry;
	CMudProfile* mud;

	entry=first();
	while (entry!=NULL)
	{
		mud = getMudProfile(entry->mudfile);
		if (entry->ID==ID) return entry;
		entry=next();
	}

	return NULL;
}


CCharacterProfile* KmudDoc::getCharacterProfile(QString filename)
{
	unsigned int i;

	for (i=0;i < profs.count();i++)
		if (profs.at(i)->getFileName()==filename)
			return profs.at(i);
	return NULL;
}

CMudProfile* KmudDoc::getMudProfile(QString filename)
{
	unsigned int i;

	for (i=0;i < muds.count();i++)
		if (muds.at(i)->getFileName()==filename)
			return muds.at(i);
	return NULL;
}

CCharacterProfile* KmudDoc::firstProf()
{
	currentProfIndex=0;
	if (profs.count() > 0) 
		return profs.at(0);
	return NULL;
}

CCharacterProfile* KmudDoc::nextProf()
{
	currentProfIndex++;
	if (profs.count() > (unsigned int)currentProfIndex) 
		return profs.at(currentProfIndex);
	return NULL;
}

CCharacterProfile* KmudDoc::currentProf()
{
	if (profs.count() > (unsigned int)currentProfIndex) 
		return profs.at(currentProfIndex);
	return NULL;
}

unsigned int KmudDoc::numProfs()
{
	return profs.count();
}


CMudProfile* KmudDoc::firstMud()
{
	currentMudIndex=0;
	if (muds.count() > 0) 
		return muds.at(0);
	return NULL;
}

CMudProfile* KmudDoc::nextMud()
{
	currentMudIndex++;
	if (muds.count() > (unsigned int)currentMudIndex) 
		return muds.at(currentMudIndex);
	return NULL;
}

CMudProfile* KmudDoc::currentMud()
{
	if (muds.count() > (unsigned int)currentMudIndex) 
		return muds.at(currentMudIndex);
	return NULL;
}

unsigned int KmudDoc::numMuds()
{
	return muds.count();
}


QString KmudDoc::getCurrentCharacterID()
{
	return currentCharacterID;
}

QString KmudDoc::getCurrentMudID()
{
	return currentMudID;
}

void KmudDoc::setCurrentCharacterID(QString s)
{
	currentCharacterID=s;
}

void KmudDoc::setCurrentMudID(QString s)
{
	currentMudID=s;
}

/** applies "encryption" on the password */
QString KmudDoc::encodePassword(QString pw)
{
	QString out=pw.copy();
	unsigned int i;

	for (i=0;i<pw.length();i++)
		out[i]=( (char)( (unsigned int)pw[i] ^ 20 ) );

	return out;
}

/** decodes the password */
QString KmudDoc::decodePassword(QString pw)
{
	return encodePassword(pw);
}

/** if the history should react intelligent returns it TRUE */
bool KmudDoc::getIntelligentHistory()
{
	return intelligentHistory;
} // getIntelligentHistory

/** the intelligentHistoryFlag will be set */
void KmudDoc::setIntelligentHistory(bool i)
{
	intelligentHistory = i;
} // setIntelligentHistory

QString KmudDoc::getPingExecutable()
{
  return pingExecutable;
}

void KmudDoc::setPingExecutable(QString ping)
{
  pingExecutable = ping;
}

bool KmudDoc::getPingEnabled()
{
  return pingEnabled;
}

void KmudDoc::setPingEnabled(bool enabled)
{
  pingEnabled = enabled;
}


bool KmudDoc::getAliasesDisabled()
{
  return aliasesDisabled;
}

void KmudDoc::setAliasesDisabled(bool disable)
{
  aliasesDisabled = disable;
}

/** set state of trigger execution */
void KmudDoc::setTriggersDisabled(bool disable)
{
  triggersDisabled = disable;
}

/** get state of trigger execution. true means it is disabled */
bool KmudDoc::getTriggersDisabled()
{
  return triggersDisabled;
}
