/***************************************************************************
                          dlgmaproomexits.cpp  -  description
                             -------------------
    begin                : Fri Sep 22 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "dlgmaproomexits.h"
#include <kapp.h>

DlgMapRoomExits::DlgMapRoomExits(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
	
	lstExits->clear();
	lstExits->setMultiSelection(false);
	
	connect(cmdDel,SIGNAL(clicked()),SLOT(slotDeleteExit()));
}

DlgMapRoomExits::~DlgMapRoomExits()
{
}

void DlgMapRoomExits::addExit(QString str)
{ lstExits->insertItem(str,-1); }

int DlgMapRoomExits::getNumExits(void)
{ return lstExits->count(); }

QString DlgMapRoomExits::getExit(int index)
{
	return lstExits->text(index);
}

void DlgMapRoomExits::slotDeleteExit(void)
{
	if (lstExits->count()>0)
		lstExits->removeItem(lstExits->currentItem());
}