/***************************************************************************
                          cmapdata.h
                      -------------------
    description          : Used to store map data
    begin                : Wed Oct 20 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef CMAPDATA_H
#define CMAPDATA_H

#include <qcolor.h>
#include <qstring.h>
#include <qstack.h>
#include <qlist.h>

#include <kapp.h>

#include "cmaproom.h"

//class CMapRoom

class CMapData
{
public:
	CMapData();
	~CMapData();
	
	/** Used to read the map data */
	void readData(void);	
	/** Used to write the map data */
	void writeData(void);
	/** Used to add a room to the speed walk list */	
	void addSpeedwalkRoom(CMapRoom *room);
	/** Used to delete a room from the speed walk list. */	
	bool delSpeedwalkRoom(CMapRoom *room);	
	
public:
	/** The delay between each speed walk move in centi-seconds */
	int speedwalkDelay;
	/** The rooms that are to be speed walked */
	QStack<QString> pathToWalk;
	/** Used to tell if speed walking is in progress */
	bool speedwalkActive;
	/** This is used to store a list of zones */
	QList<CMapZone> zoneList;
	/** A poitner to the speed walk list */
	QList<CMapRoom> speedwalkList;	
	/** Used to say what catogery is being used to display the speed walk list */
	int speedwalkCatogrize;

	// Used to store the colour values
	QColor gridColour;
	QColor backgroundColour;
	QColor defaultRoomColour;
	QColor defaultPathColour;
	QColor lowerRoomColour;
	QColor lowerPathColour;
	QColor higherRoomColour;
	QColor higherPathColour;
	QColor defaultTextColour;
	QColor selectedColour;
	QColor specialColour;	
	QColor loginColour;
	QColor editColour;
	QColor currentColour;
};

#endif