/***************************************************************************
                          kmudview.h
                      -------------------
    description          : View Class (Main View)
    begin                : Sun Jun 20 14:17:54 MEST 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KMUDVIEW_H 
#define KMUDVIEW_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <qwidget.h>
#include <qfont.h>
#include <qregexp.h>
#include "cmudview.h"
#include "ansi.h"
#include "cmudlineedit.h"

#include "kmuddoc.h"


/**
  * This class provides the Kmud application view.
  *@author Stephan Uhlmann, Andre Alexander Bell
  */

class KmudView : public QWidget
{
  Q_OBJECT

 public:
	/** Constructor for the main view */
	KmudView(KApplication* a=0,KmudDoc* doc=0,QWidget *parent = 0);
	/** Destructor for the main view */
	~KmudView();

	/** returns input string but without ansi and special chars etc. */
	QString displayMudOutput(QString);

	void setDebugHighlightColor(QColor);
	QColor getDebugHighlightColor();

	void setOutputForegroundColor(QColor);
	QColor getOutputForegroundColor();

	void setOutputBackgroundColor(QColor);
	QColor getOutputBackgroundColor();
	void setOutputActualBackgroundColor(QColor);

	void setOutputFont(QFont);
	QFont getOutputFont();

	void setInputFont(QFont);
	QFont getInputFont();

	void setInputBackgroundColor(QColor);
	QColor getInputBackgroundColor();

	void setLocalEchoColor(QColor);
	QColor getLocalEchoColor();

	void setInterpretType(int);
	int getInterpretType();

	void setSeparator(QString s);
	QString getSeparator();

	void setUseBeep(bool u);
	bool getUseBeep();

	void setOutputANSIColor(int ANSIColor, QColor color);
	QColor getOutputANSIColor(int ANSIColor);

	void setOutputBgColor(int BgColor, QColor color);
	QColor getOutputBgColor(int BgColor);
	
	bool getLocalEcho();
	int getLocalEchoMode();
	bool getLocalEchoSupressNewline();
	void setLocalEchoSupressNewline(bool);
	bool getInputEcho();
	int getInputEchoMode();
	
	void setKeepLastInput(bool);
	bool getKeepLastInput();
	
	void setSelectAllOnFocus(bool);
	bool getSelectAllOnFocus();
	
	void setAutoTime(unsigned int t);
	unsigned int getAutoTime();
	
	void setAutoReconnect(bool);
	bool getAutoReconnect();
	/** returns the Inputline */
	CMudLineEdit* getInput ();


	/** returns whether special chars are enabled or not */
	bool getEnableSpecialChars();
	/** sets whether special chars are enabled or not */
	void setEnableSpecialChars(bool);
  /** sets the character, that starts a speedwalking-sequence */
  void setSpeedwalkingChar (QString s);
  /** returns the character, that starts a speedwalking sequence */
  QString getSpeedwalkingChar ();
  /** returns the ExternCommandChar */
  QString getExternChar();
  /** set's the external command char */
  void setExternChar (QString externChar);

	void setMaxHistoryLines(int);
	void setMaxMudViewLines(int);
	void setSharedInputHistory(bool);
	

 public slots:
	void slotInputReturnPressed (QString s);
	// returns input string but without ansi and special chars etc.
	QString slotAppendToOutput(QString);
	void setLocalEcho(bool);
	void setLocalEchoMode(int);
	void setInputEcho(bool);
	void setInputEchoMode(int);
	void setAltInput(bool);

	void slotMudClosed();
	void slotMacroPressed(QString);
	
	void slotChangeSplitMode(bool);

 signals:
	void enteredInput(QString);


 protected:

	virtual void resizeEvent(QResizeEvent *);

 private:

	void recalcWidgetSizes();

	/** resolves all aliases in incoming string and returns result */
	QString resolveAliases(QString);

	/** output from mud */
	CMudView* output;
	/** output from mud when in splitmode */
	CMudView* splitoutput;
	/** input line */
	CMudLineEdit* input;
	/** alternatove input line */
	CMudLineEdit* input2;
	bool autoReconnect;
	bool localEcho;
	int localEchoMode;
	bool localEchoSuppressNewline;
	bool inputEcho;
	int inputEchoMode;
	QColor localEchoColor;
	unsigned int autoTime;
	bool splitMode;

	bool enableSpecialChars;
	/** The separating character */
	QString separator;
  /** the character, that starts a speedwalking-sequence */
  QString speedwalkingChar;
  /** the Character, that show's, that the following string is an external command */
  QString externCommandChar;

	KmudDoc* document;

};

#endif // KMUDVIEW_H 
