/***************************************************************************
                      dlgpluginmanager.cpp
                      --------------------
    description          :
    begin                : Sat Aug 5 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgpluginmanager.h"
#include <kapp.h>
#include <qheader.h>
#include "../kmudplugin.h"

DlgPluginManager::DlgPluginManager(CPluginManager* ppluginmanager, QWidget *parent, const char *name) : QDialog(parent,name,true){

	PluginInfo* info;
	int i;
	QCheckListItem* item;

	setCaption(i18n("Plugin Manager"));
	initDialog();

	configure_Button->setEnabled(false);

	connect( ok_Button, SIGNAL(clicked()), SLOT(accept()) );
	connect( cancel_Button, SIGNAL(clicked()), SLOT(reject()) );
	connect( configure_Button, SIGNAL(clicked()), SLOT(slotConfigure()) );

	pluginmanager = ppluginmanager;
	pluginlist = pluginmanager->getAllPlugins();

	// create but hide the column header
	plugin_ListView->addColumn( "" );
  plugin_ListView->header()->hide();


	for (i=0;i<(int)pluginlist.count();i++)
	{
		info = pluginlist.at(i);
		// load plugin now
    if (info->state == UNLOADED) pluginmanager->loadPlugin(info->filename);
		item = new QCheckListItem(plugin_ListView, info->pointer->getName(), QCheckListItem::CheckBox);
    if (info->state == RUNNING)
			item->setOn(true);
		else item->setOn(false);
	}

	connect( plugin_ListView, SIGNAL(selectionChanged()), SLOT(showPluginInfo()) );

}

DlgPluginManager::~DlgPluginManager(){
}

PluginInfo* DlgPluginManager::getSelectedPlugin()
{
	int i;
	PluginInfo* returnInfo=NULL;
	PluginInfo* info;

	for (i=0;i<(int)pluginlist.count();i++)
	{
		info = pluginlist.at(i);
    if ( info->pointer->getName() == QString(((QCheckListItem*)(plugin_ListView->currentItem()))->text()) )
		{
			returnInfo=info;
		}
	}
	return returnInfo;
}


void DlgPluginManager::showPluginInfo()
{
	PluginInfo* info;

	info=getSelectedPlugin();
  if (info!=NULL)
	{
		fileShow_Label->setText(info->pathfilename);
		versionShow_Label->setText(info->pointer->getVersion());
		copyrightShow_Label->setText(info->pointer->getCopyright());
		authorShow_Label->setText(info->pointer->getAuthor());
		emailShow_Label->setText(info->pointer->getEmail());
		homepageShow_Label->setText(info->pointer->getHomepage());
		descriptionShow_MultiLineEdit->setText(info->pointer->getDescription());
		if (info->pointer->isConfigurable()) configure_Button->setEnabled(true);
			else configure_Button->setEnabled(false);
	}
}

QStrList DlgPluginManager::getCheckedPlugins()
{
	QStrList list;
	int i;
	QCheckListItem* item;
	PluginInfo* info;

	item=(QCheckListItem*)plugin_ListView->firstChild();
	while (item!=NULL)
	{
		if (item->isOn()==true)
		{
			for (i=0;i<(int)pluginlist.count();i++)
			{
				info = pluginlist.at(i);
				if (info->pointer->getName() == item->text(0))
				list.append(info->filename);
			}
		}
		item=(QCheckListItem*)item->nextSibling();
	}

	return list;

}

QStrList DlgPluginManager::getUncheckedPlugins()
{
	QStrList list;
	int i;
	QCheckListItem* item;
	PluginInfo* info;

	item=(QCheckListItem*)plugin_ListView->firstChild();
	while (item!=NULL)
	{
		if (item->isOn()==false)
		{
			for (i=0;i<(int)pluginlist.count();i++)
			{
				info = pluginlist.at(i);
				if (info->pointer->getName() == item->text(0))
				list.append(info->filename);
			}
		}
		item=(QCheckListItem*)item->nextSibling();
	}

	return list;
}

void DlgPluginManager::slotConfigure()
{
	PluginInfo* info;

	info=getSelectedPlugin();
  if (info!=NULL)
	{
		info->pointer->callConfigDialog();
	}
}

